/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.rfplanning.domain.service.m;

import com.tplink.smb.omada.common.util.G;
import com.tplink.smb.omada.device.manage.message.inform.ap.ApBssidInfo;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.ap.ApDTO;
import com.tplink.smb.omada.monitor.rfplanning.domain.service.dto.e;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class c {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);

    private c() {
    }

    public static HashMap<String, String> a(List<String> scanApMacList, e request, int radioId) {
        HashMap<String, String> allScanApBssidMap = new HashMap<String, String>();
        for (String apMac : scanApMacList) {
            ApDTO apDTO = request.Q().get(apMac);
            if (apDTO == null || apDTO.getDeviceStatus() == null) continue;
            List bssidInfos = apDTO.getDeviceStatus().getBssidInfos();
            List<Object> bssids = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)bssidInfos)) {
                bssids = bssidInfos.stream().map(ApBssidInfo::getBssid).collect(Collectors.toList());
            }
            List<Object> extraBssidList = new ArrayList();
            switch (radioId) {
                case 0: {
                    extraBssidList = c.a(apMac);
                    break;
                }
                case 1: {
                    extraBssidList = c.b(apMac);
                    if (!apDTO.getCapability().getSupport5g2().booleanValue()) break;
                    extraBssidList.addAll(c.c(apMac));
                    break;
                }
                case 3: {
                    extraBssidList = c.a(apMac, apDTO.getCapability().getSupport5g2());
                    break;
                }
                default: {
                    a.warn("generateAllScanApBssidMap radioId is not correct, radioId: {}", (Object)radioId);
                }
            }
            bssids.addAll(extraBssidList);
            if (CollectionUtils.isEmpty(bssids)) {
                a.debug("RFPlanning omadacId={} The bssids of ap {} is not exist, bssid {}", new Object[]{request.b(), apMac, bssids});
                continue;
            }
            for (String string : bssids) {
                if (string == null || Objects.equals(string, apMac)) continue;
                allScanApBssidMap.put(string, apMac);
            }
        }
        return allScanApBssidMap;
    }

    public static Map<String, String> a(Map<String, ApDTO> apDTOMap) {
        HashMap<String, String> allApBssidMap = new HashMap<String, String>();
        for (Map.Entry<String, ApDTO> entry : apDTOMap.entrySet()) {
            String apMac = entry.getKey();
            ApDTO apDTO = entry.getValue();
            if (apDTO == null || apDTO.getDeviceStatus() == null) continue;
            List bssidInfos = apDTO.getDeviceStatus().getBssidInfos();
            List<Object> bssids = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)bssidInfos)) {
                bssids = bssidInfos.stream().map(ApBssidInfo::getBssid).collect(Collectors.toList());
            }
            ArrayList<String> extraBssidList = new ArrayList<String>();
            if (Boolean.TRUE.equals(apDTO.getCapability().getSupport2g())) {
                extraBssidList.addAll(c.a(apMac));
            }
            if (Boolean.TRUE.equals(apDTO.getCapability().getSupport5g())) {
                extraBssidList.addAll(c.b(apMac));
            }
            if (Boolean.TRUE.equals(apDTO.getCapability().getSupport5g2())) {
                extraBssidList.addAll(c.c(apMac));
            }
            if (Boolean.TRUE.equals(apDTO.getCapability().getSupport6g())) {
                extraBssidList.addAll(c.a(apMac, Boolean.TRUE.equals(apDTO.getCapability().getSupport5g2())));
            }
            bssids.addAll(extraBssidList);
            if (CollectionUtils.isEmpty(bssids)) continue;
            for (String string : bssids) {
                if (string == null || Objects.equals(string, apMac)) continue;
                allApBssidMap.put(string, apMac);
            }
        }
        return allApBssidMap;
    }

    private static List<String> a(String apMac) {
        ArrayList<String> bssidList = new ArrayList<String>();
        for (int index = 0; index < 17; ++index) {
            if (index == 0) {
                bssidList.add(apMac);
                continue;
            }
            bssidList.add(c.a(apMac, index));
        }
        return bssidList;
    }

    private static List<String> b(String apMac) {
        ArrayList<String> bssidList = new ArrayList<String>();
        String startBssid = G.a((String)apMac, (int)1);
        for (int index = 0; index < 17; ++index) {
            if (index == 0) {
                bssidList.add(startBssid);
                continue;
            }
            bssidList.add(c.a(startBssid, index));
        }
        return bssidList;
    }

    private static List<String> c(String apMac) {
        ArrayList<String> bssidList = new ArrayList<String>();
        String startBssid = G.a((String)apMac, (int)2);
        for (int index = 0; index < 17; ++index) {
            if (index == 0) {
                bssidList.add(startBssid);
                continue;
            }
            bssidList.add(c.a(startBssid, index));
        }
        return bssidList;
    }

    public static List<String> a(String apMac, boolean support5g2) {
        ArrayList<String> bssidList = new ArrayList<String>();
        int num = support5g2 ? 3 : 2;
        for (int index = 0; index < 17; ++index) {
            bssidList.add(c.b(apMac, index));
        }
        return bssidList;
    }

    private static String a(String apMac, int index) {
        String[] macStr = apMac.split("-");
        int bssidNum = Integer.parseInt(macStr[0], 16);
        int tempBssidNum = (bssidNum & 0xFC) + (index << 2) & 0xFC;
        bssidNum = bssidNum & 3 | tempBssidNum | 2;
        macStr[0] = String.format("%02X", bssidNum);
        StringBuilder stringBuilder = new StringBuilder();
        for (String str : macStr) {
            stringBuilder.append(str).append("-");
        }
        return stringBuilder.toString().substring(0, 17);
    }

    private static String b(String apMac, int index) {
        String[] macStr = apMac.split("-");
        int bssidNum0 = Integer.parseInt(macStr[0], 16);
        int bssidNum5 = Integer.parseInt(macStr[5], 16);
        int tempBssidNum = bssidNum5 & 0xF;
        bssidNum5 &= 0xF0;
        macStr[0] = String.format("%02X", bssidNum0 |= 2);
        macStr[5] = String.format("%02X", bssidNum5 |= (tempBssidNum + index) % 16);
        StringBuilder stringBuilder = new StringBuilder();
        for (String str : macStr) {
            stringBuilder.append(str).append("-");
        }
        return stringBuilder.toString().substring(0, 17);
    }
}

