/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.rfplanning.domain.service.c;

import com.tplink.smb.omada.monitor.api.shared.a.c;
import com.tplink.smb.omada.monitor.statistic.common.dto.client.RssiLevelQueryDTO;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    private static final long b = 3600L;
    private static final int c = 0;
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.c.a.a d;
    @Autowired
    private com.tplink.smb.omada.monitor.api.c.a.a.a e;
    private static final DateTimeFormatter f = new DateTimeFormatterBuilder().appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendValue(ChronoField.HOUR_OF_DAY, 2).toFormatter(Locale.ROOT);

    public Map<Integer, Integer> a(String omadacId, String siteId, String mac, int radioId) {
        long endSec = LocalDateTime.now(ZoneOffset.UTC).toInstant(ZoneOffset.UTC).toEpochMilli() / 1000L;
        long startSec = LocalDateTime.now(ZoneOffset.UTC).minusHours(24L).toInstant(ZoneOffset.UTC).toEpochMilli() / 1000L;
        RssiLevelQueryDTO rssiLevelQuery = new RssiLevelQueryDTO();
        rssiLevelQuery.setOmadacId(omadacId);
        rssiLevelQuery.setSiteId(siteId);
        rssiLevelQuery.setMac(mac);
        rssiLevelQuery.setStartSec(Long.valueOf(startSec));
        rssiLevelQuery.setEndSec(Long.valueOf(endSec));
        Map<Integer, Integer> rssiLevelClientCountMap = new HashMap<Integer, Integer>();
        switch (com.tplink.smb.omada.monitor.api.shared.a.c.a((Integer)radioId)) {
            case a: {
                rssiLevelClientCountMap = this.a(endSec, rssiLevelQuery, com.tplink.smb.omada.monitor.api.shared.a.c.a);
                break;
            }
            case b: {
                rssiLevelClientCountMap = this.a(endSec, rssiLevelQuery, com.tplink.smb.omada.monitor.api.shared.a.c.b);
                break;
            }
            case c: {
                rssiLevelClientCountMap = this.a(endSec, rssiLevelQuery, com.tplink.smb.omada.monitor.api.shared.a.c.c);
                break;
            }
            case d: {
                rssiLevelClientCountMap = this.a(endSec, rssiLevelQuery, com.tplink.smb.omada.monitor.api.shared.a.c.d);
                break;
            }
        }
        return rssiLevelClientCountMap;
    }

    private Map<Integer, Integer> a(long endSec, RssiLevelQueryDTO rssiLevelQuery, c radioEnum) {
        long timeFormat;
        LocalDateTime localDateTime;
        List apClientRssiLevelList = this.d.a(rssiLevelQuery, radioEnum);
        Map<Integer, Integer> rssiLevlClientCountMap = this.a(apClientRssiLevelList);
        long gapHour = this.a(endSec, apClientRssiLevelList);
        if (gapHour == 0L) {
            return rssiLevlClientCountMap;
        }
        String omadacId = rssiLevelQuery.getOmadacId();
        String siteId = rssiLevelQuery.getSiteId();
        String mac = rssiLevelQuery.getMac();
        if (gapHour > 2L) {
            localDateTime = LocalDateTime.ofEpochSecond(endSec - 3600L, 0, ZoneOffset.UTC);
            timeFormat = Long.parseLong(f.format(localDateTime));
            Map rssiLevelMapMinus1Hour = this.e.b(omadacId, siteId, timeFormat);
            this.a(mac, radioEnum.a(), rssiLevlClientCountMap, rssiLevelMapMinus1Hour);
        }
        localDateTime = LocalDateTime.ofEpochSecond(endSec, 0, ZoneOffset.UTC);
        timeFormat = Long.parseLong(f.format(localDateTime));
        Map rssiLevelMapCurHour = this.e.b(omadacId, siteId, timeFormat);
        this.a(mac, radioEnum.a(), rssiLevlClientCountMap, rssiLevelMapCurHour);
        return rssiLevlClientCountMap;
    }

    private long a(long end, List<com.tplink.smb.omada.monitor.api.web.statistic.dto.a.a> apClientRssiLevelListAtSingleBand) {
        long gapHour;
        long time = 0L;
        if (!CollectionUtils.isEmpty(apClientRssiLevelListAtSingleBand)) {
            com.tplink.smb.omada.monitor.api.web.statistic.dto.a.a apClientRssiLevelAtSingleBand = apClientRssiLevelListAtSingleBand.stream().max(Comparator.comparing(com.tplink.smb.omada.monitor.api.web.statistic.dto.a.a::f)).get();
            time = apClientRssiLevelAtSingleBand.f();
        }
        if ((gapHour = (end - time) / 3600L + 1L) < 0L) {
            gapHour = 0L;
        }
        return gapHour;
    }

    private Map<Integer, Integer> a(List<com.tplink.smb.omada.monitor.api.web.statistic.dto.a.a> apClientRssiLevelList) {
        HashMap<Integer, Integer> levelToCountMap = new HashMap<Integer, Integer>();
        if (CollectionUtils.isEmpty(apClientRssiLevelList)) {
            return levelToCountMap;
        }
        for (com.tplink.smb.omada.monitor.api.web.statistic.dto.a.a apClientRssiLevel : apClientRssiLevelList) {
            List rssiLevelClientCountList = apClientRssiLevel.e();
            if (CollectionUtils.isEmpty((Collection)rssiLevelClientCountList)) continue;
            rssiLevelClientCountList.forEach(rssiLevelClientCount -> {
                int level = rssiLevelClientCount.a();
                int count = rssiLevelClientCount.b();
                levelToCountMap.put(level, levelToCountMap.getOrDefault(level, 0) + count);
            });
        }
        return levelToCountMap;
    }

    private void a(String targetMac, int targetBand, Map<Integer, Integer> levelToCountMap, Map<String, Integer> rssiLevelMap) {
        if (!CollectionUtils.isEmpty(rssiLevelMap)) {
            for (Map.Entry<String, Integer> next : rssiLevelMap.entrySet()) {
                String hashKey = next.getKey();
                String[] split = hashKey.split(":");
                if (split.length != 5) {
                    a.error("hashKey{} construction error.", (Object)hashKey);
                    return;
                }
                String mac = split[0];
                int band = Integer.parseInt(split[2]);
                if (!targetMac.equals(mac) || targetBand != band) continue;
                int level = Integer.parseInt(split[4]);
                levelToCountMap.put(level, levelToCountMap.getOrDefault(level, 0) + next.getValue());
            }
        }
    }
}

