/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.cloud;

import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.component.upgradefilecache.api.DownloadCallback;
import com.tplink.smb.omada.cloud.api.internal.dto.BatchGetAvailableFwChannelsReqDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.BatchGetAvailableFwChannelsRespDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.BatchGetHighestFwChannelsReqDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.BatchGetHighestFwChannelsRespDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.BizFirmwareInfoDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.DeviceTokenDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.GetAvailableFwChannelReqDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.GetAvailableFwChannelsRespDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.GetCaCertificateDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.GetCaCertificateReqDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.GetCaCertificateRespDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.GetFwSeriesInfoListReqDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.GetHighestFwChannelReqDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.GetHighestFwChannelsRespDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.GetTargetFirmwareReqDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.GetTargetFirmwareRespDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.TargetFirmwareReqDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.TargetFirmwareRespDTO;
import com.tplink.smb.omada.cloud.api.internal.e;
import com.tplink.smb.omada.cloud.omada.service.c;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.W;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.cloud.dto.FirmwareHistoryResp;
import com.tplink.smb.omada.manager.cloud.dto.FirmwareInfoDTO;
import com.tplink.smb.omada.manager.cloud.dto.a;
import com.tplink.smb.omada.manager.cloud.dto.b;
import com.tplink.smb.omada.manager.cloud.g;
import com.tplink.smb.omada.manager.configuration.domain.model.site.R;
import com.tplink.smb.omada.manager.configuration.domain.model.site.z;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.d;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.l;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.BatchUpgradeRequestDTO;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.CloudDeviceUpgradeAdaptor;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.CloudDeviceUpgradeService;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.FirmwareBasicInfoDTO;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.ModelTypeInfo;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.OnlineUpgradeStatusCache;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.QueryTargetVersionFwDTO;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.UpgradeFwInfoDTO;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.h;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.q;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.r;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.t;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class f
implements CloudDeviceUpgradeAdaptor {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(f.class);
    @Autowired
    @Lazy
    private l b;
    @Autowired
    private R c;
    @Autowired
    private r d;
    @Autowired
    private OnlineUpgradeStatusCache e;
    @Autowired
    private com.tplink.smb.omada.manager.device.domain.model.upgrade.a.b f;
    @Autowired
    private com.tplink.smb.omada.cloud.api.internal.a g;
    @Autowired
    private com.tplink.smb.omada.system.api.internal.c h;
    @Autowired
    private CloudDeviceUpgradeService i;
    @Autowired
    private com.tplink.smb.omada.manager.common.audit.a j;
    @Autowired
    private e k;
    @Autowired
    private com.tplink.smb.omada.manager.device.domain.model.upgrade.a.a l;
    @Autowired
    @Lazy
    private com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.f m;
    @Autowired
    private c n;
    private static final String o = "en_US";
    private static final int p = -24702;
    private static final int q = -20501;
    private static final int r = -10200;
    private static final int s = 35000;
    private static final int t = 40000;
    private static final int u = 15000;

    public OperationResponse a(com.tplink.smb.omada.manager.j.a.a.c omadacId, @Nullable h checkFwCallback) {
        return (OperationResponse)this.f.c(omadacId, () -> {
            a.info("omadacId:{}, Checking Device Last Firmware...", (Object)omadacId.a());
            this.g.d();
            List<d> deviceImageList = this.a(omadacId);
            Map<String, q> modelFwInfo = this.f(omadacId, deviceImageList);
            Set<Map.Entry<String, q>> modelFwInfoSet = modelFwInfo.entrySet();
            ArrayList<q> queryList = new ArrayList<q>(10);
            boolean allSuccess = true;
            for (Map.Entry<String, q> modelFwInfoEntry : modelFwInfoSet) {
                if (modelFwInfoEntry.getValue() == null) continue;
                queryList.add(modelFwInfoEntry.getValue());
                if (queryList.size() != 10) continue;
                OperationResponse res = this.a(queryList, omadacId.a());
                if (!res.success()) {
                    a.info("Failed to check last firmware for 10 model, one model is compoundModel({}), currentFwVer({}).", (Object)((q)queryList.get(0)).e(), (Object)((q)queryList.get(0)).f());
                }
                queryList.clear();
            }
            if (!CollectionUtils.isEmpty(queryList)) {
                OperationResponse res = this.a(queryList, omadacId.a());
                if (!res.success()) {
                    allSuccess = false;
                    a.info("Failed to check last firmware for {} model, one model is compoundModel({}), currentFwVer({}).", new Object[]{queryList.size(), ((q)queryList.get(0)).e(), ((q)queryList.get(0)).f()});
                }
                queryList.clear();
            }
            for (d deviceImage : deviceImageList) {
                OnlineUpgradeStatusCache.a onlineUpgradeStatus = this.e.getDeviceUpgradeInfo(omadacId.a(), deviceImage.al().a());
                if (onlineUpgradeStatus == null || onlineUpgradeStatus.a() != OnlineUpgradeStatusCache.a.a.a()) continue;
                this.e.removeDeviceUpgradeInfo(omadacId.a(), deviceImage.al().a());
            }
            if (checkFwCallback != null) {
                if (allSuccess) {
                    checkFwCallback.a();
                } else {
                    checkFwCallback.b();
                }
            }
            return OperationResponse.SUCCESS;
        }, () -> {
            a.warn("A device firmware checking task is already running.");
            if (checkFwCallback != null) {
                checkFwCallback.b();
            }
            return new OperationResponse(com.tplink.smb.omada.common.g.b.zT);
        });
    }

    public OperationResponse a(com.tplink.smb.omada.manager.j.a.a.c omadacId, G deviceMac) {
        this.g.d();
        d deviceImage = this.b.a(omadacId, deviceMac).orElse(null);
        if (deviceImage == null) {
            return OperationResponse.PARAM_ERROR;
        }
        ArrayList<d> checkList = new ArrayList<d>();
        checkList.add(deviceImage);
        Map<String, q> modelFwInfo = this.f(omadacId, checkList);
        this.a(new ArrayList<q>(modelFwInfo.values()), omadacId.a());
        return OperationResponse.SUCCESS;
    }

    private Map<String, q> f(com.tplink.smb.omada.manager.j.a.a.c omadacId, List<d> deviceImageList) {
        HashMap<String, q> modelFwInfo = new HashMap<String, q>();
        if (CollectionUtils.isEmpty(deviceImageList)) {
            return modelFwInfo;
        }
        for (d deviceImage : deviceImageList) {
            String compoundModel = deviceImage.aX().x();
            String firmwareVersion = deviceImage.aX().B();
            String oemId = deviceImage.aX().y();
            if (com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.b((String)compoundModel, (String)firmwareVersion)) {
                a.warn("Firmware version({}) of ap {} {} is in incompatible firmware versions, so ignores this firmware.", new Object[]{firmwareVersion, omadacId, deviceImage.al()});
                continue;
            }
            q model = this.d.a(compoundModel, firmwareVersion, oemId).orElse(null);
            if (model != null) {
                modelFwInfo.put(model.e() + model.f() + model.h(), model);
                continue;
            }
            a.info("can't find modelFw, model{} {}", (Object)compoundModel, (Object)firmwareVersion);
        }
        return modelFwInfo;
    }

    private OperationResponse a(List<q> queryList, String omadacId) {
        if (CollectionUtils.isEmpty(queryList)) {
            return OperationResponse.SUCCESS;
        }
        BatchGetAvailableFwChannelsReqDTO batchGetAvailableFwChannelsReqDTO = new BatchGetAvailableFwChannelsReqDTO();
        ArrayList<GetAvailableFwChannelReqDTO> cloudQueryList = new ArrayList<GetAvailableFwChannelReqDTO>();
        batchGetAvailableFwChannelsReqDTO.setQueryList(cloudQueryList);
        batchGetAvailableFwChannelsReqDTO.setBizId(omadacId);
        for (q modelFw : queryList) {
            String modelModelVersion = modelFw.e();
            String curVer = modelFw.f();
            if (T.a((String)modelFw.g()) || T.a((String)modelFw.h())) {
                modelFw = com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.a((String)modelModelVersion);
                if (modelFw == null || T.a((String)modelFw.g()) || T.a((String)modelFw.h())) {
                    a.warn("Failed to get model information from local map file for model({}).", (Object)modelModelVersion);
                    continue;
                }
                modelFw.a(Integer.valueOf(q.a.a.a()));
            }
            GetAvailableFwChannelReqDTO getAvailableFwChannelReqDTO = this.a(modelFw, curVer);
            cloudQueryList.add(getAvailableFwChannelReqDTO);
        }
        if (cloudQueryList.size() < 1) {
            return OperationResponse.SUCCESS;
        }
        batchGetAvailableFwChannelsReqDTO.setQueryList(cloudQueryList);
        JSONObject request = new JSONObject(x.a((Object)batchGetAvailableFwChannelsReqDTO));
        a.debug("query fw info {} from tpcloud in {}", (Object)request.toString(), (Object)omadacId);
        try {
            JSONObject response = this.k.g(request);
            if (response == null) {
                a.warn("Get empty response from server.");
                return new OperationResponse(com.tplink.smb.omada.common.g.b.ao);
            }
            a.debug("get fw info {} from tpcloud in {}", (Object)response.toString(), (Object)omadacId);
            int errorCode = response.getInt("error_code");
            if (errorCode == 0) {
                BatchGetAvailableFwChannelsRespDTO batchGetAvailableFwChannelsRespDTO = (BatchGetAvailableFwChannelsRespDTO)x.a((String)x.a((Object)response.getJSONObject("result")), BatchGetAvailableFwChannelsRespDTO.class);
                this.a(batchGetAvailableFwChannelsRespDTO, queryList);
            }
            for (q modelFw : queryList) {
                this.a(modelFw);
            }
        }
        catch (IOException ioException) {
            a.info("onlineCheckDeviceLastFw IOException occurs when sending req('{}').", (Object)"batchGetAvailableFwChannels", (Object)ioException);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ao, null);
        }
        return OperationResponse.SUCCESS;
    }

    public void a(q modelFw) {
        if (T.c((String)modelFw.e())) {
            a.warn("Invalid model information: {}.", (Object)modelFw);
            return;
        }
        if (T.c((String)modelFw.g()) || T.c((String)modelFw.h())) {
            q fixModelFw = com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.a((String)modelFw.e());
            if (fixModelFw == null) {
                a.warn("Failed to get model information by {} from local map file.", (Object)modelFw.e());
            } else {
                modelFw = fixModelFw;
            }
        }
        this.d.a(modelFw);
    }

    private GetAvailableFwChannelReqDTO a(q existedModelFw, String curVer) {
        GetAvailableFwChannelReqDTO request = new GetAvailableFwChannelReqDTO();
        request.setHwId(com.tplink.smb.omada.common.util.b.b.e((String)existedModelFw.g()));
        request.setOemId(com.tplink.smb.omada.common.util.b.b.e((String)existedModelFw.h()));
        request.setFwVer(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c((String)curVer));
        if (Boolean.TRUE.equals(existedModelFw.d())) {
            request.setControllerVersion(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c((String)"6.1.0.19"));
        } else {
            request.setControllerVersion(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c((String)"6.1.0.19"));
        }
        request.setLocale(o);
        request.setSecureUrlEnabled(Boolean.valueOf(true));
        return request;
    }

    private void a(BatchGetAvailableFwChannelsRespDTO batchGetAvailableFwChannelsRespDTO, List<q> queryList) {
        List channelList = batchGetAvailableFwChannelsRespDTO.getChannelList();
        if (CollectionUtils.isEmpty((Collection)channelList)) {
            return;
        }
        Map deviceChannelMap = channelList.stream().collect(Collectors.toMap(dto -> dto.getHwId() + dto.getOemId() + dto.getFwVer(), Function.identity(), (a2, b2) -> b2));
        for (int i2 = 0; i2 < queryList.size(); ++i2) {
            q existedModelFw = queryList.get(i2);
            String deviceKey = com.tplink.smb.omada.common.util.b.b.e((String)existedModelFw.g()) + com.tplink.smb.omada.common.util.b.b.e((String)existedModelFw.h()) + com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c((String)existedModelFw.f());
            GetAvailableFwChannelsRespDTO getAvailableFwChannelsRespDTO = deviceChannelMap.getOrDefault(deviceKey, null);
            if (getAvailableFwChannelsRespDTO == null || CollectionUtils.isEmpty((Collection)getAvailableFwChannelsRespDTO.getStable())) {
                existedModelFw.h(null);
                existedModelFw.k(null);
                existedModelFw.j(null);
                existedModelFw.b(Integer.valueOf(0));
                existedModelFw.i(null);
                existedModelFw.m(null);
                continue;
            }
            BizFirmwareInfoDTO bizFirmwareInfoDTO = (BizFirmwareInfoDTO)getAvailableFwChannelsRespDTO.getStable().get(0);
            existedModelFw.h(bizFirmwareInfoDTO.getFwVer());
            existedModelFw.k(bizFirmwareInfoDTO.getFwReleaseLog());
            existedModelFw.l(bizFirmwareInfoDTO.getFwReleaseDate());
            existedModelFw.j(bizFirmwareInfoDTO.getFwTitle());
            existedModelFw.i(bizFirmwareInfoDTO.getFwSecureUrl());
            existedModelFw.m(bizFirmwareInfoDTO.getFwMD5() == null ? null : bizFirmwareInfoDTO.getFwMD5().toLowerCase(Locale.ROOT));
        }
    }

    public void a() {
        this.g.d();
    }

    public boolean b() {
        OperationResponse response = this.h.a();
        if (!response.success()) {
            return false;
        }
        return (Boolean)response.getResult();
    }

    public DownloadCallback a(BatchUpgradeRequestDTO info) {
        return new g(this, info);
    }

    private List<d> a(com.tplink.smb.omada.manager.j.a.a.c omadacId) {
        List sites = this.c.a(omadacId);
        ArrayList<d> deviceImageList = new ArrayList<d>();
        if (CollectionUtils.isEmpty((Collection)sites)) {
            return deviceImageList;
        }
        for (z site : sites) {
            deviceImageList.addAll(this.b.a(omadacId, site.b()));
        }
        return deviceImageList;
    }

    public OperationResponse<Map<String, List<FirmwareBasicInfoDTO>>> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, List<t> queryList) {
        this.g.d();
        HashMap fwHistoryMap = new HashMap();
        if (CollectionUtil.isEmpty(queryList)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, fwHistoryMap);
        }
        String startDate = W.d((long)-1L);
        OperationResponse<List<FirmwareInfoDTO>> fwSeriesInfoListResp = null;
        for (t omadacModelFwInfo : queryList) {
            fwSeriesInfoListResp = this.a(omadacModelFwInfo, startDate, omadacId.a());
            if (!fwSeriesInfoListResp.success()) {
                a.error("failed get history fw info from cloud, omadacModelFwInfo:{}", (Object)omadacModelFwInfo);
                continue;
            }
            List basicInfoDTOS = ((List)fwSeriesInfoListResp.getResult()).stream().map(firmwareInfoDTO -> com.tplink.smb.omada.manager.cloud.dto.b.a(omadacModelFwInfo, firmwareInfoDTO)).collect(Collectors.toList());
            fwHistoryMap.put((CallSite)((Object)(omadacModelFwInfo.c() + omadacModelFwInfo.b())), basicInfoDTOS);
        }
        if (fwHistoryMap.isEmpty() && null != fwSeriesInfoListResp) {
            a.error("get fwSeriesInfoListResp fw info from cloud, fwHistoryMap is null.");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)fwSeriesInfoListResp.getErrorCode()), null);
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, fwHistoryMap);
    }

    public OperationResponse<Map<String, UpgradeFwInfoDTO>> b(com.tplink.smb.omada.manager.j.a.a.c omadacId, List<QueryTargetVersionFwDTO> queryList) {
        HashMap<String, UpgradeFwInfoDTO> res = new HashMap<String, UpgradeFwInfoDTO>();
        if (CollectionUtils.isEmpty(queryList)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, res);
        }
        this.g.d();
        Map<String, String> oemIdHwIdAndModelTargetVersionMap = queryList.stream().collect(Collectors.toMap(query -> query.getOemId() + query.getHwId(), query -> query.getCompoundModel() + query.getTargetVersion()));
        ArrayList<TargetFirmwareReqDTO> queryPageList = new ArrayList<TargetFirmwareReqDTO>(20);
        for (QueryTargetVersionFwDTO queryTargetVersionFwDTO : queryList) {
            TargetFirmwareReqDTO targetFirmwareReqDTO = new TargetFirmwareReqDTO();
            targetFirmwareReqDTO.setHwId(queryTargetVersionFwDTO.getHwId());
            targetFirmwareReqDTO.setOemId(queryTargetVersionFwDTO.getOemId());
            targetFirmwareReqDTO.setFwVer(queryTargetVersionFwDTO.getTargetVersion());
            targetFirmwareReqDTO.setLocale(o);
            targetFirmwareReqDTO.setSecureUrlEnabled(Boolean.valueOf(true));
            if (Boolean.TRUE.equals(queryTargetVersionFwDTO.getPro())) {
                targetFirmwareReqDTO.setControllerVersion(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c((String)"6.1.0.19"));
            } else {
                targetFirmwareReqDTO.setControllerVersion(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c((String)"6.1.0.19"));
            }
            queryPageList.add(targetFirmwareReqDTO);
            OperationResponse<GetTargetFirmwareRespDTO> pageTargetFirmware = this.b(queryPageList, omadacId.a());
            if (!pageTargetFirmware.success()) {
                a.warn("omadacId:{}, Query tgetTargetFirmware from tp cloud failed.", (Object)omadacId.a());
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)pageTargetFirmware.getErrorCode()), null);
            }
            for (TargetFirmwareRespDTO targetFwResDTO : ((GetTargetFirmwareRespDTO)pageTargetFirmware.getResult()).getFwList()) {
                UpgradeFwInfoDTO upgradeFwInfoDTO = new UpgradeFwInfoDTO();
                upgradeFwInfoDTO.setOemId(targetFwResDTO.getOemId());
                upgradeFwInfoDTO.setHwId(targetFwResDTO.getHwId());
                upgradeFwInfoDTO.setFwUrl(targetFwResDTO.getFwSecureUrl());
                upgradeFwInfoDTO.setFwMD5((String)Optional.ofNullable(targetFwResDTO.getFwMD5()).map(String::toLowerCase).orElse(null));
                upgradeFwInfoDTO.setIsRevoked(targetFwResDTO.getIsRevoked());
                res.put(oemIdHwIdAndModelTargetVersionMap.get(upgradeFwInfoDTO.getOemId() + upgradeFwInfoDTO.getHwId()), upgradeFwInfoDTO);
            }
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, res);
    }

    public OperationResponse<Map<String, FirmwareBasicInfoDTO>> c(com.tplink.smb.omada.manager.j.a.a.c omadacId, List<QueryTargetVersionFwDTO> queryList) {
        HashMap<CallSite, FirmwareBasicInfoDTO> res = new HashMap<CallSite, FirmwareBasicInfoDTO>();
        if (CollectionUtils.isEmpty(queryList)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, res);
        }
        this.g.d();
        ArrayList<TargetFirmwareReqDTO> queryPageList = new ArrayList<TargetFirmwareReqDTO>(20);
        ArrayList cloudResultList = new ArrayList();
        try {
            for (QueryTargetVersionFwDTO queryTargetVersionFwDTO : queryList) {
                TargetFirmwareReqDTO targetFirmwareReqDTO = new TargetFirmwareReqDTO();
                targetFirmwareReqDTO.setHwId(queryTargetVersionFwDTO.getHwId());
                targetFirmwareReqDTO.setOemId(queryTargetVersionFwDTO.getOemId());
                targetFirmwareReqDTO.setFwVer(queryTargetVersionFwDTO.getTargetVersion());
                targetFirmwareReqDTO.setLocale(o);
                targetFirmwareReqDTO.setSecureUrlEnabled(Boolean.valueOf(true));
                if (Boolean.TRUE.equals(queryTargetVersionFwDTO.getPro())) {
                    targetFirmwareReqDTO.setControllerVersion(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c((String)"6.1.0.19"));
                } else {
                    targetFirmwareReqDTO.setControllerVersion(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c((String)"6.1.0.19"));
                }
                queryPageList.add(targetFirmwareReqDTO);
                if (queryPageList.size() != 20) continue;
                OperationResponse<GetTargetFirmwareRespDTO> pageTargetFirmware = this.b(queryPageList, omadacId.a());
                if (!pageTargetFirmware.success()) {
                    a.warn("omadacId:{}, Query batchGetTargetFirmwareInfo size=20 from tp cloud failed {}.", (Object)omadacId.a(), (Object)com.tplink.smb.omada.common.util.e.a.a(queryPageList));
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)pageTargetFirmware.getErrorCode()), null);
                }
                cloudResultList.addAll(((GetTargetFirmwareRespDTO)pageTargetFirmware.getResult()).getFwList());
                queryPageList.clear();
            }
            if (!queryPageList.isEmpty()) {
                Iterator pageTargetFirmware = this.b(queryPageList, omadacId.a());
                if (!pageTargetFirmware.success()) {
                    a.warn("omadacId:{}, Query batchGetTargetFirmwareInfo from tp cloud failed {}.", (Object)omadacId.a(), (Object)com.tplink.smb.omada.common.util.e.a.a(queryPageList));
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)pageTargetFirmware.getErrorCode()), null);
                }
                cloudResultList.addAll(((GetTargetFirmwareRespDTO)pageTargetFirmware.getResult()).getFwList());
            }
            for (TargetFirmwareRespDTO targetFwResDTO : cloudResultList) {
                FirmwareBasicInfoDTO firmwareBasicInfoDTO = new FirmwareBasicInfoDTO();
                firmwareBasicInfoDTO.setOemId(com.tplink.smb.omada.common.util.b.b.d((String)targetFwResDTO.getOemId()));
                firmwareBasicInfoDTO.setHwId(com.tplink.smb.omada.common.util.b.b.d((String)targetFwResDTO.getHwId()));
                firmwareBasicInfoDTO.setVersion(targetFwResDTO.getFwVer());
                firmwareBasicInfoDTO.setFwUrl(targetFwResDTO.getFwSecureUrl());
                firmwareBasicInfoDTO.setMd5((String)Optional.ofNullable(targetFwResDTO.getFwMD5()).map(String::toLowerCase).orElse(null));
                firmwareBasicInfoDTO.setIsRevoked(targetFwResDTO.getIsRevoked());
                firmwareBasicInfoDTO.setStatus(Optional.ofNullable(com.tplink.smb.omada.manager.device.domain.model.upgrade.c.a((String)targetFwResDTO.getStatus())).map(com.tplink.smb.omada.manager.device.domain.model.upgrade.c::a).orElse(com.tplink.smb.omada.manager.device.domain.model.upgrade.c.a.a()));
                firmwareBasicInfoDTO.setChannel(Optional.ofNullable(com.tplink.smb.omada.manager.device.domain.model.upgrade.b.b((String)targetFwResDTO.getChannel())).map(com.tplink.smb.omada.manager.device.domain.model.upgrade.b::a).orElse(com.tplink.smb.omada.manager.device.domain.model.upgrade.b.a.a()));
                res.put((CallSite)((Object)(firmwareBasicInfoDTO.getHwId() + firmwareBasicInfoDTO.getOemId() + targetFwResDTO.getFwVer())), firmwareBasicInfoDTO);
            }
        }
        catch (Exception e2) {
            a.error("getTargetFw failed, omadacId:{}, queryList:{}, cloudResultList:{}", new Object[]{omadacId, queryList, cloudResultList, e2});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.b);
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, res);
    }

    public OperationResponse<Map<String, List<UpgradeFwInfoDTO>>> d(com.tplink.smb.omada.manager.j.a.a.c omadacId, List<t> queryList) {
        new UpgradeFwInfoDTO();
        this.g.d();
        HashMap result = new HashMap();
        ArrayList<t> queryPageList = new ArrayList<t>(10);
        for (t omadacModelFwInfo : queryList) {
            queryPageList.add(omadacModelFwInfo);
            if (queryPageList.size() != 10) continue;
            OperationResponse<Map<String, List<UpgradeFwInfoDTO>>> response = this.g(omadacId, queryPageList);
            if (!response.success()) {
                a.warn("Failed to getBatchGetAvailableFwChannels size=10, req:{}", queryPageList);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)response.getErrorCode()));
            }
            result.putAll((Map)response.getResult());
            queryPageList.clear();
        }
        if (!CollectionUtils.isEmpty(queryPageList)) {
            OperationResponse<Map<String, List<UpgradeFwInfoDTO>>> response = this.g(omadacId, queryPageList);
            if (!response.success()) {
                a.warn("Failed to getBatchGetAvailableFwChannels, req:{}", queryPageList);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)response.getErrorCode()));
            }
            result.putAll((Map)response.getResult());
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
    }

    public OperationResponse<Map<String, List<FirmwareBasicInfoDTO>>> e(com.tplink.smb.omada.manager.j.a.a.c omadacId, List<t> queryList) {
        this.g.d();
        HashMap result = new HashMap();
        if (CollectionUtil.isEmpty(queryList)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
        }
        ArrayList<t> queryPageList = new ArrayList<t>(10);
        for (t omadacModelFwInfo : queryList) {
            queryPageList.add(omadacModelFwInfo);
            if (queryPageList.size() != 10) continue;
            OperationResponse<Map<String, List<FirmwareBasicInfoDTO>>> response = this.h(omadacId, queryPageList);
            if (!response.success()) {
                a.warn("Failed to getBatchGetHighestFwChannels size=10, req:{}", queryPageList.get(0));
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)response.getErrorCode()));
            }
            result.putAll((Map)response.getResult());
            queryPageList.clear();
        }
        if (!CollectionUtils.isEmpty(queryPageList)) {
            OperationResponse<Map<String, List<FirmwareBasicInfoDTO>>> response = this.h(omadacId, queryPageList);
            if (!response.success()) {
                a.warn("Failed to getBatchGetHighestFwChannels, req:{}", queryPageList.get(0));
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)response.getErrorCode()));
            }
            result.putAll((Map)response.getResult());
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
    }

    public OperationResponse a(@Nullable com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.g callBack) {
        return (OperationResponse)this.l.a("ca.certificate.update", () -> {
            a.info("Checking Last Ca Certification...");
            this.g.d();
            List caCertificates = this.m.b();
            if (CollectionUtils.isEmpty((Collection)caCertificates)) {
                return this.a(new HashSet<String>(), caCertificates);
            }
            long checkTime = System.currentTimeMillis();
            Set<String> needUpdateCaSet = caCertificates.stream().filter(caCertificate -> {
                long updateTime = caCertificate.g() == null ? 0L : caCertificate.g();
                long timeInterval = caCertificate.d() == null ? 0L : caCertificate.d();
                return checkTime - updateTime > timeInterval * 1000L;
            }).map(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.e::a).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(needUpdateCaSet)) {
                return this.a(needUpdateCaSet, caCertificates);
            }
            return OperationResponse.SUCCESS;
        }, () -> {
            a.warn("A ca certification checking task is already running.");
            if (callBack != null) {
                callBack.b();
            }
            return new OperationResponse(com.tplink.smb.omada.common.g.b.bA);
        });
    }

    private OperationResponse a(Set<String> needUpdateCaSet, List<com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.e> caCertificates) {
        OperationResponse response = this.h.d();
        if (!response.success()) {
            a.warn("updateCaCertifications can not get deviceId when update ca certification.");
            return response;
        }
        String deviceId = (String)response.getResult();
        GetCaCertificateReqDTO getCaCertificateReqDTO = new GetCaCertificateReqDTO();
        getCaCertificateReqDTO.setGroupName("cdn_commercial_root_ca");
        String serviceUrl = this.a(deviceId, "nbu.cvm-server-v2", getCaCertificateReqDTO);
        JSONObject request = new JSONObject(x.a((Object)getCaCertificateReqDTO));
        if (serviceUrl == null) {
            return OperationResponse.PARAM_ERROR;
        }
        a.debug("query ca certification from cvmServer.");
        try {
            String requestUrl = serviceUrl + "/v1/certificate/group/get-ca-certificate";
            JSONObject postResponse = this.a(requestUrl, request);
            if (postResponse == null) {
                a.warn("Get empty response from server.");
                return new OperationResponse(com.tplink.smb.omada.common.g.b.ao);
            }
            a.debug("get ca certification from cvmServer. {}", (Object)postResponse.toString());
            int errorCode = postResponse.getInt("code");
            if (errorCode != 0) {
                a.warn("get ca certification from cvmServer with errorCode:{}", (Object)errorCode);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.au);
            }
            GetCaCertificateRespDTO getCaCertificateRespDTO = (GetCaCertificateRespDTO)x.a((String)x.a((Object)postResponse.getJSONObject("result")), GetCaCertificateRespDTO.class);
            a.debug("get ca certification from cvmServer with size:{}", (Object)(getCaCertificateRespDTO.getCaList() == null ? 0 : getCaCertificateRespDTO.getCaList().size()));
            this.a(getCaCertificateRespDTO, needUpdateCaSet, caCertificates);
        }
        catch (Exception e2) {
            a.info("onlineUpdateCaCertification Exception occurs when sending request('{}').", (Object)"group/get-ca-certificate", (Object)e2);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ao);
        }
        return OperationResponse.SUCCESS;
    }

    private String a(String deviceId, String serviceId, GetCaCertificateReqDTO getCaCertificateReqDTO) {
        if (deviceId != null) {
            DeviceTokenDTO deviceTokenDTO = this.n.a(deviceId, serviceId);
            if (deviceTokenDTO == null) {
                a.warn("generalCaCertificateUrl can not get deviceId when update ca certification.");
                return null;
            }
            String deviceToken = deviceTokenDTO.getDeviceToken();
            getCaCertificateReqDTO.setDeviceToken(deviceToken);
            return deviceTokenDTO.getServiceUrl();
        }
        getCaCertificateReqDTO.setGroupName("");
        if (OmadacType.q()) {
            // empty if block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject a(String serviceUrl, JSONObject request) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, InterruptedException {
        HttpPost httpPost = null;
        Future future = null;
        JSONObject result = null;
        SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((chain, authType) -> true);
        try (CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setSSLHostnameVerifier((hostname, session) -> true).setSSLContext(sslContextBuilder.build()).setDefaultRequestConfig(this.c()).build();){
            httpClient.start();
            httpPost = new HttpPost(serviceUrl);
            StringEntity stringEntity = new StringEntity(request.toString());
            stringEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.addHeader("Content-Type", "application/json");
            future = httpClient.execute((HttpUriRequest)httpPost, null);
            if (future.get() != null) {
                HttpEntity httpEntity = ((HttpResponse)future.get()).getEntity();
                result = httpEntity == null ? null : new JSONObject(EntityUtils.toString((HttpEntity)httpEntity));
            }
        }
        catch (ExecutionException e2) {
            a.warn("get ca certification from cvmServer with ExecutionException.", (Throwable)e2);
        }
        finally {
            if (future != null && !future.isDone()) {
                future.cancel(true);
            }
        }
        return result;
    }

    private void a(GetCaCertificateRespDTO getCaCertificateRespDTO, Set<String> needUpdateCaSet, List<com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.e> caCertificates) {
        List caList = getCaCertificateRespDTO.getCaList();
        Long timeInterval = getCaCertificateRespDTO.getTimeInterval();
        Map idCaMap = caCertificates.stream().collect(Collectors.toMap(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.e::a, Function.identity()));
        long checkTime = System.currentTimeMillis();
        if (CollectionUtils.isEmpty((Collection)caList)) {
            if (!CollectionUtils.isEmpty(needUpdateCaSet)) {
                ArrayList needUpdates = new ArrayList();
                needUpdateCaSet.forEach(id -> {
                    com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.e caCertificate = (com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.e)idCaMap.get(id);
                    if (caCertificate != null) {
                        caCertificate.a(Long.valueOf(timeInterval == null ? 0L : timeInterval));
                        caCertificate.a(Boolean.valueOf(false));
                        caCertificate.a(caCertificate.f() + 1);
                        caCertificate.b(Long.valueOf(checkTime));
                        needUpdates.add(caCertificate);
                    }
                });
                if (!CollectionUtils.isEmpty(needUpdates)) {
                    this.m.a(needUpdates);
                }
            }
            return;
        }
        Set caNameSet = needUpdateCaSet.stream().map(idCaMap::get).filter(Objects::nonNull).map(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.e::c).collect(Collectors.toSet());
        Set allCaNameSet = caCertificates.stream().map(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.e::c).collect(Collectors.toSet());
        ArrayList<com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.e> savedCaCertifications = new ArrayList<com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.e>();
        for (GetCaCertificateDTO getCaCertificateDTO : caList) {
            if (caNameSet.contains(getCaCertificateDTO.getCaName())) {
                caCertificates.forEach(caCertificate -> {
                    if (T.a((String)getCaCertificateDTO.getCaName(), (String)caCertificate.c())) {
                        caCertificate.b(getCaCertificateDTO.getCaCertificate());
                        caCertificate.a(Boolean.valueOf(true));
                        caCertificate.a(0);
                        caCertificate.a(Long.valueOf(timeInterval == null ? 0L : timeInterval));
                        caCertificate.b(Long.valueOf(checkTime));
                        savedCaCertifications.add((com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.e)caCertificate);
                    }
                });
                caNameSet.remove(getCaCertificateDTO.getCaName());
                continue;
            }
            if (allCaNameSet.contains(getCaCertificateDTO.getCaName())) continue;
            com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.e caCertificate2 = new com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.e();
            caCertificate2.a(this.m.a());
            caCertificate2.b(getCaCertificateDTO.getCaCertificate());
            caCertificate2.c(getCaCertificateDTO.getCaName());
            caCertificate2.a(Boolean.valueOf(true));
            caCertificate2.a(0);
            caCertificate2.a(Long.valueOf(timeInterval == null ? 0L : timeInterval));
            caCertificate2.b(Long.valueOf(checkTime));
            savedCaCertifications.add(caCertificate2);
        }
        if (!CollectionUtils.isEmpty(caNameSet) && !CollectionUtils.isEmpty(needUpdateCaSet)) {
            needUpdateCaSet.forEach(caId -> {
                if (!idCaMap.containsKey(caId)) {
                    return;
                }
                com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.e caCertificate = (com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.e)idCaMap.get(caId);
                if (!caNameSet.contains(caCertificate.c())) {
                    return;
                }
                caCertificate.a(Long.valueOf(timeInterval == null ? 0L : timeInterval));
                caCertificate.a(Boolean.valueOf(false));
                caCertificate.a(caCertificate.f() + 1);
                caCertificate.b(Long.valueOf(checkTime));
                savedCaCertifications.add(caCertificate);
            });
        }
        if (!CollectionUtils.isEmpty(savedCaCertifications)) {
            this.m.a(savedCaCertifications);
        }
    }

    private OperationResponse<List<FirmwareInfoDTO>> a(t modelFwInfoReq, String startDate, String omadacId) {
        try {
            GetFwSeriesInfoListReqDTO getFwSeriesInfoListReqDTO = new GetFwSeriesInfoListReqDTO();
            getFwSeriesInfoListReqDTO.setHwId(com.tplink.smb.omada.common.util.b.b.f((String)modelFwInfoReq.c()));
            getFwSeriesInfoListReqDTO.setOemId(com.tplink.smb.omada.common.util.b.b.f((String)modelFwInfoReq.b()));
            getFwSeriesInfoListReqDTO.setLocale(o);
            getFwSeriesInfoListReqDTO.setSecureUrlEnabled(Boolean.FALSE);
            getFwSeriesInfoListReqDTO.setOmadacId(omadacId);
            if (Boolean.TRUE.equals(modelFwInfoReq.h())) {
                getFwSeriesInfoListReqDTO.setCurrentFwAdditionVer(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c((String)"6.1.0.19"));
            } else {
                getFwSeriesInfoListReqDTO.setCurrentFwAdditionVer(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c((String)"6.1.0.19"));
            }
            getFwSeriesInfoListReqDTO.setDirection(com.tplink.smb.omada.common.gridquery.g.a.a());
            getFwSeriesInfoListReqDTO.setIndex(Integer.valueOf(0));
            getFwSeriesInfoListReqDTO.setPageSize(Integer.valueOf(50));
            JSONObject req = new JSONObject(x.a((Object)getFwSeriesInfoListReqDTO));
            JSONObject res = this.k.d(req);
            a.debug("sendGetFwSeriesInfoList first page, req:{},res:{}", (Object)req, (Object)res);
            int errorCode = res.getInt("error_code");
            ArrayList<Object> fwList = new ArrayList();
            if (errorCode == 0) {
                FirmwareHistoryResp resp = (FirmwareHistoryResp)x.a((String)x.a((Object)res.getJSONObject("result")), FirmwareHistoryResp.class);
                if (CollectionUtils.isEmpty(resp.getFwList())) {
                    resp.setFwList(new ArrayList<FirmwareInfoDTO>());
                    a.info("Empty response for getFirmwareHistory, query {}", (Object)req);
                }
                fwList = new ArrayList<FirmwareInfoDTO>(resp.getFwList());
                while (Boolean.TRUE.equals(resp.getHasNext())) {
                    getFwSeriesInfoListReqDTO.setIndex(Integer.valueOf(resp.getCurrentIndex() + 1));
                    req = new JSONObject(x.a((Object)getFwSeriesInfoListReqDTO));
                    res = this.k.d(req);
                    a.debug("sendGetFwSeriesInfoList next page, req:{},res:{}", (Object)req, (Object)res);
                    resp = (FirmwareHistoryResp)x.a((String)x.a((Object)res.getJSONObject("result")), FirmwareHistoryResp.class);
                    List recentFwList = resp.getFwList().stream().filter(firmwareInfoDTO -> W.a((String)firmwareInfoDTO.getFwReleaseDate(), (String)startDate)).collect(Collectors.toList());
                    fwList.addAll(recentFwList);
                    if (recentFwList.size() >= resp.getFwList().size()) continue;
                    break;
                }
            } else {
                a.error("get fw history failed, resp = {}", (Object)res);
            }
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, fwList);
        }
        catch (SocketTimeoutException e2) {
            a.warn("get fw history SocketTimeoutException", (Throwable)e2);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.am, null);
        }
        catch (SocketException | UnknownHostException e3) {
            a.warn("get fw history SocketException | UnknownHostException", (Throwable)e3);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ao, null);
        }
        catch (IOException e4) {
            a.info("get fw history IOException occurs when sending req('{}').", (Object)"getEapFwInfoListWithOmadacId", (Object)e4);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ao, null);
        }
        catch (Exception e5) {
            a.error("get fw history occur Exception, omadacId:{}, req:{}", new Object[]{omadacId, modelFwInfoReq, e5});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.b, null);
        }
    }

    private OperationResponse<GetTargetFirmwareRespDTO> b(List<TargetFirmwareReqDTO> queryList, String omadacId) {
        if (CollectionUtil.isEmpty(queryList)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a);
        }
        GetTargetFirmwareReqDTO getTargetFirmwareReqDTO = new GetTargetFirmwareReqDTO();
        getTargetFirmwareReqDTO.setQueryList(queryList);
        getTargetFirmwareReqDTO.setOmadacId(omadacId);
        JSONObject request = new JSONObject(x.a((Object)getTargetFirmwareReqDTO));
        try {
            JSONObject response = this.k.e(request);
            a.debug("sendGetTargetFirmware,req:{}, res:{}", (Object)request, (Object)response);
            if (response == null) {
                a.warn("getTargetFirmware get empty response from server.");
                return new OperationResponse(com.tplink.smb.omada.common.g.b.ao);
            }
            int errorCode = response.getInt("error_code");
            if (errorCode == 0) {
                GetTargetFirmwareRespDTO getTargetFirmwareRespDTO = (GetTargetFirmwareRespDTO)x.a((String)x.a((Object)response.getJSONObject("result")), GetTargetFirmwareRespDTO.class);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)getTargetFirmwareRespDTO);
            }
            if (errorCode == -24702 || errorCode == -20501) {
                a.error("getTargetFirmware invalid device from biz cloud, omadacid:{}, resp:{}", (Object)omadacId, (Object)response);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.bg);
            }
            a.error("get GetTargetFirmware failed, omadacid:{}, response:{}", (Object)omadacId, (Object)response);
            if (errorCode == -10200) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.bh);
            }
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)errorCode), null);
        }
        catch (SocketTimeoutException e2) {
            a.warn("GetTargetFirmware SocketTimeoutException", (Throwable)e2);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.am, null);
        }
        catch (SocketException | UnknownHostException e3) {
            a.warn("GetTargetFirmware SocketException | UnknownHostException", (Throwable)e3);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ao, null);
        }
        catch (Exception e4) {
            a.info("GetTargetFirmware Exception occurs when sending req('{}').", (Object)"batchGetFwInfoWithOmadacId", (Object)e4);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ao, null);
        }
    }

    private OperationResponse<Map<String, List<UpgradeFwInfoDTO>>> g(com.tplink.smb.omada.manager.j.a.a.c omadacId, List<t> queryList) {
        BatchGetAvailableFwChannelsReqDTO batchGetAvailableFwChannelsReqDTO = new BatchGetAvailableFwChannelsReqDTO();
        ArrayList<GetAvailableFwChannelReqDTO> cloudQueryList = new ArrayList<GetAvailableFwChannelReqDTO>();
        batchGetAvailableFwChannelsReqDTO.setQueryList(cloudQueryList);
        batchGetAvailableFwChannelsReqDTO.setBizId(omadacId.a());
        try {
            for (t omadacModelFwInfo : queryList) {
                if (T.a((String)omadacModelFwInfo.c()) || T.a((String)omadacModelFwInfo.b())) {
                    a.warn("hwId or oemId is null, omadacId:{}, omadacModelFwInfo:{}", (Object)omadacId, (Object)omadacModelFwInfo);
                    continue;
                }
                GetAvailableFwChannelReqDTO getAvailableReq = new GetAvailableFwChannelReqDTO();
                getAvailableReq.setHwId(com.tplink.smb.omada.common.util.b.b.f((String)omadacModelFwInfo.c()));
                getAvailableReq.setOemId(com.tplink.smb.omada.common.util.b.b.f((String)omadacModelFwInfo.b()));
                getAvailableReq.setFwVer(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c((String)omadacModelFwInfo.f()));
                if (Boolean.TRUE.equals(omadacModelFwInfo.h())) {
                    getAvailableReq.setControllerVersion(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c((String)"6.1.0.19"));
                } else {
                    getAvailableReq.setControllerVersion(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c((String)"6.1.0.19"));
                }
                getAvailableReq.setLocale(o);
                getAvailableReq.setSecureUrlEnabled(Boolean.valueOf(true));
                cloudQueryList.add(getAvailableReq);
            }
            if (CollectionUtil.isEmpty(cloudQueryList)) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a, new HashMap());
            }
            JSONObject request = new JSONObject(x.a((Object)batchGetAvailableFwChannelsReqDTO));
            JSONObject response = this.k.g(request);
            a.debug("getPageGetAvailableFwChannels, request:{}, response:{}", (Object)request, (Object)response);
            if (null == response) {
                a.warn("getPageGetAvailableFwChannels Get empty response from server.");
                return new OperationResponse(com.tplink.smb.omada.common.g.b.ao);
            }
            int errorCode = response.getInt("error_code");
            if (errorCode != 0) {
                if (errorCode == -24702 || errorCode == -20501) {
                    a.error("getPageGetAvailableFwChannels invalid device from biz cloud, omadacid:{}, resp:{}", (Object)omadacId, (Object)response);
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.bg);
                }
                a.error("getPageGetAvailableFwChannels failed, omadacId:{}, response:{}", (Object)omadacId, (Object)response);
                if (errorCode == -10200) {
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.bh);
                }
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)errorCode), null);
            }
            BatchGetAvailableFwChannelsRespDTO batchGetAvailableFwChannelsRespDTO = (BatchGetAvailableFwChannelsRespDTO)x.a((String)x.a((Object)response.getJSONObject("result")), BatchGetAvailableFwChannelsRespDTO.class);
            HashMap<String, List<UpgradeFwInfoDTO>> res = new HashMap<String, List<UpgradeFwInfoDTO>>();
            for (GetAvailableFwChannelsRespDTO availableFwChannelsRespDTO : batchGetAvailableFwChannelsRespDTO.getChannelList()) {
                res.putAll(com.tplink.smb.omada.manager.cloud.dto.a.a(availableFwChannelsRespDTO));
            }
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, res);
        }
        catch (SocketTimeoutException e2) {
            a.warn("AvailableFwChannels SocketTimeoutException", (Throwable)e2);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.am, null);
        }
        catch (SocketException | UnknownHostException e3) {
            a.warn("AvailableFwChannels SocketException | UnknownHostException", (Throwable)e3);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ao, null);
        }
        catch (IOException e4) {
            a.info("AvailableFwChannels IOException occurs when sending req('{}').", (Object)"batchGetAvailableFwChannels", (Object)e4);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ao, null);
        }
        catch (Exception e5) {
            a.error("AvailableFwChannels occur exception, omadacId:{}, req:{}", new Object[]{omadacId, queryList, e5});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.b, null);
        }
    }

    private OperationResponse<Map<String, List<FirmwareBasicInfoDTO>>> h(com.tplink.smb.omada.manager.j.a.a.c omadacId, List<t> queryList) {
        Map<String, ModelTypeInfo> hwIdOemIdWithModel = queryList.stream().collect(Collectors.toMap(query -> query.c() + query.b(), query -> new ModelTypeInfo(query.e(), query.d())));
        BatchGetHighestFwChannelsReqDTO batchGetHighestFwChannelsReqDTO = new BatchGetHighestFwChannelsReqDTO();
        ArrayList<GetHighestFwChannelReqDTO> cloudQueryList = new ArrayList<GetHighestFwChannelReqDTO>();
        batchGetHighestFwChannelsReqDTO.setQueryList(cloudQueryList);
        batchGetHighestFwChannelsReqDTO.setBizId(omadacId.a());
        try {
            for (t omadacModelFwInfo : queryList) {
                if (T.a((String)omadacModelFwInfo.c()) || T.a((String)omadacModelFwInfo.b())) {
                    a.warn("getPageGetHighestFwChannels hwId or oemId is null, omadacId:{}, omadacModelFwInfo:{}", (Object)omadacId, (Object)omadacModelFwInfo);
                    continue;
                }
                GetHighestFwChannelReqDTO getHighestFwChannelReqDTO = new GetHighestFwChannelReqDTO();
                getHighestFwChannelReqDTO.setHwId(com.tplink.smb.omada.common.util.b.b.f((String)omadacModelFwInfo.c()));
                getHighestFwChannelReqDTO.setOemId(com.tplink.smb.omada.common.util.b.b.f((String)omadacModelFwInfo.b()));
                if (Boolean.TRUE.equals(omadacModelFwInfo.h())) {
                    getHighestFwChannelReqDTO.setCurrentFwAdditionVer(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c((String)"6.1.0.19"));
                } else {
                    getHighestFwChannelReqDTO.setCurrentFwAdditionVer(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c((String)"6.1.0.19"));
                }
                getHighestFwChannelReqDTO.setLocale(o);
                getHighestFwChannelReqDTO.setSecureUrlEnabled(Boolean.valueOf(true));
                cloudQueryList.add(getHighestFwChannelReqDTO);
            }
            if (CollectionUtil.isEmpty(cloudQueryList)) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a, new HashMap());
            }
            JSONObject request = new JSONObject(x.a((Object)batchGetHighestFwChannelsReqDTO));
            JSONObject response = this.k.f(request);
            a.debug("get HighestFwChannels, request:{}, response:{}", (Object)request, (Object)response);
            if (response == null) {
                a.warn("getPageGetHighestFwChannels Get empty response from server.");
                return new OperationResponse(com.tplink.smb.omada.common.g.b.ao);
            }
            int errorCode = response.getInt("error_code");
            if (errorCode != 0) {
                if (errorCode == -24702 || errorCode == -20501) {
                    a.error("getPageGetHighestFwChannels invalid device from biz cloud, omadacid:{}, resp:{}", (Object)omadacId, (Object)response);
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.bg);
                }
                a.error("getPageGetHighestFwChannels failed, omadacId:{}, response:{}", (Object)omadacId, (Object)response);
                if (errorCode == -10200) {
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.bh);
                }
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)errorCode), null);
            }
            BatchGetHighestFwChannelsRespDTO batchGetHighestFwChannelsRespDTO = (BatchGetHighestFwChannelsRespDTO)x.a((String)x.a((Object)response.getJSONObject("result")), BatchGetHighestFwChannelsRespDTO.class);
            HashMap<String, List<FirmwareBasicInfoDTO>> res = new HashMap<String, List<FirmwareBasicInfoDTO>>();
            for (GetHighestFwChannelsRespDTO highestFwChannelsRespDTO : batchGetHighestFwChannelsRespDTO.getChannelList()) {
                res.putAll(com.tplink.smb.omada.manager.cloud.dto.a.a(hwIdOemIdWithModel, highestFwChannelsRespDTO));
            }
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, res);
        }
        catch (SocketTimeoutException e2) {
            a.warn("getHighestFwChannels SocketTimeoutException", (Throwable)e2);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.am, null);
        }
        catch (SocketException | UnknownHostException e3) {
            a.warn("getHighestFwChannels SocketException | UnknownHostException", (Throwable)e3);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ao, null);
        }
        catch (IOException e4) {
            a.info("getHighestFwChannels IOException occurs when sending req('{}').", (Object)"batchGetHighestFwChannels", (Object)e4);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ao, null);
        }
        catch (Exception e5) {
            a.error("getHighestFwChannels occur exception, omadacId:{}, req:{}", new Object[]{omadacId, queryList, e5});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.b, null);
        }
    }

    @Nullable
    private URL a(String serviceUrl) {
        try {
            URL url = new URL(serviceUrl);
            a.debug("host={}, port={}", (Object)url.getHost(), (Object)url.getPort());
            return url;
        }
        catch (Exception ex) {
            a.warn(ex.toString(), (Throwable)ex);
            return null;
        }
    }

    private RequestConfig c() {
        return RequestConfig.custom().setConnectionRequestTimeout(40000).setConnectTimeout(35000).setSocketTimeout(15000).build();
    }
}

