/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.utils.jmx;

import com.tplink.nbu.common.utils.jmx.LoggerModification;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxUtils {
    private static Logger logger = LoggerFactory.getLogger(JmxUtils.class);
    private static Object lock = new Object();

    public static LoggerModification registerLoggerModificationMbean() {
        try {
            LoggerModification loggerModification = new LoggerModification();
            ObjectName name = JmxUtils.createObjectName(LoggerModification.class);
            JmxUtils.registerMbean(name, loggerModification);
            return loggerModification;
        }
        catch (Exception e) {
            logger.error("Registering logger mbean fail", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMbean(ObjectName name, Object obj) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Object object = lock;
            synchronized (object) {
                if (server.isRegistered(name)) {
                    JmxUtils.unregisterMbean(name);
                }
                server.registerMBean(obj, name);
            }
        }
        catch (Exception e) {
            logger.error("Registering mbean fail, name = " + name, (Throwable)e);
        }
    }

    public static void unregisterMbean(ObjectName name) {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(name);
        }
        catch (Exception e) {
            logger.error("Unregistering mbean fail, name = " + name, (Throwable)e);
        }
    }

    public static ObjectName createObjectName(Class<?> c) throws MalformedObjectNameException {
        try {
            return JmxUtils.createObjectName(JmxUtils.getPackageName(c), JmxUtils.getClassName(c));
        }
        catch (MalformedObjectNameException e) {
            logger.error("Created ObjectName fail, className = " + c.getName(), (Throwable)e);
            throw e;
        }
    }

    private static ObjectName createObjectName(String domain, String type) throws MalformedObjectNameException {
        try {
            return new ObjectName(domain + ":type=" + type);
        }
        catch (MalformedObjectNameException e) {
            logger.error("Created ObjectName fail, domain = " + domain + ", type = " + type, (Throwable)e);
            throw e;
        }
    }

    private static String getPackageName(Class<?> c) {
        String name = c.getName();
        return name.substring(0, name.lastIndexOf(46));
    }

    private static String getClassName(Class<?> c) {
        String name = c.getName();
        return name.substring(name.lastIndexOf(46) + 1, name.length());
    }
}

