/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.utils.jmx;

import com.tplink.nbu.common.utils.jmx.SystemTime;
import com.tplink.nbu.common.utils.jmx.Time;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonStats {
    private static final Logger logger = LoggerFactory.getLogger(CommonStats.class);
    private final AtomicReference<Accumulator> values;
    private final long durationMs;
    private final Time time;

    public CommonStats(long durationMs) {
        this(durationMs, SystemTime.INSTANCE);
    }

    CommonStats(long durationMs, Time time) {
        this.time = time;
        this.values = new AtomicReference<Accumulator>(new Accumulator());
        this.durationMs = durationMs;
    }

    public long getCount() {
        return this.getValidAccumulator().count;
    }

    public long getTotalCount() {
        return this.getValidAccumulator().total;
    }

    public float getThroughput() {
        Accumulator oldv = this.getValidAccumulator();
        double elapsed = (double)(this.time.getMilliseconds() - oldv.startTimeMS) / 1000.0;
        if (elapsed > 0.0) {
            return (float)((double)oldv.count / elapsed);
        }
        return 0.0f;
    }

    public double getAverageTimeInUs() {
        return this.getValidAccumulator().getAverageTimeNS() / 1000.0;
    }

    public long getDuration() {
        return this.durationMs;
    }

    public long getErrorCount() {
        return this.getValidAccumulator().errorResponses;
    }

    public long getMaxLatencyInUs() {
        return this.getValidAccumulator().maxLatencyNS / 1000L;
    }

    public HashMap getTotalDelayInfo() {
        Accumulator oldv = this.getValidAccumulator();
        double elapsed = (double)(this.time.getMilliseconds() - oldv.startTimeMS) / 1000.0;
        double throughput = 0.0;
        if (elapsed > 0.0) {
            throughput = (float)((double)oldv.count / elapsed);
        }
        HashMap<String, Number> totolInfo = new HashMap<String, Number>();
        totolInfo.put("averageTimeInUs", oldv.getAverageTimeNS() / 1000.0);
        totolInfo.put("throughput", throughput);
        totolInfo.put("maxLatencyInUs", oldv.maxLatencyNS / 1000L);
        totolInfo.put("count", oldv.count);
        totolInfo.put("total", oldv.total);
        totolInfo.put("errorCount", oldv.errorResponses);
        return totolInfo;
    }

    private Accumulator getValidAccumulator() {
        Accumulator accum = this.values.get();
        long now = this.time.getMilliseconds();
        if (now - accum.startTimeMS <= this.durationMs) {
            return accum;
        }
        Accumulator newWithTotal = accum.newWithTotal();
        if (this.values.compareAndSet(accum, newWithTotal)) {
            return newWithTotal;
        }
        return this.values.get();
    }

    public void addRequest(long timeNS) {
        this.addRequest(timeNS, 0);
    }

    public void addRequest(long timeNS, int errorCount) {
        long startTimeNs = 0L;
        if (logger.isDebugEnabled()) {
            startTimeNs = System.nanoTime();
        }
        for (int i = 0; i < 3; ++i) {
            Accumulator newv;
            Accumulator oldv = this.getValidAccumulator();
            if (!this.values.compareAndSet(oldv, newv = new Accumulator(oldv.startTimeMS, oldv.total + 1L, oldv.count + 1L, oldv.totalTimeNS + timeNS, oldv.errorResponses + (long)errorCount, Math.max(timeNS, oldv.maxLatencyNS)))) continue;
            if (logger.isDebugEnabled()) {
                logger.trace("addRequest ( accumulator update) took " + (System.nanoTime() - startTimeNs) + " ns.");
            }
            return;
        }
        logger.info("addRequest lost timing instrumentation data because three retries was insufficient to update the accumulator.");
        if (logger.isDebugEnabled()) {
            logger.trace("addRequest ( accumulator update) took " + (System.nanoTime() - startTimeNs) + " ns.");
        }
    }

    public long getNumEmptyResponses() {
        return this.getValidAccumulator().errorResponses;
    }

    private class Accumulator {
        final long startTimeMS;
        final long total;
        final long count;
        final long totalTimeNS;
        final long errorResponses;
        final long maxLatencyNS;

        public Accumulator() {
            this(commonStats.time.getMilliseconds(), 0L, 0L, 0L, 0L, 0L);
        }

        public Accumulator newWithTotal() {
            return new Accumulator(CommonStats.this.time.getMilliseconds(), this.total, 0L, 0L, 0L, 0L);
        }

        public Accumulator(long startTimeMS, long total, long count, long totalTimeNS, long errorResponses, long maxLatencyNS) {
            this.startTimeMS = startTimeMS;
            this.total = total;
            this.count = count;
            this.totalTimeNS = totalTimeNS;
            this.errorResponses = errorResponses;
            this.maxLatencyNS = maxLatencyNS;
        }

        public double getAverageTimeNS() {
            return this.count > 0L ? (double)(1.0f * (float)this.totalTimeNS / (float)this.count) : 0.0;
        }
    }
}

