/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.utils;

import com.tplink.nbu.common.utils.CipherUtil;

public class SensitiveInfoUtil {
    private static final String HIDDEN_MESSAGE = "***";

    public static String hideSensitiveInfo(String raw, String[] keys) {
        String result = raw;
        for (String key : keys) {
            result = SensitiveInfoUtil.hideSensitiveInfo(result, key);
        }
        return result;
    }

    public static String hideSensitiveInfo(String raw, String key) {
        return raw.replaceAll(SensitiveInfoUtil.getRegex(key), SensitiveInfoUtil.getReplacement(key));
    }

    public static String hideEmail(String raw) {
        return CipherUtil.sha1(raw);
    }

    private static String getRegex(String key) {
        return "(?i)\"" + key + "\":\".*?\"";
    }

    private static String getReplacement(String key) {
        return "\"" + key + "\":\"" + HIDDEN_MESSAGE + "\"";
    }

    private SensitiveInfoUtil() {
        throw new IllegalStateException("Utility class");
    }
}

