/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tplink.nbu.common.global.CustomObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JacksonUtil {
    private static final Logger log = LoggerFactory.getLogger(JacksonUtil.class);
    private static ObjectMapper objectMapper = new CustomObjectMapper();

    public static String parseToStr(Object data) {
        if (data == null) {
            return null;
        }
        if (!objectMapper.canSerialize(data.getClass())) {
            log.warn("class {} can not be converted.", (Object)data.getClass().getName());
            return null;
        }
        try {
            return objectMapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            log.error("data can not parse to string {} of class.", data.getClass(), (Object)e);
            return null;
        }
    }

    public static byte[] parseToByteArray(Object data) {
        if (data == null) {
            return null;
        }
        if (!objectMapper.canSerialize(data.getClass())) {
            log.warn("class {} can not be converted.", (Object)data.getClass().getName());
            return null;
        }
        try {
            return objectMapper.writeValueAsBytes(data);
        }
        catch (JsonProcessingException e) {
            log.error("data can not parse to string {} of class.", data.getClass(), (Object)e);
            return null;
        }
    }

    public static <T> T convertTo(String data, Class<T> cl) {
        if (data == null) {
            return null;
        }
        try {
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (T)objectMapper.readValue(data, cl);
        }
        catch (IOException e) {
            log.error("string convert: convert to object failed.", (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> convertToList(String data, Class<T> cl) {
        if (data == null) {
            return null;
        }
        try {
            Class<?> arrayClass = null;
            try {
                return (List)objectMapper.readValue(data, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, cl));
            }
            catch (Exception e) {
                log.warn("string convert: convert json to array failed because of the version of java.");
                arrayClass = Class.forName("[L" + cl.getName() + ";");
                Object[] objects = (Object[])objectMapper.readValue(data, arrayClass);
                return Arrays.asList(objects);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            log.error("string convert: convert to object failed.", (Throwable)e);
            return null;
        }
    }

    public static <T> T convertFromByteArrayTo(byte[] data, Class<T> cl) {
        if (data == null) {
            return null;
        }
        try {
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (T)objectMapper.readValue(data, cl);
        }
        catch (IOException e) {
            log.error("byte array convert: convert to object failed.", (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> convertFromByteArrayToList(byte[] data, Class<T> cl) {
        if (data == null) {
            return null;
        }
        try {
            Class<?> arrayClass = null;
            try {
                return (List)objectMapper.readValue(data, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, cl));
            }
            catch (Exception e) {
                log.warn("byte array convert: convert json to array failed because of the version of java.");
                arrayClass = Class.forName("[L" + cl.getName() + ";");
                Object[] objects = (Object[])objectMapper.readValue(data, arrayClass);
                return Arrays.asList(objects);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            log.error("byte array convert: convert to object failed.", (Throwable)e);
            return null;
        }
    }

    private JacksonUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

