/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.utils;

import com.tplink.nbu.common.exception.JSONParamMissException;
import com.tplink.nbu.common.exception.JSONParseException;
import org.json.JSONObject;

public class JSONUtil {
    public static void validateParams(JSONObject jsonObj, String[] params, String ... excludes) throws JSONParamMissException {
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            if (excludes != null && JSONUtil.arrayContains(excludes, param) || jsonObj.has(param)) continue;
            throw new JSONParamMissException(jsonObj, param);
        }
    }

    public static JSONObject convertToJson(String str) throws JSONParseException {
        JSONObject jsonObject;
        try {
            jsonObject = new JSONObject(str);
        }
        catch (Exception e) {
            throw new JSONParseException(str);
        }
        return jsonObject;
    }

    private static boolean arrayContains(Object[] array, Object value) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(value)) continue;
            return true;
        }
        return false;
    }
}

