/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    public static String readFile(String path) {
        InputStream inputStream = FileUtil.getInputStream(path);
        try {
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            BufferedReader bfReader = new BufferedReader(reader);
            return bfReader.lines().collect(Collectors.joining("\n"));
        }
        catch (NullPointerException e) {
            log.error("path not exist");
            return null;
        }
    }

    public static InputStream getInputStream(String path) {
        try {
            return Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
        }
        catch (Exception e) {
            log.warn("Use local config. {}", (Object)e.getMessage());
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        }
    }

    private FileUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

