/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class FileReaderUtil {
    private static final Logger log = LoggerFactory.getLogger(FileReaderUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFile(String filePath) {
        if (!FileReaderUtil.filePathIsExist(filePath)) {
            log.error("file path does not exist : {}", (Object)filePath);
            return null;
        }
        StringBuilder result = new StringBuilder("");
        ClassLoader classLoader = FileReaderUtil.class.getClassLoader();
        File file = null;
        Scanner scanner = null;
        try {
            file = new File(classLoader.getResource(filePath).getFile());
            scanner = new Scanner(file, "UTF-8");
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                result.append(line).append("\n");
            }
        }
        catch (Exception e) {
            log.error("file exception : {}", (Object)e.toString());
        }
        finally {
            if (null != scanner) {
                scanner.close();
            }
        }
        return result.toString();
    }

    public static boolean filePathIsExist(String filePath) {
        try {
            ClassLoader classLoader = FileReaderUtil.class.getClassLoader();
            classLoader.getResource(filePath).getFile();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileInStream(String filePath) {
        if (!FileReaderUtil.filePathIsExist(filePath)) {
            log.error("file path does not exist : {}", (Object)filePath);
            return null;
        }
        InputStream input = null;
        BufferedReader reader = null;
        String content = "";
        try {
            ClassLoader classLoader = FileReaderUtil.class.getClassLoader();
            input = classLoader.getResourceAsStream(filePath);
            reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            content = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Exception e) {
            log.error("file exception : {}", (Object)e.toString());
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
                if (null != input) {
                    input.close();
                }
            }
            catch (Exception e) {
                log.warn("the streams close in unexpected way");
            }
        }
        return content;
    }

    public static String read(InputStream inputStream) {
        StringBuilder sb = new StringBuilder();
        Scanner scanner = new Scanner(inputStream);
        while (scanner.hasNextLine()) {
            sb.append(scanner.nextLine()).append("\n");
        }
        return sb.toString();
    }

    private FileReaderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

