/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.utils;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Optional;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherUtil {
    private static final Logger log = LoggerFactory.getLogger(CipherUtil.class);

    private CipherUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String sha1(String str) {
        String encodeStr = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] hash = messageDigest.digest(str.getBytes(StandardCharsets.UTF_8));
            encodeStr = Hex.encodeHexString((byte[])hash);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return encodeStr;
    }

    public static String md5(String msg) {
        return CipherUtil.md5(msg.getBytes(StandardCharsets.UTF_8));
    }

    public static String md5Of16(String msg) {
        return Optional.ofNullable(CipherUtil.md5(msg)).map(item -> item.substring(8, 24)).orElse(null);
    }

    public static String md5(byte[] msgArr) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] byteData = md.digest(msgArr);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < byteData.length; ++i) {
                sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString().toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String base64Encode(String data) {
        byte[] bytes = Base64.getEncoder().encode(data.getBytes(StandardCharsets.UTF_8));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String hamcsha1(String data, String key) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            return Hex.encodeHexString((byte[])mac.doFinal(data.getBytes(StandardCharsets.UTF_8)));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("hmacsha1 failed", (Throwable)e);
            return null;
        }
    }

    public static String httpContentMd5(String payload) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] byteData = md.digest(payload.getBytes(StandardCharsets.UTF_8));
            byte[] encode = Base64.getEncoder().encode(byteData);
            return new String(encode, StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("httpContentMd5 failed", (Throwable)e);
            return null;
        }
    }
}

