/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.global;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.json.JSONObject;

public class CustomObjectMapper
extends ObjectMapper {
    public CustomObjectMapper() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(JSONObject.class, (JsonDeserializer)new JSONObjectDeserializer());
        module.addSerializer(JSONObject.class, (JsonSerializer)new JSONObjectSerializer());
        this.registerModule((Module)module);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static class JSONObjectSerializer
    extends JsonSerializer<JSONObject> {
        public void serialize(JSONObject jsonObject, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeRawValue(jsonObject.toString());
        }
    }

    public static class JSONObjectDeserializer
    extends JsonDeserializer<JSONObject> {
        public JSONObject deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode parent = (JsonNode)oc.readTree(jsonParser);
            return new JSONObject(parent.toString());
        }
    }
}

