/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.schedule;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.ScheduledEvent;
import com.tplink.smb.component.schedule.api.TaskKey;
import com.tplink.smb.component.schedule.api.handler.ScheduledEventHandler;
import com.tplink.smb.eventcenter.api.event.DomainEvent;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogKeyEnumDTO;
import com.tplink.smb.omada.logmanager.api.internal.i;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.DstInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.SiteDTO;
import com.tplink.smb.omada.monitor.api.internal.enventcenter.a;
import com.tplink.smb.omada.monitor.api.internal.report.NetworkReportScheduleDTO;
import com.tplink.smb.omada.monitor.api.web.report.v6.export.ReportExportV2VO;
import com.tplink.smb.omada.monitor.api.web.report.vo.NetworkReportVO;
import com.tplink.smb.omada.monitor.application.report.d;
import com.tplink.smb.omada.monitor.application.report.d.b;
import com.tplink.smb.omada.monitor.application.report.l;
import com.tplink.smb.omada.monitor.application.report.p;
import com.tplink.smb.omada.monitor.schedule.NetworkReportScheduleInfoDTO;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class c
implements ScheduledEventHandler {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);
    private static final String b = "omadacId";
    private static final String c = "siteId";
    private static final String d = "start";
    private static final String e = "end";
    private static final String f = "tab";
    private static final String g = "tab_id_list";
    private static final String h = "due to insufficient space. Please make sure your PC has the free memory space of over 1.2 GB";
    private static final String i = "due to damaged software. It is recommended to reinstall the controller.";
    private static final int j = 3;
    @Autowired
    private d k;
    @Autowired
    private p l;
    @Autowired
    private l m;
    @Autowired
    private ScheduleCenter n;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.a o;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.a p;
    @Autowired
    private i q;
    @Autowired
    private com.tplink.smb.omada.monitor.application.report.i18n.a r;
    @Autowired
    private com.tplink.smb.omada.monitor.application.report.e.b s;
    @Autowired
    private CacheService t;

    public void handle(ScheduledEvent scheduledEvent) {
        if (com.tplink.smb.omada.common.util.system.a.d() && !Boolean.TRUE.equals(com.tplink.smb.omada.common.util.system.c.b().getPrimary())) {
            a.info("node secondary, stop to execute NetworkReportEmailScheduleTask :{}", (Object)scheduledEvent);
            return;
        }
        if (Objects.isNull(scheduledEvent) || Objects.isNull(scheduledEvent.getTaskName()) || Objects.isNull(scheduledEvent.getTaskDataMap())) {
            a.warn("get schedule event failed for network report");
            return;
        }
        String taskName = scheduledEvent.getTaskName();
        Map dataMap = scheduledEvent.getTaskDataMap();
        if ("network_report_one_time".equals(taskName)) {
            this.b(dataMap);
        } else if ("network_report_schedule".equals(taskName)) {
            this.a(dataMap);
        }
    }

    private void a(Map<String, Object> taskDataMap) {
        int tab;
        String siteId;
        String omadacId = (String)taskDataMap.get(b);
        NetworkReportScheduleDTO scheduleInfo = this.m.b(omadacId, siteId = (String)taskDataMap.get(c), tab = ((Integer)taskDataMap.get(f)).intValue());
        if (Objects.isNull(scheduleInfo) || !scheduleInfo.getEnable().booleanValue() || CollectionUtils.isEmpty((Collection)scheduleInfo.getEmailList())) {
            return;
        }
        Long endTime = System.currentTimeMillis();
        Long startTime = this.a(endTime, com.tplink.smb.omada.monitor.api.internal.report.d.a((Integer)scheduleInfo.getTimingType()));
        if (startTime >= endTime) {
            return;
        }
        if (a.b.h.equals((Object)com.tplink.smb.omada.monitor.api.internal.enventcenter.a.a((int)tab))) {
            endTime = endTime / 1000L;
            startTime = startTime / 1000L;
        }
        NetworkReportScheduleInfoDTO scheduleInfoDTO = new NetworkReportScheduleInfoDTO();
        scheduleInfoDTO.setOmadacId(omadacId);
        scheduleInfoDTO.setSiteId(siteId);
        scheduleInfoDTO.setTab(tab);
        scheduleInfoDTO.setTabIdList(scheduleInfo.getTabIdList());
        scheduleInfoDTO.setStartTime(startTime);
        scheduleInfoDTO.setEndTime(endTime);
        scheduleInfoDTO.setIsRoot(scheduleInfo.getIsRoot());
        scheduleInfoDTO.setCards(scheduleInfo.getCards());
        scheduleInfoDTO.setReportName(scheduleInfo.getReportName());
        scheduleInfoDTO.setReportType(scheduleInfo.getReportType());
        scheduleInfoDTO.setEmailList(scheduleInfo.getEmailList());
        scheduleInfoDTO.setTimingType(scheduleInfo.getTimingType());
        this.a(scheduleInfoDTO, com.tplink.smb.omada.monitor.schedule.c$a.b);
    }

    private Long a(Long endTime, com.tplink.smb.omada.monitor.api.internal.report.d timingType) {
        switch (timingType) {
            case a: {
                return endTime - 86400000L;
            }
            case b: {
                return endTime - 604800000L;
            }
            case c: {
                long seconds = TimeUnit.MILLISECONDS.toSeconds(endTime);
                return TimeUnit.SECONDS.toMillis(seconds - 2592000L);
            }
        }
        a.warn("unknown time type for network report,time type:{}", (Object)timingType);
        return endTime;
    }

    private void b(Map<String, Object> taskDataMap) {
        int tab;
        String siteId;
        String omadacId = (String)taskDataMap.get(b);
        NetworkReportScheduleDTO scheduleInfo = this.m.b(omadacId, siteId = (String)taskDataMap.get(c), tab = ((Integer)taskDataMap.get(f)).intValue());
        if (Objects.isNull(scheduleInfo) || !scheduleInfo.getEnable().booleanValue() || CollectionUtils.isEmpty((Collection)scheduleInfo.getEmailList())) {
            this.m.a(omadacId, siteId, tab);
            this.n.deleteTask(new TaskKey("network_report_one_time", omadacId + ":" + siteId + ":" + tab));
            return;
        }
        NetworkReportScheduleInfoDTO scheduleInfoDTO = new NetworkReportScheduleInfoDTO();
        try {
            scheduleInfoDTO.setOmadacId(omadacId);
            scheduleInfoDTO.setSiteId(siteId);
            scheduleInfoDTO.setTab(tab);
            scheduleInfoDTO.setTabIdList(scheduleInfo.getTabIdList());
            scheduleInfoDTO.setStartTime(Optional.ofNullable(taskDataMap.get(d)).map(t2 -> Long.valueOf(t2.toString())).orElseThrow(() -> new com.tplink.smb.omada.common.h.c("startTime is null")));
            scheduleInfoDTO.setEndTime(Optional.ofNullable(taskDataMap.get(e)).map(t2 -> Long.valueOf(t2.toString())).orElseThrow(() -> new com.tplink.smb.omada.common.h.c("endTime is null")));
            scheduleInfoDTO.setIsRoot(scheduleInfo.getIsRoot());
            scheduleInfoDTO.setCards(scheduleInfo.getCards());
            scheduleInfoDTO.setReportName(scheduleInfo.getReportName());
            scheduleInfoDTO.setReportType(scheduleInfo.getReportType());
            scheduleInfoDTO.setEmailList(scheduleInfo.getEmailList());
        }
        catch (com.tplink.smb.omada.common.h.c e2) {
            a.error("failed to execute for network report,omadaId:{},siteId:{},tab:{},e=", new Object[]{omadacId, siteId, scheduleInfo.getTabIdList(), e2});
            return;
        }
        this.a(scheduleInfoDTO, com.tplink.smb.omada.monitor.schedule.c$a.a);
        this.m.a(omadacId, siteId, tab);
        this.n.deleteTask(new TaskKey("network_report_one_time", omadacId + ":" + siteId + ":" + tab));
    }

    private N a(Integer timingType) {
        if (Objects.isNull(timingType)) {
            return null;
        }
        switch (timingType) {
            case 1: {
                return N.a;
            }
            case 2: {
                return N.c;
            }
            case 3: {
                return N.d;
            }
        }
        a.warn("not a valid timing type.");
        return N.d;
    }

    private void a(NetworkReportScheduleInfoDTO scheduleInfo, a sendReportType) {
        String omadacId = scheduleInfo.getOmadacId();
        String siteId = scheduleInfo.getSiteId();
        Long startTime = scheduleInfo.getStartTime();
        Long endTime = scheduleInfo.getEndTime();
        String cards = scheduleInfo.getCards();
        Integer tab = scheduleInfo.getTab();
        if (a.b.h.equals((Object)com.tplink.smb.omada.monitor.api.internal.enventcenter.a.a((int)tab))) {
            ReportExportV2VO exportV2VO = new ReportExportV2VO();
            exportV2VO.setStart(startTime);
            exportV2VO.setEnd(endTime);
            exportV2VO.setReportName(scheduleInfo.getReportName());
            exportV2VO.setReportType(scheduleInfo.getReportType());
            exportV2VO.setTabIdList(scheduleInfo.getTabIdList());
            exportV2VO.setEmailList(scheduleInfo.getEmailList());
            String token = this.a();
            this.s.a(omadacId, siteId, exportV2VO, token);
            this.a(token);
            return;
        }
        Boolean isRoot = scheduleInfo.getIsRoot();
        com.tplink.smb.omada.monitor.api.internal.enventcenter.a networkReportEvent = com.tplink.smb.omada.monitor.api.internal.enventcenter.a.a().a(omadacId).b(siteId).a(startTime.longValue()).b(endTime.longValue()).c(cards).a(tab.intValue()).a(this.a(scheduleInfo.getTimingType())).a(isRoot.booleanValue()).a();
        DomainEventBusHolder.getPublisher().publishSync((DomainEvent)networkReportEvent);
        OperationResponse resp = networkReportEvent.h();
        if (!resp.success() || Objects.isNull(resp.getResult())) {
            a.warn("get report info failed for network report schedule task");
            return;
        }
        NetworkReportVO networkReportVO = (NetworkReportVO)resp.getResult();
        a.b tabIdx = networkReportEvent.j();
        Map granularityMap = networkReportEvent.k();
        OperationResponse dstInfoOpt = this.p.a(new QuerySiteDTO(omadacId, siteId));
        Optional siteDTOOpt = this.o.a(new QuerySiteDTO(omadacId, siteId));
        if (!dstInfoOpt.success() || !siteDTOOpt.isPresent()) {
            a.warn("get dst info or site info failed for network report");
            return;
        }
        DstInfoDTO dstInfo = (DstInfoDTO)dstInfoOpt.getResult();
        SiteDTO siteDTO = (SiteDTO)siteDTOOpt.get();
        String timezoneId = siteDTO.getTimezone();
        Object subject = this.r.a(omadacId);
        if (com.tplink.smb.omada.monitor.schedule.c$a.b.equals((Object)sendReportType)) {
            String subjectSuffix = com.tplink.smb.omada.monitor.application.report.d.b.a(dstInfo, timezoneId, startTime, endTime);
            subject = (String)subject + subjectSuffix;
        }
        OperationResponse operationResponse = null;
        switch (scheduleInfo.getReportType()) {
            case 0: {
                OperationResponse generateReportOpt = this.k.a(omadacId, siteId, networkReportVO, tabIdx, granularityMap, startTime, endTime);
                String reportName = scheduleInfo.getReportName();
                if (!generateReportOpt.success()) {
                    this.a(omadacId, reportName, generateReportOpt.getErrorCode());
                    return;
                }
                Path reportPath = (Path)generateReportOpt.getResult();
                operationResponse = this.l.a(omadacId, siteId, reportPath, (String)subject, scheduleInfo.getReportName(), scheduleInfo.getEmailList());
                break;
            }
            case 1: {
                String reportContent = this.k.a(omadacId, siteId, networkReportVO, tabIdx, startTime, endTime);
                if (Objects.isNull(reportContent)) {
                    a.warn("omadacId: {}, generate schedule csv report failed, report vo: {}, tabIdx: {}", new Object[]{omadacId, networkReportVO, tabIdx});
                    break;
                }
                operationResponse = this.l.a(omadacId, siteId, reportContent, (String)subject, scheduleInfo.getReportName(), scheduleInfo.getEmailList());
                break;
            }
        }
        if (operationResponse == null) {
            a.warn("send email failed for network report,omadaId:{},siteId:{},tab:{}", new Object[]{omadacId, siteId, tab});
            return;
        }
        if (!operationResponse.success() && operationResponse.getErrorCode() != com.tplink.smb.omada.common.g.b.cM.b()) {
            a.warn("send email failed for network report,omadaId:{},siteId:{},tab:{}", new Object[]{omadacId, siteId, tab});
        }
    }

    private void a(String omadacId, String reportName, int generateReportError) {
        String logContent = OmadaLogDTO.build((String)omadacId, (OmadaLogKeyEnumDTO)OmadaLogKeyEnumDTO.REPORT_GENERATION_FAILED, (String[])new String[]{reportName, ""}).toJson();
        com.tplink.smb.omada.common.g.b errorCode = com.tplink.smb.omada.common.g.b.a((int)generateReportError);
        switch (errorCode) {
            case cO: {
                logContent = OmadaLogDTO.build((String)omadacId, (OmadaLogKeyEnumDTO)OmadaLogKeyEnumDTO.REPORT_GENERATION_FAILED, (String[])new String[]{reportName, h}).toJson();
                break;
            }
            case cP: {
                logContent = OmadaLogDTO.build((String)omadacId, (OmadaLogKeyEnumDTO)OmadaLogKeyEnumDTO.REPORT_GENERATION_FAILED, (String[])new String[]{reportName, i}).toJson();
                break;
            }
        }
        this.q.a(omadacId, OmadaLogKeyEnumDTO.REPORT_GENERATION_FAILED, logContent);
    }

    private String a() {
        String accessToken = UUID.randomUUID().toString();
        this.t.set("monitor:report:v6:token", accessToken, (Object)1, 3L, TimeUnit.MINUTES);
        return accessToken;
    }

    private void a(String tokenKey) {
        this.t.deleteKey("monitor:report:v6:token", tokenKey);
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        private static final /* synthetic */ a[] c;

        public static a[] values() {
            return (a[])c.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b};
        }

        static {
            c = com.tplink.smb.omada.monitor.schedule.c$a.a();
        }
    }
}

