/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.port.eventcenter;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.monitor.MonitorDatatrackProperties;
import com.tplink.smb.omada.monitor.MonitorDeviceInformProperties;
import com.tplink.smb.omada.monitor.NetworkReportProperties;
import com.tplink.smb.omada.monitor.port.eventcenter.a;
import com.tplink.smb.omada.monitor.port.eventcenter.b;
import com.tplink.smb.omada.monitor.port.eventcenter.c;
import com.tplink.smb.omada.monitor.port.eventcenter.d;
import com.tplink.smb.omada.monitor.port.eventcenter.e;
import com.tplink.smb.omada.monitor.port.eventcenter.f;
import com.tplink.smb.omada.monitor.port.eventcenter.g;
import com.tplink.smb.omada.monitor.task.MonitorMaintenanceTaskProperties;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={MonitorMaintenanceTaskProperties.class})
public class MonitorExecutorConfiguration {
    @Autowired
    private com.tplink.smb.omada.monitor.port.d.c a;
    @Autowired
    private MeterRegistry b;
    @Autowired
    private NetworkReportProperties c;
    @Autowired
    private MonitorDeviceInformProperties d;
    @Autowired
    private MonitorDatatrackProperties e;

    @Lazy
    @Bean(name={"monitorDeviceEventWorkGroup"})
    @ConditionalOnMissingBean(name={"monitorDeviceEventWorkGroup"})
    public ExecutorService monitorDeviceEventWorkGroup() {
        int coreSize = Math.max(Runtime.getRuntime().availableProcessors() / 2, 1);
        String poolName = "monitor-device-event-pool";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, coreSize, 2L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(this.d.getDeviceNum()), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new a(this, poolName));
        executor.allowCoreThreadTimeOut(true);
        return ExecutorServiceMetrics.monitor((MeterRegistry)this.b, (ExecutorService)executor, (String)poolName, (String)"executor_metric", (Tag[])new Tag[0]);
    }

    @Lazy
    @Bean(name={"monitorDeviceInformWorkGroup"})
    @ConditionalOnMissingBean(name={"monitorDeviceInformWorkGroup"})
    public ExecutorService monitorDeviceInformWorkGroup() {
        int deviceNum = this.d.getDeviceNum();
        int coreSize = this.d.getPoolSize();
        int maxSize = this.d.getMaxSize();
        String poolName = "monitor-device-inform-pool";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, maxSize, 2L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(deviceNum), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), this.a(poolName));
        executor.allowCoreThreadTimeOut(true);
        return ExecutorServiceMetrics.monitor((MeterRegistry)this.b, (ExecutorService)executor, (String)poolName, (String)"executor_metric", (Tag[])new Tag[0]);
    }

    @Lazy
    @Bean(name={"monitorDatatrackWorkGroup"})
    @ConditionalOnMissingBean(name={"monitorDatatrackWorkGroup"})
    public ExecutorService monitorDatatrackWorkGroup() {
        int coreSize = this.e.getCoreSize();
        int maxSize = this.e.getMaxSize();
        String poolName = "monitor-data-track-pool";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, maxSize, 2L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(this.e.getQueueSize()), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new b(this, poolName));
        executor.allowCoreThreadTimeOut(true);
        return ExecutorServiceMetrics.monitor((MeterRegistry)this.b, (ExecutorService)executor, (String)poolName, (String)"executor_metric", (Tag[])new Tag[0]);
    }

    private RejectedExecutionHandler a(String poolName) {
        if (OmadacType.s()) {
            return new c(this, poolName);
        }
        return new d(this, poolName);
    }

    @Lazy
    @Bean(name={"monitorGetReportWorkGroup"})
    @ConditionalOnMissingBean(name={"monitorGetReportWorkGroup"})
    public ExecutorService monitorGetReportWorkGroup() {
        int coreSize = this.c.getCoreSize();
        int queueSize = this.c.getQueueSize();
        String poolName = "monitor-get-report-pool";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, coreSize, 2L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new e(this, poolName));
        executor.allowCoreThreadTimeOut(true);
        return ExecutorServiceMetrics.monitor((MeterRegistry)this.b, (ExecutorService)executor, (String)poolName, (String)"executor_metric", (Tag[])new Tag[0]);
    }

    @Lazy
    @Bean(name={"monitorReportGenerationWorkGroup"})
    @ConditionalOnMissingBean(name={"monitorReportGenerationWorkGroup"})
    public ExecutorService reportGenerationWorkGroup() {
        String poolName = "monitor-report-gen-pool";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new f(this, poolName));
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    @Lazy
    @Bean(name={"monitorTabCardsGenerationWorkGroup"})
    @ConditionalOnMissingBean(name={"monitorTabCardsGenerationWorkGroup"})
    public ExecutorService reportTabCardsGenerationWorkGroup() {
        String poolName = "monitor-report-tab-cards-gen-pool";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.c.getCardsCoreSize(), this.c.getCardsMaxSize(), 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.c.getCardsQueueSize()), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new g(this, poolName));
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }
}

