/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.port.cache.omadac;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.omada.common.util.K;
import com.tplink.smb.omada.monitor.port.cache.omadac.ActiveSiteCacheProperties;
import com.tplink.smb.omada.monitor.statistic.StatisticProperties;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@com.tplink.smb.omada.common.spring.b
public class ActiveSiteCacheImpl
implements com.tplink.smb.omada.monitor.api.c.b.a {
    private static final Logger d = LoggerFactory.getLogger(ActiveSiteCacheImpl.class);
    private static final String e = "monitor.active.sites.daily";
    private static final String f = "monitor.active.sites.weekly";
    protected final StatisticProperties a;
    protected final ActiveSiteCacheProperties b;
    protected final CacheService c;
    private final Map<String, Set<String>> g = new ConcurrentHashMap<String, Set<String>>(128);

    @Autowired
    public ActiveSiteCacheImpl(StatisticProperties scheduleProperties, ActiveSiteCacheProperties activeSiteCacheProperties, CacheService cacheService) {
        this.a = scheduleProperties;
        this.b = activeSiteCacheProperties;
        this.c = cacheService;
    }

    protected static String a(@Nonnull String siteId, int totalPartitions, a timestamp) {
        int partition = siteId.hashCode() & totalPartitions - 1;
        return ActiveSiteCacheImpl.a(partition, timestamp);
    }

    protected static String a(@Nonnull String siteId, int totalPartitions, b timestamp) {
        int partition = siteId.hashCode() & totalPartitions - 1;
        return ActiveSiteCacheImpl.a(partition, timestamp);
    }

    protected static String a(int partitionIdx, a timestamp) {
        return new StringJoiner(":").add("partition").add(String.valueOf(partitionIdx)).add("date").add(K.b((long)timestamp.a())).toString();
    }

    protected static String a(int partitionIdx, b timestamp) {
        return new StringJoiner(":").add("partition").add(String.valueOf(partitionIdx)).add("week").add(K.a((long)timestamp.a())).toString();
    }

    @PostConstruct
    public void a() {
        if (this.b.getFlushInterval().equals(Duration.ZERO)) {
            d.info("ActiveSitesCache period flush buf is disabled.");
            return;
        }
        long millis = this.b.getFlushInterval().toMillis();
        d.info("Scheduled ActiveSitesCache period flush buf task at fixed rate of {} millis.", (Object)millis);
        com.tplink.smb.omada.common.concurrent.thread.b.b(() -> {
            d.trace("Starting to flush buffed active ids {}", this.g);
            try {
                this.b();
            }
            catch (Exception e2) {
                d.warn("Failed to execute ActiveSiteCache.flushBuf()", (Throwable)e2);
            }
        }, (long)millis, (long)millis, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void a(String omadacId, String siteId) {
        if (this.b.getFlushInterval().equals(Duration.ZERO)) {
            d.trace("Saving OmadacId: {}, SiteId: {} into ActiveSitesCache buf directly", (Object)omadacId, (Object)siteId);
            int partitions = this.a.getPartitions();
            Set<OmadacIdSiteIdPO> set = Collections.singleton(new OmadacIdSiteIdPO(omadacId, siteId));
            String dailyCacheKey = ActiveSiteCacheImpl.a(siteId, partitions, new a());
            this.a(dailyCacheKey, set);
            String weeklyCacheKey = ActiveSiteCacheImpl.a(siteId, partitions, new b());
            this.b(weeklyCacheKey, set);
        } else {
            d.trace("Putting OmadacId: {}, SiteId: {} into ActiveSitesCache buf", (Object)omadacId, (Object)siteId);
            this.g.computeIfAbsent(omadacId, k2 -> ConcurrentHashMap.newKeySet(1024)).add(siteId);
        }
    }

    public void a(Map<String, Set<String>> omadaSiteMap) {
        if (CollectionUtils.isEmpty(omadaSiteMap)) {
            return;
        }
        if (this.b.getFlushInterval().equals(Duration.ZERO)) {
            d.trace("Saving omadaSiteMap: {} into ActiveSitesCache buf directly", omadaSiteMap);
            this.a(omadaSiteMap, false);
        } else {
            d.trace("Putting map: {} into ActiveSitesCache buf", omadaSiteMap);
            omadaSiteMap.forEach((omadacId, siteIds) -> this.g.computeIfAbsent((String)omadacId, k2 -> ConcurrentHashMap.newKeySet(1024)).addAll(siteIds));
        }
    }

    public Map<String, Set<String>> a(int partition) {
        d.trace("Getting ActiveSites of Today by partition: {}", (Object)partition);
        long currentSec = System.currentTimeMillis() / 1000L;
        long yesterdayEndSec = ActiveSiteCacheImpl.c();
        HashSet yesterdaySet = new HashSet();
        long delta = currentSec - yesterdayEndSec;
        if (delta > 0L && delta < this.b.getDailyWarmingUpWindow().getSeconds()) {
            d.trace("Getting ActiveSites of Today by partition: {}. Currently within warming up window: {} seconds, need fetch both yesterday and today", (Object)partition, (Object)this.b.getDailyWarmingUpWindow().getSeconds());
            yesterdaySet = new HashSet(this.c.getSet(e, ActiveSiteCacheImpl.a(partition, new a(yesterdayEndSec * 1000L)), OmadacIdSiteIdPO.class));
            d.trace("Fetched Yesterday's set by partition: {}, result: {}", (Object)partition, yesterdaySet);
        }
        HashSet todaySet = new HashSet(this.c.getSet(e, ActiveSiteCacheImpl.a(partition, new a()), OmadacIdSiteIdPO.class));
        d.trace("Fetched Today's set by partition: {}, result: {}", (Object)partition, todaySet);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        todaySet.forEach(po -> result.computeIfAbsent(po.getOmadacId(), k2 -> new HashSet()).add(po.getSiteId()));
        yesterdaySet.forEach(po -> result.computeIfAbsent(po.getOmadacId(), k2 -> new HashSet()).add(po.getSiteId()));
        d.trace("Fetched active sites of day by partition: {}, result: {}", (Object)partition, result);
        return result;
    }

    public Map<String, Set<String>> b(int partition) {
        HashSet lastWeekSet = new HashSet(this.c.getSet(f, ActiveSiteCacheImpl.a(partition, new b(ActiveSiteCacheImpl.d() * 1000L)), OmadacIdSiteIdPO.class));
        d.trace("Fetched Last Week's set by partition: {}, result: {}", (Object)partition, lastWeekSet);
        HashSet thisWeekSet = new HashSet(this.c.getSet(f, ActiveSiteCacheImpl.a(partition, new b()), OmadacIdSiteIdPO.class));
        d.trace("Fetched This Week's set by partition: {}, result: {}", (Object)partition, thisWeekSet);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        thisWeekSet.forEach(po -> result.computeIfAbsent(po.getOmadacId(), k2 -> new HashSet()).add(po.getSiteId()));
        lastWeekSet.forEach(po -> result.computeIfAbsent(po.getOmadacId(), k2 -> new HashSet()).add(po.getSiteId()));
        d.trace("Fetched active sites of week by partition: {}, result: {}", (Object)partition, result);
        return result;
    }

    protected void b() {
        this.a(this.g, true);
    }

    private void a(Map<String, Set<String>> map, boolean removeWhenIteration) {
        int partitions = this.a.getPartitions();
        HashMap<String, Set> dailyTargetMap = new HashMap<String, Set>();
        HashMap<String, Set> weeklyTargetMap = new HashMap<String, Set>();
        Set<Map.Entry<String, Set<String>>> entries = map.entrySet();
        Iterator<Map.Entry<String, Set<String>>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Set<String>> entry = iterator.next();
            String omadacId = entry.getKey();
            for (String siteId : entry.getValue()) {
                String dailyCacheKey = ActiveSiteCacheImpl.a(siteId, partitions, new a());
                String weeklyCacheKey = ActiveSiteCacheImpl.a(siteId, partitions, new b());
                dailyTargetMap.computeIfAbsent(dailyCacheKey, k2 -> new HashSet()).add(new OmadacIdSiteIdPO(omadacId, siteId));
                weeklyTargetMap.computeIfAbsent(weeklyCacheKey, k2 -> new HashSet()).add(new OmadacIdSiteIdPO(omadacId, siteId));
            }
            if (removeWhenIteration) {
                iterator.remove();
            }
            d.trace("Removed <OmadacId:{}, SiteIds:{}> from buf, need write to cache", (Object)omadacId, entry.getValue());
        }
        dailyTargetMap.forEach(this::a);
        weeklyTargetMap.forEach(this::b);
    }

    private void a(String dailyCacheKey, Set<OmadacIdSiteIdPO> set) {
        try {
            this.c.getSet(e, dailyCacheKey, OmadacIdSiteIdPO.class).addAll(set);
            if (d.isTraceEnabled()) {
                d.trace("Successfully updated cache {}:{} with values {}", new Object[]{e, dailyCacheKey, set});
            }
            this.c.expireKey(e, dailyCacheKey, this.b.getDailyKeepAlive().getSeconds(), TimeUnit.SECONDS);
            if (d.isTraceEnabled()) {
                d.trace("Successfully set expiration of {}:{} with {} seconds", new Object[]{e, dailyCacheKey, this.b.getDailyKeepAlive().getSeconds()});
            }
        }
        catch (Exception e2) {
            d.warn("Failed to flush {}, {} to {}", new Object[]{dailyCacheKey, set, e, e2});
        }
    }

    private void b(String cacheKey, Set<OmadacIdSiteIdPO> set) {
        try {
            this.c.getSet(f, cacheKey, OmadacIdSiteIdPO.class).addAll(set);
            if (d.isTraceEnabled()) {
                d.trace("Successfully updated cache {}:{} with values {}", new Object[]{f, cacheKey, set});
            }
            this.c.expireKey(f, cacheKey, this.b.getWeeklyKeepAlive().getSeconds(), TimeUnit.SECONDS);
            if (d.isTraceEnabled()) {
                d.trace("Successfully set expiration of {}:{} with {} seconds", new Object[]{f, cacheKey, this.b.getDailyKeepAlive().getSeconds()});
            }
        }
        catch (Exception e2) {
            d.warn("Failed to flush {}, {} to {}", new Object[]{cacheKey, set, f, e2});
        }
    }

    private static long c() {
        return LocalDate.now(ZoneOffset.UTC).atStartOfDay().toEpochSecond(ZoneOffset.UTC) - 1L;
    }

    private static long d() {
        return LocalDate.now(ZoneOffset.UTC).atStartOfDay().with(ChronoField.DAY_OF_WEEK, DayOfWeek.MONDAY.getValue()).toEpochSecond(ZoneOffset.UTC) - 1L;
    }

    private static class a {
        public static final int a = 999999999;
        private final long b;

        public a() {
            this.b = LocalDateTime.ofInstant(Instant.now(), ZoneOffset.UTC).withHour(23).withMinute(59).withSecond(59).withNano(999999999).toEpochSecond(ZoneOffset.UTC);
        }

        public a(long anyMillis) {
            this.b = LocalDateTime.ofEpochSecond(TimeUnit.MILLISECONDS.toSeconds(anyMillis), 999999999, ZoneOffset.UTC).withHour(23).withMinute(59).withSecond(59).toEpochSecond(ZoneOffset.UTC);
        }

        public long a() {
            return this.b;
        }
    }

    private static class b {
        public static final int a = 999999999;
        private final long b;

        public b() {
            this.b = LocalDateTime.ofInstant(Instant.now(), ZoneOffset.UTC).with(ChronoField.DAY_OF_WEEK, DayOfWeek.SUNDAY.getValue()).withHour(23).withMinute(59).withSecond(59).withNano(999999999).toEpochSecond(ZoneOffset.UTC);
        }

        public b(long anyMillis) {
            this.b = LocalDateTime.ofEpochSecond(TimeUnit.MILLISECONDS.toSeconds(anyMillis), 999999999, ZoneOffset.UTC).with(ChronoField.DAY_OF_WEEK, DayOfWeek.SUNDAY.getValue()).withHour(23).withMinute(59).withSecond(59).toEpochSecond(ZoneOffset.UTC);
        }

        public long a() {
            return this.b;
        }
    }

    @JsonPropertyOrder(value={"omadacId", "siteId"})
    private static class OmadacIdSiteIdPO {
        @JsonProperty(value="omadacId")
        private String omadacId;
        @JsonProperty(value="siteId")
        private String siteId;

        @Generated
        public String getOmadacId() {
            return this.omadacId;
        }

        @Generated
        public String getSiteId() {
            return this.siteId;
        }

        @JsonProperty(value="omadacId")
        @Generated
        public void setOmadacId(String omadacId) {
            this.omadacId = omadacId;
        }

        @JsonProperty(value="siteId")
        @Generated
        public void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof OmadacIdSiteIdPO)) {
                return false;
            }
            OmadacIdSiteIdPO other = (OmadacIdSiteIdPO)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$omadacId = this.getOmadacId();
            String other$omadacId = other.getOmadacId();
            if (this$omadacId == null ? other$omadacId != null : !this$omadacId.equals(other$omadacId)) {
                return false;
            }
            String this$siteId = this.getSiteId();
            String other$siteId = other.getSiteId();
            return !(this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OmadacIdSiteIdPO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $omadacId = this.getOmadacId();
            result = result * 59 + ($omadacId == null ? 43 : $omadacId.hashCode());
            String $siteId = this.getSiteId();
            result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ActiveSiteCacheImpl.OmadacIdSiteIdPO(omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ")";
        }

        @Generated
        public OmadacIdSiteIdPO() {
        }

        @Generated
        public OmadacIdSiteIdPO(String omadacId, String siteId) {
            this.omadacId = omadacId;
            this.siteId = siteId;
        }
    }
}

