/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.domain.model.insight.rogueap;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.n;
import com.tplink.smb.omada.common.gridquery.a;
import com.tplink.smb.omada.common.gridquery.b;
import com.tplink.smb.omada.common.gridquery.c;
import com.tplink.smb.omada.common.obfuscate.KeepClassNameAndSetter;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.j;
import com.tplink.smb.omada.common.util.r;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UserDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.DstInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.SiteDTO;
import com.tplink.smb.omada.monitor.domain.model.insight.rogueap.c;
import com.tplink.smb.omada.monitor.domain.model.insight.rogueap.d;
import com.tplink.smb.omada.monitor.domain.model.insight.rogueap.e;
import com.tplink.smb.omada.monitor.domain.model.insight.rogueap.f;
import com.tplink.smb.omada.monitor.domain.model.insight.rogueap.l;
import com.tplink.smb.omada.monitor.domain.model.insight.rogueap.m;
import com.tplink.smb.omada.monitor.domain.model.insight.rogueap.p;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@KeepClassNameAndSetter
public class ExportRogueApWithSiteService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(ExportRogueApWithSiteService.class);
    @Autowired
    private d b;
    @Autowired
    private l c;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.a d;

    public OperationResponse a(String omadacId, List<String> siteIds, Integer format, ApiResponseWrapper<?> response, String fileName, DstInfoDTO dstInfoDTO, UserDTO currentUser) {
        if (T.a((String)omadacId) || format == null) {
            return OperationResponse.PARAM_ERROR;
        }
        if (CollectionUtils.isEmpty(siteIds)) {
            return OperationResponse.PARAM_ERROR;
        }
        List<Map<String, Object>> dataList = this.a(omadacId, siteIds, dstInfoDTO, currentUser);
        if (CollectionUtils.isEmpty(dataList)) {
            return this.a(fileName, format, response);
        }
        String[] keys = (String[])Arrays.copyOf(dataList.get(0).keySet().toArray(), dataList.get(0).keySet().toArray().length, String[].class);
        if (n.d.equals(format)) {
            return this.a(omadacId, fileName, dataList, keys, response);
        }
        if (n.e.equals(format)) {
            return this.b(omadacId, fileName, dataList, keys, response);
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
    }

    private List<Map<String, Object>> a(String omadacId, List<String> siteIds, DstInfoDTO dstInfoDTO, UserDTO currentUser) {
        Set siteWithPermission = currentUser.getSiteIds();
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        for (String siteId : siteIds) {
            SiteDTO siteDTO;
            long count;
            if (!siteWithPermission.contains(siteId) || (count = this.c.c(omadacId, siteId)) == 0L || (siteDTO = (SiteDTO)this.d.a(new QuerySiteDTO(omadacId, siteId)).orElse(null)) == null) continue;
            String timeZone = siteDTO.getTimezone();
            long totalPage = (count - 1L) / 10000L + 1L;
            b queryData = new b();
            queryData.b(10000);
            int page = 0;
            while ((long)page < totalPage) {
                queryData.a(++page);
                a rogueApGrid = new a(queryData);
                rogueApGrid.addFilter("omadac_id", (Object)omadacId, c.a.a);
                rogueApGrid.addFilter("site_id", (Object)siteId, c.a.a);
                this.b.a((a<f>)rogueApGrid);
                for (f rogueAp : rogueApGrid.getData()) {
                    LinkedHashMap<String, Object> mapValue = new LinkedHashMap<String, Object>();
                    this.a(siteDTO.getSiteName(), timeZone, rogueAp, dstInfoDTO, mapValue);
                    listMap.add(mapValue);
                }
            }
        }
        return listMap;
    }

    private OperationResponse a(String omadacId, String fileName, List<Map<String, Object>> dataList, String[] keys, ApiResponseWrapper<?> response) {
        OperationResponse operationResponse;
        block8: {
            String content = j.a(dataList, (String[])keys, (String[])keys);
            OutputStream output = response.getOutputStream();
            try {
                r.b(response, (String)fileName);
                output.write(content.getBytes(StandardCharsets.UTF_8));
                output.flush();
                operationResponse = OperationResponse.SUCCESS;
                if (output == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    a.error("{} failed to write csv file for rogue ap list, error:{}", (Object)omadacId, (Object)e2);
                    return OperationResponse.GENERAL_ERROR;
                }
            }
            output.close();
        }
        return operationResponse;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private OperationResponse b(String omadacId, String fileName, List<Map<String, Object>> dataList, String[] keys, ApiResponseWrapper<?> response) {
        try (OutputStream output = response.getOutputStream();){
            OperationResponse operationResponse;
            block15: {
                Workbook workbook = com.tplink.smb.omada.common.util.p.a(dataList, (String[])keys, (String[])keys);
                try {
                    r.c(response, (String)fileName);
                    workbook.write(output);
                    output.flush();
                    if (workbook instanceof SXSSFWorkbook) {
                        ((SXSSFWorkbook)workbook).dispose();
                    }
                    operationResponse = OperationResponse.SUCCESS;
                    if (workbook == null) break block15;
                }
                catch (Throwable throwable) {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                workbook.close();
            }
            return operationResponse;
        }
        catch (IOException e2) {
            a.error("{} failed to write xlsx file with rogue ap list, error:{}", (Object)omadacId, (Object)e2);
            return OperationResponse.GENERAL_ERROR;
        }
    }

    private void a(String siteName, String timeZone, f rogueAp, DstInfoDTO dstInfoDTO, Map<String, Object> mapValue) {
        mapValue.put("NAME/SSID", rogueAp.f());
        mapValue.put("BSSID", rogueAp.e());
        mapValue.put("CHANNEL", rogueAp.h() + " (" + e.a(rogueAp.i()) + ")");
        String security = m.b(rogueAp.j());
        mapValue.put("SECURITY", security);
        mapValue.put("BEACON", rogueAp.k());
        mapValue.put("LOCATION", "Nearest " + rogueAp.m());
        mapValue.put("SIGNAL", p.a(rogueAp.n()) + "%(" + rogueAp.n() + "dBm)");
        mapValue.put("LAST SEEN", com.tplink.smb.omada.monitor.domain.model.insight.rogueap.c.a(dstInfoDTO, timeZone, "yyyy-MM-dd hh:mm:ss a", rogueAp.o()));
        mapValue.put("siteName", siteName);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private OperationResponse a(String fileName, Integer format, ApiResponseWrapper<?> response) {
        String[] columnNames = new String[]{"NAME/SSID", "BSSID", "CHANNEL", "SECURITY", "BEACON", "LOCATION", "SIGNAL", "LAST SEEN"};
        try (OutputStream output = response.getOutputStream();){
            OperationResponse operationResponse;
            block17: {
                Workbook workbook = com.tplink.smb.omada.common.util.p.a(Collections.emptyList(), (String[])columnNames, (String[])columnNames);
                try {
                    if (n.d.equals(format)) {
                        r.b(response, (String)fileName);
                        String content = j.a(Collections.emptyList(), (String[])columnNames, (String[])columnNames);
                        output.write(content.getBytes(StandardCharsets.UTF_8));
                    } else {
                        r.c(response, (String)fileName);
                        workbook.write(output);
                    }
                    output.flush();
                    if (workbook instanceof SXSSFWorkbook) {
                        ((SXSSFWorkbook)workbook).dispose();
                    }
                    operationResponse = OperationResponse.SUCCESS;
                    if (workbook == null) break block17;
                }
                catch (Throwable throwable) {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                workbook.close();
            }
            return operationResponse;
        }
        catch (IOException e2) {
            a.error("fail to export rogue ap list", (Throwable)e2);
            return OperationResponse.GENERAL_ERROR;
        }
    }
}

