/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.domain.model.insight.ips.dto;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.monitor.api.web.security.dto.ThreatCategoryVO;
import com.tplink.smb.omada.monitor.api.web.security.dto.ThreatMapCategoryVO;
import com.tplink.smb.omada.monitor.api.web.security.dto.a;
import com.tplink.smb.omada.monitor.domain.model.insight.ips.dto.DstCountryCountDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeepClass
public class ThreatMapCategoryDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreatMapCategoryDTO.class);
    private String srcCountry;
    private String dstCountry;
    private Integer severity;
    private Double dstLatitude;
    private Double dstLongitude;
    private Long attempts;

    public static ThreatMapCategoryVO builtByDTOList(Map<String, ThreatMapCategoryDTO> dto) {
        ArrayList voList = new ArrayList();
        HashMap<String, DstCountryCountDTO> dstCountryCountDTOMap = new HashMap<String, DstCountryCountDTO>();
        dto.forEach((k2, v2) -> {
            String[] key = k2.split("\\+");
            DstCountryCountDTO dstDTO = new DstCountryCountDTO();
            if (dstCountryCountDTOMap.containsKey(key[0])) {
                dstDTO = ThreatMapCategoryDTO.handleDstMapDTO(v2, key[1], dstDTO);
                DstCountryCountDTO temp = (DstCountryCountDTO)dstCountryCountDTOMap.get(key[0]);
                dstCountryCountDTOMap.put(key[0], ThreatMapCategoryDTO.handleMap(dstDTO, temp));
            } else {
                dstDTO = ThreatMapCategoryDTO.handleDstMapDTO(v2, key[1], dstDTO);
                dstCountryCountDTOMap.put(key[0], dstDTO);
            }
        });
        dstCountryCountDTOMap.forEach((dstCountry, value) -> {
            if (Objects.isNull(value.getDstLongitude()) || Objects.isNull(value.getDstLatitude())) {
                return;
            }
            ArrayList<Double> coords = new ArrayList<Double>();
            coords.add(value.getDstLongitude());
            coords.add(value.getDstLatitude());
            ThreatCategoryVO threatCategoryVO = new ThreatCategoryVO();
            threatCategoryVO.setCountry(value.getDstCountry());
            threatCategoryVO.setCoords(coords);
            threatCategoryVO.setAttempts(ThreatMapCategoryDTO.handCount2List(value));
            voList.add(threatCategoryVO);
        });
        return new ThreatMapCategoryVO(voList);
    }

    private static DstCountryCountDTO handleMap(DstCountryCountDTO dstDTO, DstCountryCountDTO temp) {
        DstCountryCountDTO dstCountryCountDTO = new DstCountryCountDTO();
        dstCountryCountDTO.setModerate(0L == dstDTO.getModerate() ? temp.getModerate() : dstDTO.getModerate());
        dstCountryCountDTO.setCritical(0L == dstDTO.getCritical() ? temp.getCritical() : dstDTO.getCritical());
        dstCountryCountDTO.setMajor(0L == dstDTO.getMajor() ? temp.getMajor() : dstDTO.getMajor());
        dstCountryCountDTO.setMinor(0L == dstDTO.getMinor() ? temp.getMinor() : dstDTO.getMinor());
        dstCountryCountDTO.setLow(0L == dstDTO.getLow() ? temp.getLow() : dstDTO.getLow());
        dstCountryCountDTO.setDstCountry(temp.getDstCountry());
        dstCountryCountDTO.setDstLatitude(temp.getDstLatitude());
        dstCountryCountDTO.setDstLongitude(temp.getDstLongitude());
        dstCountryCountDTO.setSrcCountry(temp.getSrcCountry());
        return dstCountryCountDTO;
    }

    private static DstCountryCountDTO handleDstMapDTO(ThreatMapCategoryDTO v2, String type, DstCountryCountDTO dstDTO) {
        a severity = a.a((Integer)Integer.valueOf(type));
        if (Objects.isNull(severity)) {
            log.warn("SeverityEnum is null ThreatMapCategoryDTO {}", (Object)x.a((Object)v2));
            return dstDTO;
        }
        switch (severity) {
            case a: {
                dstDTO.setCritical(v2.getAttempts());
                break;
            }
            case b: {
                dstDTO.setMajor(v2.getAttempts());
                break;
            }
            case c: {
                dstDTO.setModerate(v2.getAttempts());
                break;
            }
            case e: {
                dstDTO.setLow(v2.getAttempts());
                break;
            }
            default: {
                dstDTO.setMinor(v2.getAttempts());
            }
        }
        dstDTO.setDstCountry(v2.getDstCountry());
        dstDTO.setSrcCountry(v2.getSrcCountry());
        dstDTO.setDstLatitude(v2.getDstLatitude());
        dstDTO.setDstLongitude(v2.getDstLongitude());
        return dstDTO;
    }

    private static List<Long> handCount2List(DstCountryCountDTO value) {
        ArrayList<Long> countList = new ArrayList<Long>();
        countList.add(Objects.isNull(value.getLow()) ? 0L : value.getLow());
        countList.add(Objects.isNull(value.getMinor()) ? 0L : value.getMinor());
        countList.add(Objects.isNull(value.getModerate()) ? 0L : value.getModerate());
        countList.add(Objects.isNull(value.getMajor()) ? 0L : value.getMajor());
        countList.add(Objects.isNull(value.getCritical()) ? 0L : value.getCritical());
        return countList;
    }

    @Generated
    public String getSrcCountry() {
        return this.srcCountry;
    }

    @Generated
    public String getDstCountry() {
        return this.dstCountry;
    }

    @Generated
    public Integer getSeverity() {
        return this.severity;
    }

    @Generated
    public Double getDstLatitude() {
        return this.dstLatitude;
    }

    @Generated
    public Double getDstLongitude() {
        return this.dstLongitude;
    }

    @Generated
    public Long getAttempts() {
        return this.attempts;
    }

    @Generated
    public void setSrcCountry(String srcCountry) {
        this.srcCountry = srcCountry;
    }

    @Generated
    public void setDstCountry(String dstCountry) {
        this.dstCountry = dstCountry;
    }

    @Generated
    public void setSeverity(Integer severity) {
        this.severity = severity;
    }

    @Generated
    public void setDstLatitude(Double dstLatitude) {
        this.dstLatitude = dstLatitude;
    }

    @Generated
    public void setDstLongitude(Double dstLongitude) {
        this.dstLongitude = dstLongitude;
    }

    @Generated
    public void setAttempts(Long attempts) {
        this.attempts = attempts;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ThreatMapCategoryDTO)) {
            return false;
        }
        ThreatMapCategoryDTO other = (ThreatMapCategoryDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$severity = this.getSeverity();
        Integer other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)this$severity).equals(other$severity)) {
            return false;
        }
        Double this$dstLatitude = this.getDstLatitude();
        Double other$dstLatitude = other.getDstLatitude();
        if (this$dstLatitude == null ? other$dstLatitude != null : !((Object)this$dstLatitude).equals(other$dstLatitude)) {
            return false;
        }
        Double this$dstLongitude = this.getDstLongitude();
        Double other$dstLongitude = other.getDstLongitude();
        if (this$dstLongitude == null ? other$dstLongitude != null : !((Object)this$dstLongitude).equals(other$dstLongitude)) {
            return false;
        }
        Long this$attempts = this.getAttempts();
        Long other$attempts = other.getAttempts();
        if (this$attempts == null ? other$attempts != null : !((Object)this$attempts).equals(other$attempts)) {
            return false;
        }
        String this$srcCountry = this.getSrcCountry();
        String other$srcCountry = other.getSrcCountry();
        if (this$srcCountry == null ? other$srcCountry != null : !this$srcCountry.equals(other$srcCountry)) {
            return false;
        }
        String this$dstCountry = this.getDstCountry();
        String other$dstCountry = other.getDstCountry();
        return !(this$dstCountry == null ? other$dstCountry != null : !this$dstCountry.equals(other$dstCountry));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ThreatMapCategoryDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)$severity).hashCode());
        Double $dstLatitude = this.getDstLatitude();
        result = result * 59 + ($dstLatitude == null ? 43 : ((Object)$dstLatitude).hashCode());
        Double $dstLongitude = this.getDstLongitude();
        result = result * 59 + ($dstLongitude == null ? 43 : ((Object)$dstLongitude).hashCode());
        Long $attempts = this.getAttempts();
        result = result * 59 + ($attempts == null ? 43 : ((Object)$attempts).hashCode());
        String $srcCountry = this.getSrcCountry();
        result = result * 59 + ($srcCountry == null ? 43 : $srcCountry.hashCode());
        String $dstCountry = this.getDstCountry();
        result = result * 59 + ($dstCountry == null ? 43 : $dstCountry.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ThreatMapCategoryDTO(srcCountry=" + this.getSrcCountry() + ", dstCountry=" + this.getDstCountry() + ", severity=" + this.getSeverity() + ", dstLatitude=" + this.getDstLatitude() + ", dstLongitude=" + this.getDstLongitude() + ", attempts=" + this.getAttempts() + ")";
    }

    @Generated
    public ThreatMapCategoryDTO() {
    }

    @Generated
    public ThreatMapCategoryDTO(String srcCountry, String dstCountry, Integer severity, Double dstLatitude, Double dstLongitude, Long attempts) {
        this.srcCountry = srcCountry;
        this.dstCountry = dstCountry;
        this.severity = severity;
        this.dstLatitude = dstLatitude;
        this.dstLongitude = dstLongitude;
        this.attempts = attempts;
    }
}

