/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.domain.model.insight.ips;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.region.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.device.manage.message.inform.osg.IpsThreatData;
import java.util.Objects;
import lombok.Generated;

@KeepClass
public class IpsThreat {
    private String id;
    private String omadacId;
    private String siteId;
    private String siteName;
    private Long time;
    private Integer severity;
    private String service;
    private Integer category;
    private String activity;
    private Long dataUsage;
    private String srcIp;
    private String dstIp;
    private String srcCountry;
    private String dstCountry;
    private String protocol;
    private Long sid;
    private Double srcLatitude;
    private Double srcLongitude;
    private Double dstLatitude;
    private Double dstLongitude;
    private Boolean archived;
    private String classification;
    private Long createTime;

    public static IpsThreat fromThreatData(String omadacId, String siteId, String siteName, IpsThreatData ipsThreatData) {
        b coordsEnum;
        String srcIpCountry = IpsThreat.checkCodeLegel(ipsThreatData.getSrcIpCountry());
        String dstIpCountry = IpsThreat.checkCodeLegel(ipsThreatData.getDstIpCountry());
        Double srcLatitude = null;
        Double srcLongitude = null;
        Double dstLatitude = null;
        Double dstLongitude = null;
        if (!T.c((String)srcIpCountry) && Objects.nonNull(coordsEnum = b.a((String)srcIpCountry))) {
            srcLatitude = coordsEnum.c();
            srcLongitude = coordsEnum.d();
        }
        if (!T.c((String)dstIpCountry) && Objects.nonNull(coordsEnum = b.a((String)dstIpCountry))) {
            dstLatitude = coordsEnum.c();
            dstLongitude = coordsEnum.d();
        }
        IpsThreat ipsThreat = new IpsThreat();
        ipsThreat.setTime(ipsThreatData.getTime());
        ipsThreat.setSeverity(ipsThreatData.getSeverity());
        ipsThreat.setService(ipsThreatData.getThreatDescription());
        ipsThreat.setCategory(ipsThreatData.getCategoryId());
        ipsThreat.setActivity(ipsThreatData.getClassDescription());
        ipsThreat.setDataUsage(ipsThreatData.getDataUsage());
        ipsThreat.setSrcIp(ipsThreatData.getSrcIp());
        ipsThreat.setDstIp(ipsThreatData.getDstIp());
        ipsThreat.setSrcCountry(srcIpCountry);
        ipsThreat.setDstCountry(dstIpCountry);
        ipsThreat.setProtocol(ipsThreatData.getProtocol());
        ipsThreat.setSid(ipsThreatData.getSid());
        ipsThreat.setClassification(ipsThreatData.getClassification());
        ipsThreat.setSrcLatitude(srcLatitude);
        ipsThreat.setSrcLongitude(srcLongitude);
        ipsThreat.setDstLatitude(dstLatitude);
        ipsThreat.setDstLongitude(dstLongitude);
        ipsThreat.setOmadacId(omadacId);
        ipsThreat.setSiteId(siteId);
        ipsThreat.setSiteName(siteName);
        ipsThreat.setArchived(false);
        return ipsThreat;
    }

    public static String checkCodeLegel(String countryCode) {
        if (T.c((String)countryCode) || countryCode.length() != 2) {
            return "";
        }
        return countryCode;
    }

    @Generated
    public IpsThreat(String id, String omadacId, String siteId, String siteName, Long time, Integer severity, String service, Integer category, String activity, Long dataUsage, String srcIp, String dstIp, String srcCountry, String dstCountry, String protocol, Long sid, Double srcLatitude, Double srcLongitude, Double dstLatitude, Double dstLongitude, Boolean archived, String classification, Long createTime) {
        this.id = id;
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.siteName = siteName;
        this.time = time;
        this.severity = severity;
        this.service = service;
        this.category = category;
        this.activity = activity;
        this.dataUsage = dataUsage;
        this.srcIp = srcIp;
        this.dstIp = dstIp;
        this.srcCountry = srcCountry;
        this.dstCountry = dstCountry;
        this.protocol = protocol;
        this.sid = sid;
        this.srcLatitude = srcLatitude;
        this.srcLongitude = srcLongitude;
        this.dstLatitude = dstLatitude;
        this.dstLongitude = dstLongitude;
        this.archived = archived;
        this.classification = classification;
        this.createTime = createTime;
    }

    @Generated
    public IpsThreat() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getSiteName() {
        return this.siteName;
    }

    @Generated
    public Long getTime() {
        return this.time;
    }

    @Generated
    public Integer getSeverity() {
        return this.severity;
    }

    @Generated
    public String getService() {
        return this.service;
    }

    @Generated
    public Integer getCategory() {
        return this.category;
    }

    @Generated
    public String getActivity() {
        return this.activity;
    }

    @Generated
    public Long getDataUsage() {
        return this.dataUsage;
    }

    @Generated
    public String getSrcIp() {
        return this.srcIp;
    }

    @Generated
    public String getDstIp() {
        return this.dstIp;
    }

    @Generated
    public String getSrcCountry() {
        return this.srcCountry;
    }

    @Generated
    public String getDstCountry() {
        return this.dstCountry;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public Long getSid() {
        return this.sid;
    }

    @Generated
    public Double getSrcLatitude() {
        return this.srcLatitude;
    }

    @Generated
    public Double getSrcLongitude() {
        return this.srcLongitude;
    }

    @Generated
    public Double getDstLatitude() {
        return this.dstLatitude;
    }

    @Generated
    public Double getDstLongitude() {
        return this.dstLongitude;
    }

    @Generated
    public Boolean getArchived() {
        return this.archived;
    }

    @Generated
    public String getClassification() {
        return this.classification;
    }

    @Generated
    public Long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    @Generated
    public void setTime(Long time) {
        this.time = time;
    }

    @Generated
    public void setSeverity(Integer severity) {
        this.severity = severity;
    }

    @Generated
    public void setService(String service) {
        this.service = service;
    }

    @Generated
    public void setCategory(Integer category) {
        this.category = category;
    }

    @Generated
    public void setActivity(String activity) {
        this.activity = activity;
    }

    @Generated
    public void setDataUsage(Long dataUsage) {
        this.dataUsage = dataUsage;
    }

    @Generated
    public void setSrcIp(String srcIp) {
        this.srcIp = srcIp;
    }

    @Generated
    public void setDstIp(String dstIp) {
        this.dstIp = dstIp;
    }

    @Generated
    public void setSrcCountry(String srcCountry) {
        this.srcCountry = srcCountry;
    }

    @Generated
    public void setDstCountry(String dstCountry) {
        this.dstCountry = dstCountry;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setSid(Long sid) {
        this.sid = sid;
    }

    @Generated
    public void setSrcLatitude(Double srcLatitude) {
        this.srcLatitude = srcLatitude;
    }

    @Generated
    public void setSrcLongitude(Double srcLongitude) {
        this.srcLongitude = srcLongitude;
    }

    @Generated
    public void setDstLatitude(Double dstLatitude) {
        this.dstLatitude = dstLatitude;
    }

    @Generated
    public void setDstLongitude(Double dstLongitude) {
        this.dstLongitude = dstLongitude;
    }

    @Generated
    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    @Generated
    public void setClassification(String classification) {
        this.classification = classification;
    }

    @Generated
    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }
}

