/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.domain.model.dashboard.overview;

import com.tplink.smb.omada.common.device.StandardOswPortIndex;
import com.tplink.smb.omada.device.manage.message.body.osg.OsgInformBody;
import com.tplink.smb.omada.device.manage.message.body.osw.OswInformBody;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswPoeStatus;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswPortPoeStatus;
import com.tplink.smb.omada.manager.device.api.internal.event.inform.osg.OsgInformDomainEventDTO;
import com.tplink.smb.omada.manager.device.api.internal.event.inform.osw.OswInformDomainEventDTO;
import com.tplink.smb.omada.monitor.domain.model.dashboard.overview.OverviewOsgCachePO;
import com.tplink.smb.omada.monitor.domain.model.dashboard.overview.OverviewOswCachePO;
import com.tplink.smb.omada.monitor.domain.model.dashboard.overview.g;
import com.tplink.smb.omada.monitor.domain.model.dashboard.overview.h;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class d {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(d.class);
    @Autowired
    private g b;
    @Autowired
    private h c;
    private static final Integer d = 0;

    public void a(OsgInformDomainEventDTO command) {
        OsgInformBody informBody = (OsgInformBody)command.getInformBody();
        if (Objects.isNull(informBody.getTrafficStat()) || Objects.isNull(informBody.getTrafficStat().getPortTrafficList())) {
            return;
        }
        OverviewOsgCachePO overviewOsgCachePO = new OverviewOsgCachePO();
        overviewOsgCachePO.setPortTrafficList(informBody.getTrafficStat().getPortTrafficList());
        this.b.a(command.getOmadacId(), command.getSiteId(), overviewOsgCachePO);
    }

    public void a(OswInformDomainEventDTO command) {
        OswInformBody informBody = (OswInformBody)command.getInformBody();
        if (Objects.isNull(informBody.getPort()) || Objects.isNull(informBody.getDeviceInfo())) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)informBody.getDeviceInfo().getStackUnits())) {
            this.c(command);
        } else {
            this.b(command);
        }
    }

    private void b(OswInformDomainEventDTO command) {
        OswInformBody informBody = (OswInformBody)command.getInformBody();
        OswPoeStatus oswPoeStatus = informBody.getPoe();
        Map<Object, Object> stackUnitPoeStatusMap = Objects.nonNull(oswPoeStatus) && !CollectionUtils.isEmpty((Collection)oswPoeStatus.getStackUnitPoeStatuses()) ? oswPoeStatus.getStackUnitPoeStatuses().stream().collect(Collectors.toMap(OswPoeStatus.StackUnitPoeStatus::getUnit, poeStatus -> poeStatus, (k1, k2) -> k1)) : new HashMap();
        Map<Object, Object> oswPortPoeStatusMap = Objects.nonNull(oswPoeStatus) && !CollectionUtils.isEmpty((Collection)oswPoeStatus.getStackUnitPoeStatuses()) ? oswPoeStatus.getPorts().stream().collect(Collectors.groupingBy(oswPortStatus -> StandardOswPortIndex.resolveStandardPortIndex((Integer)oswPortStatus.getPortId(), (String)oswPortStatus.getStandardOswPort()).getUnit())) : new HashMap();
        Map<Object, Object> oswPortStatusMap = Objects.nonNull(informBody.getPort()) && !CollectionUtils.isEmpty((Collection)informBody.getPort().getPorts()) ? informBody.getPort().getPorts().stream().collect(Collectors.groupingBy(oswPortStatus -> StandardOswPortIndex.resolveStandardPortIndex((Integer)oswPortStatus.getPort(), (String)oswPortStatus.getStandardPort()).getUnit())) : new HashMap();
        informBody.getDeviceInfo().getStackUnits().forEach(deviceInfoStackUnit -> {
            boolean supportPoe;
            String mac = deviceInfoStackUnit.getMac();
            Integer unit = deviceInfoStackUnit.getUnit();
            if (!this.a(mac, command)) {
                return;
            }
            OverviewOswCachePO overviewOswCachePO = new OverviewOswCachePO();
            boolean uploadPort = !CollectionUtils.isEmpty((Map)oswPortStatusMap) && oswPortStatusMap.containsKey(unit);
            boolean bl = supportPoe = !CollectionUtils.isEmpty((Map)stackUnitPoeStatusMap) && stackUnitPoeStatusMap.containsKey(unit) && Objects.nonNull(((OswPoeStatus.StackUnitPoeStatus)stackUnitPoeStatusMap.get(unit)).getRemain()) && Objects.nonNull(((OswPoeStatus.StackUnitPoeStatus)stackUnitPoeStatusMap.get(unit)).getRemainPercent()) && !CollectionUtils.isEmpty((Map)oswPortPoeStatusMap) && oswPortPoeStatusMap.containsKey(unit) && !CollectionUtils.isEmpty((Collection)((Collection)oswPortPoeStatusMap.get(unit)));
            if (!supportPoe) {
                OverviewOswCachePO cachePO = this.c.b(command.getOmadacId(), command.getSiteId(), mac);
                if (Objects.isNull(cachePO) || Objects.isNull(cachePO.getTotalPowerUsed())) {
                    overviewOswCachePO.setTotalPowerUsed(0.0);
                } else {
                    overviewOswCachePO.setTotalPowerUsed(cachePO.getTotalPowerUsed());
                }
            } else {
                Double remain = ((OswPoeStatus.StackUnitPoeStatus)stackUnitPoeStatusMap.get(unit)).getRemain();
                Double remainPercent = ((OswPoeStatus.StackUnitPoeStatus)stackUnitPoeStatusMap.get(unit)).getRemainPercent();
                if (remain == 0.0 || remainPercent == 0.0) {
                    double powerUsed = 0.0;
                    for (OswPortPoeStatus portStatus : (List)oswPortPoeStatusMap.get(unit)) {
                        if (!Objects.equals(d, portStatus.getState()) || portStatus.getPower() == null) continue;
                        powerUsed += portStatus.getPower().doubleValue();
                    }
                    overviewOswCachePO.setTotalPowerUsed(powerUsed);
                } else {
                    overviewOswCachePO.setTotalPowerUsed(Math.max(0.0, remain / remainPercent * 100.0 - remain));
                }
            }
            if (uploadPort) {
                overviewOswCachePO.setPortNum(((List)oswPortStatusMap.get(unit)).size());
                overviewOswCachePO.setPorts((List)oswPortStatusMap.get(unit));
            }
            this.c.a(command.getOmadacId(), command.getSiteId(), mac, overviewOswCachePO);
        });
    }

    private void c(OswInformDomainEventDTO command) {
        OswInformBody informBody = (OswInformBody)command.getInformBody();
        OswPoeStatus oswPoeStatus = informBody.getPoe();
        OverviewOswCachePO overviewOswCachePO = new OverviewOswCachePO();
        if (Objects.isNull(oswPoeStatus) || Objects.isNull(oswPoeStatus.getRemain()) || Objects.isNull(oswPoeStatus.getRemainPercent())) {
            OverviewOswCachePO cachePO = this.c.b(command.getOmadacId(), command.getSiteId(), command.getDeviceMac());
            if (Objects.isNull(cachePO) || Objects.isNull(cachePO.getTotalPowerUsed())) {
                overviewOswCachePO.setTotalPowerUsed(0.0);
            } else {
                overviewOswCachePO.setTotalPowerUsed(cachePO.getTotalPowerUsed());
            }
        } else {
            if (oswPoeStatus.getRemain() == 0.0 || oswPoeStatus.getRemainPercent() == 0.0) {
                double powerUsed = 0.0;
                for (OswPortPoeStatus portStatus : oswPoeStatus.getPorts()) {
                    if (!Objects.equals(0, portStatus.getState()) || portStatus.getPower() == null) continue;
                    powerUsed += portStatus.getPower().doubleValue();
                }
                overviewOswCachePO.setTotalPowerUsed(powerUsed);
            } else {
                overviewOswCachePO.setTotalPowerUsed(Math.max(0.0, oswPoeStatus.getRemain() / oswPoeStatus.getRemainPercent() * 100.0 - oswPoeStatus.getRemain()));
            }
            if (Objects.nonNull(oswPoeStatus.getTotal())) {
                overviewOswCachePO.setTotalPowerUsed(oswPoeStatus.getTotal() - oswPoeStatus.getRemain());
            }
        }
        overviewOswCachePO.setPortNum(informBody.getPort().getPorts().size());
        overviewOswCachePO.setPorts(informBody.getPort().getPorts());
        this.c.a(command.getOmadacId(), command.getSiteId(), command.getDeviceMac(), overviewOswCachePO);
    }

    private boolean a(String mac, OswInformDomainEventDTO informDTO) {
        if (!Boolean.TRUE.equals(informDTO.getCheckoutLicense())) {
            return true;
        }
        return Optional.ofNullable(informDTO.getStackMemberActiveMap()).map(map -> map.getOrDefault(mac, false)).orElse(false);
    }

    public void a(String omadacId, String siteId) {
        a.debug("osg overview data of omadacId: {}, siteId: {} has been deleted", (Object)omadacId, (Object)siteId);
        this.b.a(omadacId, siteId);
    }

    public void a(String omadacId, String siteId, List<String> macs) {
        macs.forEach(mac -> {
            a.debug("osw overview data of omadacId: {}, siteId: {}, Mac: {} has been deleted", new Object[]{omadacId, siteId, mac});
            this.c.a(omadacId, siteId, (String)mac);
        });
    }

    public void b(String omadacId, String siteId) {
        a.debug("delete osg and osw overview data of omadacId: {}, siteId: {}", (Object)omadacId, (Object)siteId);
        this.b.a(omadacId, siteId);
        this.c.a(omadacId, siteId);
    }
}

