/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.domain.model.dashboard.a.a;

import com.google.common.collect.Lists;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.osg.OsgInformBody;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgPoeStatus;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgPortPoeStatus;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgPortStatus;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.osg.OsgPoePortCapDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.f;
import com.tplink.smb.omada.manager.device.api.internal.dto.DeviceQueryDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.osg.OsgImageCapabilityDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.osg.OsgImageDTO;
import com.tplink.smb.omada.manager.device.api.internal.event.inform.osg.OsgInformDomainEventDTO;
import com.tplink.smb.omada.monitor.domain.model.dashboard.a.a.a;
import com.tplink.smb.omada.monitor.domain.model.dashboard.a.a.c;
import com.tplink.smb.omada.monitor.domain.model.dashboard.a.g;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class b {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    private a b;
    @Autowired
    private f c;
    private final int d = 30;
    private final int e = 1;

    private int a(String omadacId, String siteId, String mac, int portId) {
        Integer poePortLimit = this.b.a(omadacId, siteId, mac, portId);
        if (Objects.nonNull(poePortLimit)) {
            return poePortLimit;
        }
        DeviceQueryDTO deviceQueryDTO = new DeviceQueryDTO(omadacId, mac);
        OsgImageDTO osgImageDTO = this.c.a(deviceQueryDTO);
        if (a.isDebugEnabled()) {
            a.debug("osg image is {}, omadacId {}, siteId {}", new Object[]{x.a((Object)osgImageDTO), omadacId, siteId});
        }
        boolean fromCombinedGateway = false;
        if (Objects.isNull(osgImageDTO) || Objects.isNull(osgImageDTO.getCapability())) {
            poePortLimit = 30;
        } else {
            List poePortsEntrys = ((OsgImageCapabilityDTO)osgImageDTO.getCapability()).getPoePortsEntrys();
            if (!CollectionUtils.isEmpty((Collection)poePortsEntrys)) {
                OsgPoePortCapDTO osgPoePortCapDTO = poePortsEntrys.stream().filter(v2 -> Objects.equals(v2.getPoePort(), portId)).findFirst().orElse(null);
                if (!Objects.isNull(osgPoePortCapDTO)) {
                    poePortLimit = osgPoePortCapDTO.getMaxPower().intValue();
                }
            } else {
                poePortLimit = ((OsgImageCapabilityDTO)osgImageDTO.getCapability()).getPoePortLimit();
                fromCombinedGateway = true;
            }
        }
        if (Objects.isNull(poePortLimit) || poePortLimit == 0) {
            poePortLimit = 30;
        } else if (fromCombinedGateway) {
            poePortLimit = poePortLimit / 10;
        }
        this.b.a(omadacId, siteId, mac, portId, poePortLimit);
        a.debug("osg poe utilization limit is {}, omadacId {}, siteId {}", new Object[]{poePortLimit, omadacId, siteId});
        return poePortLimit;
    }

    public void a(OsgInformDomainEventDTO command) {
        OsgInformBody osgInformBody = (OsgInformBody)command.getInformBody();
        if (a.isDebugEnabled()) {
            a.debug("handlePoeUtilizationInform osgInformBody {}", (Object)x.a((Object)osgInformBody));
        }
        if (Objects.isNull(osgInformBody) || Objects.isNull(osgInformBody.getPortInfo()) || Objects.isNull(osgInformBody.getPortInfo().getPortStatusList())) {
            a.debug("getting ports failed from inform body: {}", (Object)osgInformBody);
            return;
        }
        List osgPorts = osgInformBody.getPortInfo().getPortStatusList();
        OsgPoeStatus osgPoeStatus = osgInformBody.getPoe();
        if (Objects.isNull(osgPoeStatus)) {
            return;
        }
        if (Objects.isNull(osgPoeStatus.getRemain()) || Objects.isNull(osgPoeStatus.getRemainPercent())) {
            a.debug("invalid poe remain/percent, omadacId: {}, siteId: {}, osg: {}", new Object[]{command.getOmadacId(), command.getSiteId(), command.getDeviceMac()});
            return;
        }
        com.tplink.smb.omada.monitor.domain.model.dashboard.a.b poeUtilization = com.tplink.smb.omada.monitor.domain.model.dashboard.a.a.c.a(osgPoeStatus);
        if (Objects.isNull(poeUtilization)) {
            return;
        }
        poeUtilization.a(command.getOmadacId());
        poeUtilization.b(command.getSiteId());
        poeUtilization.c(command.getDeviceMac());
        ArrayList portPoes = Lists.newArrayList();
        for (OsgPortStatus osgPortStatus : osgPorts) {
            int portId = osgPortStatus.getPort();
            g unsupported = new g();
            unsupported.a(Boolean.FALSE);
            unsupported.a(portId);
            portPoes.add(unsupported);
        }
        portPoes.sort(Comparator.comparingInt(g::c));
        Double totalPower = 0.0;
        for (OsgPortPoeStatus portStatus : osgPoeStatus.getPorts()) {
            g portPoe;
            int portId = portStatus.getPortId();
            if (Objects.equals(1, portStatus.getState()) && portStatus.getPower() != null) {
                portPoe = new g();
                portPoe.a(Boolean.TRUE);
                portPoe.b(Boolean.TRUE);
                portPoe.a(portId);
                portPoe.b(portStatus.getPower().intValue());
                int poePercent = (int)((double)portPoe.d().intValue() / (double)this.a(poeUtilization.b(), poeUtilization.c(), poeUtilization.d(), portId) * 100.0);
                portPoe.c(Math.min(poePercent, 100));
                portPoes.set(portId - 1, portPoe);
                totalPower = totalPower + portStatus.getPower();
                continue;
            }
            portPoe = new g();
            portPoe.a(Boolean.TRUE);
            portPoe.b(Boolean.FALSE);
            portPoe.a(portStatus.getPortId());
            portPoes.set(portId - 1, portPoe);
        }
        poeUtilization.a(portPoes);
        poeUtilization.b((int)Math.round(totalPower));
        if (osgPoeStatus.getRemainPercent() == 0.0) {
            poeUtilization.c(totalPower.intValue());
        } else {
            poeUtilization.c((int)Math.round(osgPoeStatus.getRemain() / (osgPoeStatus.getRemainPercent() / 100.0)));
        }
        poeUtilization.a(this.a(100.0 - osgPoeStatus.getRemainPercent(), 2));
        this.b.a(command.getOmadacId(), command.getSiteId(), command.getDeviceMac(), poeUtilization);
    }

    public void a(String omadacId, String siteId) {
        a.debug("delete osg poe utilization data of omadacId: {}, siteId: {}", (Object)omadacId, (Object)siteId);
        this.b.a(omadacId, siteId);
    }

    public void b(String omadacId, String siteId) {
        a.debug("osg poe utilization data of omadacId: {}, siteId: {} has been deleted", (Object)omadacId, (Object)siteId);
        this.b.a(omadacId, siteId);
    }

    public double a(double value, int scale) {
        BigDecimal bigDecimal = BigDecimal.valueOf(value);
        return bigDecimal.setScale(scale, 4).doubleValue();
    }

    public void c(String omadacId, String siteId) {
        a.debug("osg poe Port Limit data of omadacId: {}, siteId: {} has been deleted", (Object)omadacId, (Object)siteId);
        this.b.c(omadacId, siteId);
    }
}

