/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.domain.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.gridquery.QueryDataVO;
import com.tplink.smb.omada.common.util.Y;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.internal.site.vpn.GetVpnRequestDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.vpn.GetVpnResponseDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.vpn.VpnMonitorDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.vpn.a;
import com.tplink.smb.omada.monitor.api.web.dashboard.dto.IpsecVpnStatsVO;
import com.tplink.smb.omada.monitor.api.web.insight.dto.DashboardVpnStatsVO;
import com.tplink.smb.omada.monitor.api.web.insight.dto.OsgVpnIpSecVO;
import com.tplink.smb.omada.monitor.api.web.insight.dto.OsgVpnTunnelVO;
import com.tplink.smb.omada.monitor.domain.model.insight.e.c;
import com.tplink.smb.omada.monitor.domain.model.insight.e.e;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetVpnStatsService {
    @Generated
    private static final Logger c = LoggerFactory.getLogger(GetVpnStatsService.class);
    @Autowired
    private c d;
    @Autowired
    private e e;
    @Autowired
    private a f;
    private static final int g = 0;
    private static final Integer h = 0;
    private static final Integer i = 1;
    private static final Integer j = 3;
    public static final String a = "server";
    public static final String b = "vpn";

    public OperationResponse a(String omadacId, String siteId, QueryDataVO queryDataVO) {
        if (StringUtils.isBlank((CharSequence)omadacId) || StringUtils.isBlank((CharSequence)siteId) || queryDataVO == null) {
            c.warn("invalid param, omadacId :{}, siteId :{}, queryDataVO :{}", new Object[]{omadacId, siteId, queryDataVO});
            return OperationResponse.PARAM_ERROR;
        }
        List<OsgVpnIpSecVO> cacheList = this.d.b(omadacId, siteId);
        GridVO gridVO = new GridVO(0L, queryDataVO.getCurrentPage(), queryDataVO.getCurrentPageSize());
        if (CollectionUtils.isEmpty(cacheList)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)gridVO);
        }
        Set<Integer> vpnIds = cacheList.stream().map(OsgVpnIpSecVO::getVpnId).collect(Collectors.toSet());
        List<VpnMonitorDTO> vpns = this.a(omadacId, siteId, vpnIds);
        if (!CollectionUtils.isEmpty(vpns)) {
            Map<Integer, String> vpnIdToNameMap = vpns.stream().collect(Collectors.toMap(VpnMonitorDTO::getEntryId, VpnMonitorDTO::getName));
            for (OsgVpnIpSecVO osgVpnIpSecVO : cacheList) {
                osgVpnIpSecVO.setName(vpnIdToNameMap.get(osgVpnIpSecVO.getVpnId()));
            }
            cacheList.sort(Comparator.comparing(OsgVpnIpSecVO::getName, Comparator.nullsLast(Comparator.naturalOrder())));
        }
        gridVO.setTotalRows((long)cacheList.size());
        this.a(gridVO, cacheList);
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)gridVO);
    }

    public OperationResponse b(String omadacId, String siteId, QueryDataVO queryDataVO) {
        if (StringUtils.isBlank((CharSequence)omadacId) || StringUtils.isBlank((CharSequence)siteId) || queryDataVO == null) {
            c.warn("invalid param, omadacId :{}, siteId :{}, queryDataVO :{}", new Object[]{omadacId, siteId, queryDataVO});
            return OperationResponse.PARAM_ERROR;
        }
        List<OsgVpnTunnelVO> cacheList = this.e.b(omadacId, siteId);
        GridVO gridVO = new GridVO(0L, queryDataVO.getCurrentPage(), queryDataVO.getCurrentPageSize());
        if (CollectionUtils.isEmpty(cacheList)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)gridVO);
        }
        if (queryDataVO.getFilters() != null && !queryDataVO.getFilters().isEmpty()) {
            cacheList = this.a(cacheList, queryDataVO.getFilters(), omadacId, siteId);
        }
        cacheList.sort(Comparator.comparing(OsgVpnTunnelVO::getUptime, Comparator.nullsFirst(Comparator.naturalOrder())).reversed());
        gridVO.setTotalRows((long)cacheList.size());
        Set<Integer> vpnIds = cacheList.stream().map(OsgVpnTunnelVO::getVpnId).collect(Collectors.toSet());
        List<VpnMonitorDTO> vpns = this.a(omadacId, siteId, vpnIds);
        if (CollectionUtils.isNotEmpty(vpns)) {
            Map<Integer, String> vpnIdNameMap = vpns.stream().collect(Collectors.toMap(VpnMonitorDTO::getEntryId, VpnMonitorDTO::getName));
            for (OsgVpnTunnelVO osgVpnTunnelVO : cacheList) {
                osgVpnTunnelVO.setVpnName(vpnIdNameMap.get(osgVpnTunnelVO.getVpnId()));
            }
        }
        this.a(gridVO, cacheList);
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)gridVO);
    }

    public OperationResponse a(String omadacId, String siteId, Integer type) {
        if (StringUtils.isEmpty((CharSequence)siteId) || !h.equals(type) && !i.equals(type)) {
            c.warn("Invalid param , site: {}, vpnType: {}", (Object)siteId, (Object)type);
            return OperationResponse.PARAM_ERROR;
        }
        List<Object> vpnTunnelList = this.e.b(omadacId, siteId);
        if (CollectionUtils.isEmpty(vpnTunnelList)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, Collections.emptyList());
        }
        vpnTunnelList = vpnTunnelList.stream().filter(item -> Objects.equals(item.getServerType(), type) && !j.equals(item.getVpnType())).collect(Collectors.toList());
        Set<Integer> vpnIds = vpnTunnelList.stream().map(OsgVpnTunnelVO::getVpnId).collect(Collectors.toSet());
        List<VpnMonitorDTO> vpns = this.a(omadacId, siteId, vpnIds);
        Map<Integer, VpnMonitorDTO> idToVpnDOMap = vpns.stream().collect(Collectors.toMap(VpnMonitorDTO::getEntryId, Function.identity()));
        if (i.equals(type)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, this.b(siteId, vpnTunnelList, idToVpnDOMap));
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, this.a(siteId, vpnTunnelList, idToVpnDOMap));
    }

    public OperationResponse a(String omadacId, String siteId) {
        if (StringUtils.isEmpty((CharSequence)omadacId) || StringUtils.isEmpty((CharSequence)siteId)) {
            c.warn("Invalid param when get ipsec dashboard, omadacId:{}, site: {}", (Object)omadacId, (Object)siteId);
            return OperationResponse.PARAM_ERROR;
        }
        List<OsgVpnIpSecVO> ipsecTunnelList = this.d.b(omadacId, siteId);
        if (CollectionUtils.isEmpty(ipsecTunnelList)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, Collections.emptyList());
        }
        Set<Integer> vpnIds = ipsecTunnelList.stream().map(OsgVpnIpSecVO::getVpnId).collect(Collectors.toSet());
        ArrayList<IpsecVpnStatsVO> res = new ArrayList<IpsecVpnStatsVO>();
        for (OsgVpnIpSecVO osgVpnIpSecVO : ipsecTunnelList) {
            IpsecVpnStatsVO dashboardTunnel = new IpsecVpnStatsVO();
            dashboardTunnel.setSite(siteId);
            dashboardTunnel.setDirection(osgVpnIpSecVO.getDirection());
            dashboardTunnel.setId(osgVpnIpSecVO.getVpnId());
            dashboardTunnel.setLocalSa(osgVpnIpSecVO.getLocalSa());
            dashboardTunnel.setRemoteSa(osgVpnIpSecVO.getRemoteSa());
            dashboardTunnel.setLocalPeerIp(osgVpnIpSecVO.getLocalPeerIp());
            dashboardTunnel.setRemotePeerIp(osgVpnIpSecVO.getRemotePeerIp());
            res.add(dashboardTunnel);
        }
        res.sort(Comparator.comparing(IpsecVpnStatsVO::getName, Comparator.nullsLast(Comparator.naturalOrder())));
        List<VpnMonitorDTO> vpns = this.a(omadacId, siteId, vpnIds);
        if (!CollectionUtils.isEmpty(vpns)) {
            Map<Integer, VpnMonitorDTO> vpnIdToEntryMap = vpns.stream().collect(Collectors.toMap(VpnMonitorDTO::getEntryId, vpnMonitorDTO -> vpnMonitorDTO));
            for (IpsecVpnStatsVO ipsecVpnStatsVO : res) {
                VpnMonitorDTO vpnMonitorDTO2 = vpnIdToEntryMap.get(ipsecVpnStatsVO.getId());
                if (vpnMonitorDTO2 == null) continue;
                ipsecVpnStatsVO.setStatus(vpnMonitorDTO2.getStatus());
                ipsecVpnStatsVO.setName(vpnMonitorDTO2.getName());
            }
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, res);
    }

    public OperationResponse b(String omadacId, String siteId, Integer type) {
        if (StringUtils.isEmpty((CharSequence)omadacId) || StringUtils.isEmpty((CharSequence)siteId) || !h.equals(type) && !i.equals(type)) {
            c.warn("Invalid param when get open vpn dashboard, omadacId: {}, site: {}, vpnType: {}", new Object[]{omadacId, siteId, type});
            return OperationResponse.PARAM_ERROR;
        }
        List<Object> vpnTunnelList = this.e.b(omadacId, siteId);
        if (CollectionUtils.isEmpty(vpnTunnelList)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, Collections.emptyList());
        }
        vpnTunnelList = vpnTunnelList.stream().filter(item -> Objects.equals(item.getServerType(), type) && j.equals(item.getVpnType())).collect(Collectors.toList());
        Set<Integer> vpnIds = vpnTunnelList.stream().map(OsgVpnTunnelVO::getVpnId).collect(Collectors.toSet());
        List<VpnMonitorDTO> vpns = this.a(omadacId, siteId, vpnIds);
        Map<Integer, VpnMonitorDTO> idToVpnDOMap = vpns.stream().collect(Collectors.toMap(VpnMonitorDTO::getEntryId, Function.identity()));
        if (i.equals(type)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, this.b(siteId, vpnTunnelList, idToVpnDOMap));
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, this.a(siteId, vpnTunnelList, idToVpnDOMap));
    }

    private List<OsgVpnTunnelVO> a(List<OsgVpnTunnelVO> vpnTunnelList, Map<String, Object> filters, String omadacId, String siteId) {
        try {
            if (filters.containsKey(a)) {
                int serverType = Integer.parseInt(filters.get(a).toString());
                vpnTunnelList = vpnTunnelList.stream().filter(item -> item.getServerType().equals(serverType)).collect(Collectors.toList());
            }
            if (filters.containsKey(b)) {
                String json = Y.b((String)filters.get(b).toString());
                VpnFiltersBO filtersBO = (VpnFiltersBO)x.a((String)json, VpnFiltersBO.class);
                vpnTunnelList = vpnTunnelList.stream().filter(item -> {
                    for (VpnBO vpnBO : filtersBO.getVpnBO()) {
                        if (!vpnBO.getType().equals(item.getVpnType()) || vpnBO.getClient() != null && !vpnBO.getClient().equals(item.getClientMode())) continue;
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
            }
        }
        catch (Exception e2) {
            c.warn("VPN Filter param error., omadacId :{}, siteId :{}", (Object)omadacId, (Object)siteId);
        }
        return vpnTunnelList;
    }

    private List<DashboardVpnStatsVO> a(String siteId, List<OsgVpnTunnelVO> vpnTunnelList, Map<Integer, VpnMonitorDTO> idToVpnDOMap) {
        Map<Integer, List<OsgVpnTunnelVO>> vpnIdToTunnelsMap = vpnTunnelList.stream().collect(Collectors.groupingBy(OsgVpnTunnelVO::getVpnId));
        Set<Integer> vpnIds = idToVpnDOMap.keySet();
        ArrayList<DashboardVpnStatsVO> vpnStatsVOList = new ArrayList<DashboardVpnStatsVO>(vpnTunnelList.size());
        for (Integer vpnId : vpnIds) {
            List<OsgVpnTunnelVO> tunnels = vpnIdToTunnelsMap.get(vpnId);
            if (CollectionUtils.isEmpty(tunnels)) continue;
            DashboardVpnStatsVO vpnStatsVO = new DashboardVpnStatsVO();
            vpnStatsVO.setSite(siteId);
            vpnStatsVO.setTunnels(Integer.valueOf(tunnels.size()));
            vpnStatsVO.setTxData(Long.valueOf(tunnels.stream().mapToLong(item -> item.getUpBytes() == null ? 0L : item.getUpBytes()).sum()));
            vpnStatsVO.setRxData(Long.valueOf(tunnels.stream().mapToLong(item -> item.getDownBytes() == null ? 0L : item.getDownBytes()).sum()));
            VpnMonitorDTO vpnDTO = idToVpnDOMap.get(vpnId);
            if (vpnDTO != null) {
                vpnStatsVO.setName(vpnDTO.getName());
                vpnStatsVO.setStatus(vpnDTO.getStatus());
            }
            vpnStatsVOList.add(vpnStatsVO);
        }
        return vpnStatsVOList;
    }

    private List<DashboardVpnStatsVO> b(String siteId, List<OsgVpnTunnelVO> vpnTunnelList, Map<Integer, VpnMonitorDTO> idToVpnDOMap) {
        if (CollectionUtils.isEmpty(vpnTunnelList)) {
            return Collections.emptyList();
        }
        ArrayList<DashboardVpnStatsVO> vpnStatsVOList = new ArrayList<DashboardVpnStatsVO>(vpnTunnelList.size());
        for (OsgVpnTunnelVO vpnTunnel : vpnTunnelList) {
            DashboardVpnStatsVO vpnStatsVO = new DashboardVpnStatsVO();
            vpnStatsVO.setSite(siteId);
            vpnStatsVO.setRxData(vpnTunnel.getDownBytes());
            vpnStatsVO.setTxData(vpnTunnel.getUpBytes());
            VpnMonitorDTO vpnDTO = idToVpnDOMap.get(vpnTunnel.getVpnId());
            if (vpnDTO != null) {
                vpnStatsVO.setName(vpnDTO.getName());
                vpnStatsVO.setStatus(vpnDTO.getStatus());
            }
            vpnStatsVOList.add(vpnStatsVO);
        }
        return vpnStatsVOList;
    }

    public List<VpnMonitorDTO> a(String omadacId, String siteId, Set<Integer> vpnIds) {
        GetVpnRequestDTO request = new GetVpnRequestDTO(omadacId, siteId, vpnIds);
        OperationResponse response = this.f.a(request);
        List vpns = Collections.emptyList();
        if (response != null && response.getResult() != null) {
            vpns = ((GetVpnResponseDTO)response.getResult()).getData();
        }
        return vpns;
    }

    private <T> void a(GridVO<T> gridVO, List<T> data) {
        int start = (gridVO.getCurrentPage() - 1) * gridVO.getCurrentSize();
        int end = Math.min(start + gridVO.getCurrentSize(), data.size());
        if (start >= 0 && start < end) {
            gridVO.setData(new ArrayList<T>(data.subList(start, end)));
        } else {
            if (start < 0 || start > end) {
                c.warn("Invalid Page Param, currentPage:{}, currentPage:{}", (Object)gridVO.getCurrentPage(), (Object)gridVO.getCurrentSize());
            }
            gridVO.setData(Collections.emptyList());
        }
    }

    private static class VpnFiltersBO {
        @JsonProperty(value="vpn")
        private List<VpnBO> vpnBO;

        private VpnFiltersBO() {
        }

        @Generated
        public List<VpnBO> getVpnBO() {
            return this.vpnBO;
        }
    }

    private static class VpnBO {
        @JsonProperty(value="type")
        private Integer type;
        @JsonProperty(value="client")
        private String client;

        private VpnBO() {
        }

        @Generated
        public Integer getType() {
            return this.type;
        }

        @Generated
        public String getClient() {
            return this.client;
        }
    }
}

