/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.application.report.e;

import com.ruiyun.jvppeteer.api.core.Browser;
import com.ruiyun.jvppeteer.api.core.Page;
import com.ruiyun.jvppeteer.cdp.core.Puppeteer;
import com.ruiyun.jvppeteer.cdp.entities.ConnectOptions;
import com.ruiyun.jvppeteer.cdp.entities.GoToOptions;
import com.ruiyun.jvppeteer.cdp.entities.LaunchOptions;
import com.ruiyun.jvppeteer.cdp.entities.PDFOptions;
import com.ruiyun.jvppeteer.cdp.entities.PaperFormats;
import com.ruiyun.jvppeteer.common.Product;
import com.ruiyun.jvppeteer.common.PuppeteerLifeCycle;
import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.h.c;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.monitor.api.web.report.v6.ReportTabVO;
import com.tplink.smb.omada.monitor.application.report.e.a;
import com.tplink.smb.omada.monitor.domain.model.b.i;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class d
extends a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(d.class);
    @Autowired
    private i b;
    @Value(value="${report.api-secret:secret}")
    private String c;
    private static final ReentrantLock d = new ReentrantLock();

    public Pair<Boolean, String> a(String omadacId, String siteId, String reportName, List<String> tabIdList, Long start, Long end, String token) {
        a.debug("pdf report start export omadacId {}, siteId {}", (Object)omadacId, (Object)siteId);
        Pair<List<String>, String> pdfResult = null;
        try {
            pdfResult = OmadacType.s() ? this.b(omadacId, siteId, tabIdList, start, end, token, reportName) : this.a(omadacId, siteId, tabIdList, start, end, token, reportName);
        }
        catch (Exception e2) {
            a.error("failed to export report pdf for omadacId {}, siteId {}, tabIdList {},e=", new Object[]{omadacId, siteId, String.join((CharSequence)",", tabIdList), e2});
        }
        if (pdfResult == null || CollectionUtil.isEmpty((Collection)((Collection)pdfResult.getKey()))) {
            return Pair.of((Object)false, null);
        }
        Pair<Boolean, String> zipResult = this.a((List)pdfResult.getKey(), (String)pdfResult.getRight(), reportName);
        if (!((Boolean)zipResult.getKey()).booleanValue()) {
            a.error("failed to export report pdf for omadacId {}, siteId {}, tabIdList {}", new Object[]{omadacId, siteId, String.join((CharSequence)",", tabIdList)});
        }
        return zipResult;
    }

    public Pair<List<String>, String> a(String omadacId, String siteId, List<String> tabIdList, Long start, Long end, String token, String reportName) throws c {
        long startTime = System.currentTimeMillis();
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("--no-sandbox");
        argList.add("--disable-setuid-sandbox");
        argList.add("--ignore-certificate-errors");
        argList.add("--ignore-urlfetcher-cert-requests");
        argList.add("--allow-insecure-localhost");
        LaunchOptions options = LaunchOptions.builder().args(argList).headless(true).product(Product.Chrome).build();
        options.setExecutablePath(this.a(com.tplink.smb.omada.monitor.report.d.b.a.g));
        Browser browser = null;
        ArrayList<String> listFilePath = new ArrayList<String>();
        String dir = null;
        try {
            dir = this.a(com.tplink.smb.omada.monitor.report.d.b.a.g, omadacId, siteId);
        }
        catch (Exception e2) {
            a.error("create report directory failed for omadacId {}, siteId {},e=", new Object[]{omadacId, siteId, e2});
            throw new c("create report directory failed");
        }
        if (StringUtils.isBlank((CharSequence)dir)) {
            a.error("get report export directory failed for omadacId {}, siteId {}", (Object)omadacId, (Object)siteId);
            throw new c("get report export directory failed");
        }
        try {
            browser = Puppeteer.launch((LaunchOptions)options);
            a.debug("report export start to launch browser time {} for omadacId {}, siteId {}", new Object[]{System.currentTimeMillis(), omadacId, siteId});
            for (String tabId : tabIdList) {
                String url = this.a(omadacId, siteId, tabId, start, end, token);
                Object fileName = "";
                OperationResponse<ReportTabVO> reportTabVOResp = this.b.a(omadacId, siteId, tabId);
                if (reportTabVOResp.success()) {
                    if (reportTabVOResp.getResult() == null || StringUtils.isBlank((CharSequence)((ReportTabVO)reportTabVOResp.getResult()).getName())) continue;
                } else {
                    a.warn("failed to get tab info for omadacId {}, siteId {} , tabId {} ,msg {}", new Object[]{omadacId, siteId, tabId, reportTabVOResp.getMsg()});
                    continue;
                }
                fileName = reportName + "_" + ((ReportTabVO)reportTabVOResp.getResult()).getName();
                String filePath = this.a(dir, (String)fileName);
                Page page = browser.newPage();
                this.a(omadacId, siteId, url, filePath, page);
                listFilePath.add(filePath);
            }
        }
        catch (Exception e3) {
            try {
                a.warn("failed to export report pdf for omadacId {}, siteId {} with exception {}", new Object[]{omadacId, siteId, e3.getMessage(), e3});
                throw new c((Throwable)e3);
            }
            catch (Throwable throwable) {
                a.debug("report export finish to pdf {} for omadacId {}, siteId {}", new Object[]{System.currentTimeMillis(), omadacId, siteId});
                if (browser != null) {
                    try {
                        browser.close();
                    }
                    catch (Exception e4) {
                        a.warn("failed to close browser for omadacId {}, siteId {} with exception {}", new Object[]{omadacId, siteId, e4.getMessage(), e4});
                    }
                }
                throw throwable;
            }
        }
        a.debug("report export finish to pdf {} for omadacId {}, siteId {}", new Object[]{System.currentTimeMillis(), omadacId, siteId});
        if (browser != null) {
            try {
                browser.close();
            }
            catch (Exception e5) {
                a.warn("failed to close browser for omadacId {}, siteId {} with exception {}", new Object[]{omadacId, siteId, e5.getMessage(), e5});
            }
        }
        long endTime = System.currentTimeMillis();
        a.debug("pdfGeneration finished time:{} ,cost {} s", (Object)System.currentTimeMillis(), (Object)((endTime - startTime) / 1000L));
        return Pair.of(listFilePath, (Object)dir);
    }

    public Pair<List<String>, String> b(String omadacId, String siteId, List<String> tabIdList, Long start, Long end, String token, String reportName) {
        ConnectOptions options = new ConnectOptions();
        options.setBrowserURL("http://localhost:9801");
        Browser browser = null;
        ArrayList<String> listFilePath = new ArrayList<String>();
        String dir = null;
        try {
            a.debug("Puppeteer start to connect , omadacId {}, siteId {}", (Object)omadacId, (Object)siteId);
            browser = Puppeteer.connect((ConnectOptions)options);
            a.debug("Puppeteer finished to connect browser time {} ms for omadacId {}, siteId {}", new Object[]{System.currentTimeMillis(), omadacId, siteId});
            try {
                dir = this.a(com.tplink.smb.omada.monitor.report.d.b.a.g, omadacId, siteId);
            }
            catch (Exception e2) {
                a.error("create report directory failed for omadacId {}, siteId {},e=", new Object[]{omadacId, siteId, e2});
                throw new c("create report directory failed");
            }
            if (StringUtils.isBlank((CharSequence)dir)) {
                a.error("get report export directory failed for omadacId {}, siteId {}", (Object)omadacId, (Object)siteId);
                throw new c("get report export directory failed");
            }
            for (String tabId : tabIdList) {
                String url = this.a(omadacId, siteId, tabId, start, end, token);
                a.debug("pdf url {} , omadacId {}, siteId {}", new Object[]{url, omadacId, siteId});
                Object fileName = "";
                OperationResponse<ReportTabVO> reportTabVOResp = this.b.a(omadacId, siteId, tabId);
                if (reportTabVOResp.success()) {
                    if (reportTabVOResp.getResult() == null || StringUtils.isBlank((CharSequence)((ReportTabVO)reportTabVOResp.getResult()).getName())) continue;
                    fileName = reportName + "_" + ((ReportTabVO)reportTabVOResp.getResult()).getName();
                } else {
                    a.warn("failed to get tab info, msg {}", (Object)reportTabVOResp.getMsg());
                }
                String filePath = this.a(dir, (String)fileName);
                Page page = browser.newPage();
                page.setExtraHTTPHeaders(Map.of("serviceSecret", this.c));
                this.a(omadacId, siteId, url, filePath, page);
                listFilePath.add(filePath);
            }
        }
        catch (Exception e3) {
            a.error("failed to export report pdf for omadacId {}, siteId {}, tabIdList {} with exception {} ,e=", new Object[]{omadacId, siteId, String.join((CharSequence)",", tabIdList), e3.getMessage(), e3});
            throw new c((Throwable)e3);
        }
        finally {
            if (browser != null) {
                browser.disconnect();
                a.debug("Puppeteer disconnect , omadacId {}, siteId {}", (Object)omadacId, (Object)siteId);
            }
        }
        return Pair.of(listFilePath, (Object)dir);
    }

    private String a(String dir, String fileName) {
        if (T.c((String)dir) || T.c((String)fileName)) {
            return null;
        }
        fileName = (String)fileName + ".pdf";
        Path filePath = Paths.get(dir, new String[]{fileName});
        return filePath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(String omadacId, String siteId, String url, String filePath, Page page) {
        page.setDefaultTimeout(60000);
        GoToOptions navigateOptions = new GoToOptions();
        navigateOptions.setWaitUntil(List.of(PuppeteerLifeCycle.networkIdle));
        navigateOptions.setTimeout(Integer.valueOf(60000));
        long startTime = System.currentTimeMillis();
        page.goTo(url, navigateOptions);
        page.waitForSelector("#main-container.finished");
        PDFOptions pdfOptions = new PDFOptions();
        pdfOptions.setFormat(PaperFormats.a4);
        pdfOptions.setPath(filePath);
        a.debug("page goTo finished time:{} ,cost {} s", (Object)System.currentTimeMillis(), (Object)((System.currentTimeMillis() - startTime) / 1000L));
        page.pdf(pdfOptions);
        a.debug("page pdf finished time:{} ,cost {} s", (Object)System.currentTimeMillis(), (Object)((System.currentTimeMillis() - startTime) / 1000L));
        if (page == null) return;
        try {
            page.close();
            a.debug("page is close for omadacId {}, siteId {}", (Object)omadacId, (Object)siteId);
            return;
        }
        catch (Exception e2) {
            a.warn("failed to close page for omadacId {}, siteId {} with exception {} , e=", new Object[]{omadacId, siteId, e2.getMessage(), e2});
        }
        return;
        catch (Exception e3) {
            try {
                a.error("page to pdf for omadacId {}, siteId {} with exception {}, e=", new Object[]{omadacId, siteId, e3.getMessage(), e3});
                if (page == null) return;
            }
            catch (Throwable throwable) {
                if (page == null) throw throwable;
                try {
                    page.close();
                    a.debug("page is close for omadacId {}, siteId {}", (Object)omadacId, (Object)siteId);
                    throw throwable;
                }
                catch (Exception e4) {
                    a.warn("failed to close page for omadacId {}, siteId {} with exception {} , e=", new Object[]{omadacId, siteId, e4.getMessage(), e4});
                }
                throw throwable;
            }
            try {
                page.close();
                a.debug("page is close for omadacId {}, siteId {}", (Object)omadacId, (Object)siteId);
                return;
            }
            catch (Exception e5) {
                a.warn("failed to close page for omadacId {}, siteId {} with exception {} , e=", new Object[]{omadacId, siteId, e5.getMessage(), e5});
            }
            return;
        }
    }
}

