/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.application.report.c;

import com.sun.management.OperatingSystemMXBean;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.DstInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.dto.GeneralSettingDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.SiteDTO;
import com.tplink.smb.omada.monitor.api.internal.enventcenter.a;
import com.tplink.smb.omada.monitor.application.report.NetworkReportDataDTO;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class b {
    @Generated
    private static final Logger c = LoggerFactory.getLogger(b.class);
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.a d;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.a e;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.omadac.b f;
    @Qualifier(value="monitorReportGenerationWorkGroup")
    @Autowired
    private ExecutorService g;
    protected String a;
    protected DstInfoDTO b;
    private static final String h = "Failed";
    private static final String i = "error=2";
    private static final String j = "Unknown";
    private static final String k = "chromium uninstalled";
    private static final String l = "/home/ubuntu/server/html";
    private static final String m = "/home/ubuntu/server/pdf";
    private static final long n = 0x4CCCCCCCL;
    private OperatingSystemMXBean o = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();

    private String a(String omadacId) {
        String omadacName = "";
        OperationResponse omadacSettingOpt = this.f.a(omadacId);
        if (!omadacSettingOpt.success() || Objects.isNull(omadacSettingOpt.getResult())) {
            return omadacName;
        }
        omadacName = ((GeneralSettingDTO)omadacSettingOpt.getResult()).getOmadacName();
        if (Objects.isNull(omadacName)) {
            return "";
        }
        return omadacName;
    }

    private DstInfoDTO a(String omadacId, String siteId) {
        QuerySiteDTO querySiteDTO = new QuerySiteDTO(omadacId, siteId);
        OperationResponse dstInfoOpt = this.d.a(querySiteDTO);
        if (Objects.isNull(dstInfoOpt)) {
            return null;
        }
        return (DstInfoDTO)dstInfoOpt.getResult();
    }

    private a b(String omadacId, String siteId) {
        QuerySiteDTO querySiteDTO = new QuerySiteDTO(omadacId, siteId);
        Optional siteDTOOptional = this.e.a(querySiteDTO);
        if (!siteDTOOptional.isPresent()) {
            return null;
        }
        SiteDTO siteDTO = (SiteDTO)siteDTOOptional.get();
        String siteName = siteDTO.getSiteName();
        String timezone = siteDTO.getTimezone();
        return new a(siteName, timezone);
    }

    protected OperationResponse a(NetworkReportDataDTO networkReportDataDTO, a.b tab, int imageCount) {
        Object htmlName = "";
        try {
            htmlName = UUID.randomUUID() + ".html";
            com.tplink.smb.omada.monitor.application.report.d.b.a(networkReportDataDTO, (String)htmlName, tab);
        }
        catch (Exception ex) {
            c.info("ex: {}", (Throwable)ex);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cN);
        }
        Path htmlPath = Paths.get(l, new String[]{htmlName});
        Path pdfPath = Paths.get(m, ((String)htmlName).replace(".html", ".pdf"));
        String command = "topdf_cbc " + htmlPath + " " + imageCount;
        OperationResponse pdfGenResult = OperationResponse.GENERAL_ERROR;
        try {
            Future<OperationResponse> result = this.g.submit(() -> this.a(command, networkReportDataDTO.getOmadacId(), networkReportDataDTO.getSiteId()));
            pdfGenResult = result.get();
        }
        catch (InterruptedException e2) {
            c.warn("interrupted exception caught when generating pdfs: {}, stats: {}, tab: {}", new Object[]{e2, networkReportDataDTO.getStats(), tab});
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e3) {
            c.warn("generate report execution exception: {}, stats: {}, tab:{}", new Object[]{e3, networkReportDataDTO.getStats(), tab});
        }
        try {
            Files.deleteIfExists(htmlPath);
        }
        catch (IOException e4) {
            c.warn("ioexception occurred when deleting a html file: {}, stats:{}, tab: {}", new Object[]{e4, networkReportDataDTO.getStats(), tab});
        }
        if (!pdfGenResult.success()) {
            return pdfGenResult;
        }
        return OperationResponse.success((Object)pdfPath);
    }

    public String a(List<String> csvContentList, String tabName, Map<String, String> basicData, Locale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabName + "\n\n");
        sb.append(com.tplink.smb.omada.monitor.common.d.a.a((String)"CONTROLLER", (Locale)locale) + ": " + basicData.getOrDefault("omadac", j) + "\n");
        sb.append(com.tplink.smb.omada.monitor.common.d.a.a((String)"SITE", (Locale)locale) + ": " + basicData.getOrDefault("site", j) + "\n");
        String timeStr = basicData.getOrDefault("start", j) + " ~ " + basicData.getOrDefault("end", j);
        sb.append(com.tplink.smb.omada.monitor.common.d.a.a((String)"CONTROLLER", (Locale)locale) + ": " + timeStr + "\n\n");
        for (String csvContent : csvContentList) {
            sb.append(csvContent);
            sb.append("\n");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public OperationResponse b(NetworkReportDataDTO networkReportDataDTO, a.b tab, int imageCount) {
        String command;
        if (OmadacType.s()) {
            return this.a(networkReportDataDTO, tab, imageCount);
        }
        Object htmlName = "";
        try {
            htmlName = UUID.randomUUID() + ".html";
            com.tplink.smb.omada.monitor.application.report.d.b.b(networkReportDataDTO, (String)htmlName, tab);
        }
        catch (Exception ex) {
            c.info("ex: {}", (Throwable)ex);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cN);
        }
        String binHome = System.getProperty("eap.home.bin");
        String omadaHome = System.getProperty("eap.home", ".");
        Path htmlPath = Paths.get(omadaHome, new String[]{"data", "html", htmlName});
        Path pdfPath = Paths.get(omadaHome, "data", "pdf", ((String)htmlName).replace(".html", ".pdf"));
        if (OmadacType.o()) {
            command = "\"" + Paths.get(binHome, "topdf.exe") + "\" \"" + htmlPath + "\" " + imageCount;
        } else if (OmadacType.n()) {
            command = Paths.get(binHome, "topdf") + " " + htmlPath + " " + imageCount;
        } else {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.bs);
        }
        OperationResponse pdfGenResult = new OperationResponse(com.tplink.smb.omada.common.g.b.cN);
        try {
            Future<OperationResponse> result = this.g.submit(() -> this.c(command, omadaHome));
            pdfGenResult = result.get();
        }
        catch (InterruptedException e2) {
            c.warn("interrupted exception caught when generating pdfs: {}, stats: {}, tab: {}", new Object[]{e2, networkReportDataDTO.getStats(), tab});
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e3) {
            c.warn("generate report execution exception: {}, stats: {}, tab:{}", new Object[]{e3, networkReportDataDTO.getStats(), tab});
        }
        try {
            Files.deleteIfExists(htmlPath);
        }
        catch (IOException e4) {
            c.warn("ioexception occurred when deleting a html file: {}, stats:{}, tab: {}", new Object[]{e4, networkReportDataDTO.getStats(), tab});
        }
        if (!pdfGenResult.success()) {
            return pdfGenResult;
        }
        return OperationResponse.success((Object)pdfPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized OperationResponse a(String command, String omadacId, String siteId) {
        Process process = null;
        boolean pdfGenResult = false;
        try {
            long pdfGenStart = System.currentTimeMillis();
            process = Runtime.getRuntime().exec(command);
            pdfGenResult = process.waitFor(10L, TimeUnit.SECONDS);
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            StringBuilder stdErrorSb = new StringBuilder();
            long startReadingTime = System.currentTimeMillis();
            while (stdError.ready() && System.currentTimeMillis() - startReadingTime < 1000L) {
                stdErrorSb.append(stdError.readLine());
            }
            String errorMessage = stdErrorSb.toString();
            if (!T.c((String)errorMessage)) {
                c.error("execute pdf error:{}, omadacId: {}, siteId: {}", new Object[]{errorMessage, omadacId, siteId});
            }
            c.debug("pdf gen result: {}, time: {}", (Object)pdfGenResult, (Object)(System.currentTimeMillis() - pdfGenStart));
        }
        catch (Exception ex) {
            String exMessage = ex.getMessage();
            c.warn("execute pdf error: {}, omadacId: {}, siteId: {}", new Object[]{exMessage, omadacId, siteId});
        }
        finally {
            if (Objects.nonNull(process)) {
                process.destroy();
            }
        }
        if (pdfGenResult) {
            return OperationResponse.SUCCESS;
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.cN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized OperationResponse c(String command, String omadaHome) {
        Process process = null;
        boolean pdfGenResult = false;
        long freeMem = 0L;
        try {
            long pdfGenStart = System.currentTimeMillis();
            freeMem = this.o.getFreePhysicalMemorySize();
            process = Runtime.getRuntime().exec(command, null, new File(omadaHome));
            pdfGenResult = process.waitFor(10L, TimeUnit.SECONDS);
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            StringBuilder stdErrorSb = new StringBuilder();
            long startReadingTime = System.currentTimeMillis();
            while (stdError.ready() && System.currentTimeMillis() - startReadingTime < 1000L) {
                stdErrorSb.append(stdError.readLine());
            }
            String errorMessage = stdErrorSb.toString();
            if (errorMessage.contains(k)) {
                OperationResponse operationResponse = new OperationResponse(com.tplink.smb.omada.common.g.b.cQ);
                return operationResponse;
            }
            if (errorMessage.contains(h)) {
                if (OmadacType.n()) {
                    OperationResponse operationResponse = new OperationResponse(com.tplink.smb.omada.common.g.b.ec);
                    return operationResponse;
                }
                OperationResponse operationResponse = new OperationResponse(com.tplink.smb.omada.common.g.b.cP);
                return operationResponse;
            }
            c.debug("pdf gen result: {}, time: {}", (Object)pdfGenResult, (Object)(System.currentTimeMillis() - pdfGenStart));
        }
        catch (Exception ex) {
            String exMessage = ex.getMessage();
            if (exMessage.contains(i)) {
                OperationResponse operationResponse = new OperationResponse(com.tplink.smb.omada.common.g.b.cP);
                return operationResponse;
            }
            c.warn("execute pdf error: {}", (Object)exMessage);
        }
        finally {
            if (Objects.nonNull(process)) {
                process.destroy();
            }
        }
        if (pdfGenResult) {
            return OperationResponse.SUCCESS;
        }
        if (freeMem < 0x4CCCCCCCL) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cO);
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.cN);
    }

    public Map<String, String> a(String omadacId, String siteId, long start, long end) {
        String omadacName = this.a(omadacId);
        String timeZone = "UTC";
        String siteName = "";
        a siteConfigs = this.b(omadacId, siteId);
        if (Objects.nonNull(siteConfigs)) {
            siteName = siteConfigs.a();
            timeZone = siteConfigs.b();
        }
        this.b = this.a(omadacId, siteId);
        this.a = timeZone;
        HashMap<String, String> stats = new HashMap<String, String>(16);
        stats.put("start", com.tplink.smb.omada.monitor.application.report.d.b.b(this.b, timeZone, start));
        stats.put("end", com.tplink.smb.omada.monitor.application.report.d.b.b(this.b, timeZone, end));
        stats.put("year", com.tplink.smb.omada.monitor.application.report.d.b.a(this.b, timeZone, System.currentTimeMillis()));
        stats.put("omadac", omadacName);
        stats.put("site", siteName);
        stats.put("omadacId", omadacId);
        stats.put("siteId", siteId);
        return stats;
    }

    private class a {
        private String b;
        private String c;

        @Generated
        public a(String siteName, String timezone) {
            this.b = siteName;
            this.c = timezone;
        }

        @Generated
        public String a() {
            return this.b;
        }

        @Generated
        public String b() {
            return this.c;
        }
    }
}

