/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.resolver.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.tplink.smb.omada.dispatcher.resolver.impl.MacFormatEnum;
import com.tplink.smb.omada.dispatcher.resolver.impl.MacFormatterAware;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacRecursiveSerializer
extends JsonSerializer<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MacRecursiveSerializer.class);
    private final boolean formatKey;
    private final boolean formatValue;
    private final int maxDepth;
    public static final Pattern OMADA_MAC_PATTERN = Pattern.compile("^([0-9A-F]{2}(-[0-9A-F]{2}){5})$");

    public MacRecursiveSerializer(boolean formatKey, boolean formatValue, int maxDepth) {
        this.formatKey = formatKey;
        this.formatValue = formatValue;
        this.maxDepth = maxDepth;
    }

    public static boolean isOmadaMacAddress(String value) {
        return OMADA_MAC_PATTERN.matcher(value).matches();
    }

    private static String formatMac(String value, int macFormat) {
        switch (MacFormatEnum.resolve(macFormat)) {
            case LOWER_COLON: {
                return value.replaceAll("-", ":").toLowerCase(Locale.ROOT);
            }
            case UPPER_COLON: {
                return value.replaceAll("-", ":").toUpperCase(Locale.ROOT);
            }
            case LOWER_HYPHEN: {
                return value.toLowerCase(Locale.ROOT);
            }
            case UPPER_CASE: {
                return value.replaceAll("-", "").toUpperCase(Locale.ROOT);
            }
            case LOWER_CASE: {
                return value.replaceAll("-", "").toLowerCase(Locale.ROOT);
            }
        }
        return value;
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        Object macFormat = serializers.getAttribute((Object)"CLOUD_ACCESS_ATTRIBUTE");
        this.writeRecursively(value, gen, 0, macFormat);
    }

    public String serializeString(JsonGenerator gen, String value, Object macFormatFromSerializer) throws IOException {
        if (MacRecursiveSerializer.isOmadaMacAddress(value)) {
            Optional<Integer> macFormatOpt = MacFormatterAware.getMacFormat();
            if (log.isTraceEnabled()) {
                log.trace("x-mac-format header value: {}", macFormatOpt.isPresent() ? macFormatOpt.get() : "null");
            }
            return macFormatOpt.isPresent() ? MacRecursiveSerializer.formatMac(value, macFormatOpt.get()) : value;
        }
        return value;
    }

    private void writeRecursively(Object value, JsonGenerator gen, int depth, Object macFormat) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        if (this.maxDepth >= 0 && depth > this.maxDepth) {
            gen.writeObject(value);
            return;
        }
        if (value instanceof String) {
            String str = (String)value;
            gen.writeString(this.serializeString(gen, str, macFormat));
            return;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            gen.writeStartArray();
            for (Object elem : collection) {
                this.writeRecursively(elem, gen, depth + 1, macFormat);
            }
            gen.writeEndArray();
            return;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            gen.writeStartObject();
            for (Map.Entry entry : map.entrySet()) {
                String keyStr = String.valueOf(entry.getKey());
                if (this.formatKey) {
                    keyStr = this.serializeString(gen, keyStr, macFormat);
                }
                gen.writeFieldName(keyStr);
                Object val = entry.getValue();
                if (this.formatValue) {
                    this.writeRecursively(val, gen, depth + 1, macFormat);
                    continue;
                }
                gen.writeObject(val);
            }
            gen.writeEndObject();
            return;
        }
        gen.writeObject(value);
    }
}

