/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.resolver.impl;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;

public class MacFormatterAware {
    private static final ThreadLocal<Supplier<Integer>> SUPPLIER = new ThreadLocal();
    private static final ThreadLocal<Integer> ITEM = new ThreadLocal();

    public static <T> T wrap(Supplier<Integer> supplier, ExSupplier<T> internal) throws IOException {
        SUPPLIER.set(() -> {
            Integer item = ITEM.get();
            if (item == null) {
                Integer res = (Integer)supplier.get();
                ITEM.set(res);
                return res;
            }
            return item;
        });
        try {
            T t2 = internal.get();
            return t2;
        }
        finally {
            MacFormatterAware.clean();
        }
    }

    public static void wrap(Supplier<Integer> supplier, ExRunnable internal) throws IOException {
        SUPPLIER.set(() -> {
            Integer item = ITEM.get();
            if (item == null) {
                Integer res = (Integer)supplier.get();
                ITEM.set(res);
                return res;
            }
            return item;
        });
        try {
            internal.run();
        }
        finally {
            MacFormatterAware.clean();
        }
    }

    public static Optional<Integer> getMacFormat() {
        return Optional.ofNullable(SUPPLIER.get()).map(Supplier::get);
    }

    public static void clean() {
        ITEM.remove();
        SUPPLIER.remove();
    }

    public static interface ExSupplier<T> {
        public T get() throws IOException;
    }

    public static interface ExRunnable {
        public void run() throws IOException;
    }
}

