/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.resolver.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum MacFormatEnum {
    UPPER_HYPHEN(1),
    LOWER_HYPHEN(2),
    UPPER_COLON(3),
    LOWER_COLON(4),
    UPPER_CASE(5),
    LOWER_CASE(6);

    public int macFormatCode;
    private static final Map<Integer, MacFormatEnum> CODE_MAP;
    public static final String HYPHEN_SEPARATOR = "-";
    public static final String COLON_SEPARATOR = ":";
    public static final String UPPER_HYPHEN_REGEX = "^([0-9A-F]{2}[-]){5}([0-9A-F]{2})$";

    private MacFormatEnum(int macFormatCode) {
        this.macFormatCode = macFormatCode;
    }

    public int getMacFormatCode() {
        return this.macFormatCode;
    }

    public static Integer getDefaultMacFormatCode() {
        return UPPER_HYPHEN.getMacFormatCode();
    }

    public static MacFormatEnum resolve(int code) {
        for (MacFormatEnum value : MacFormatEnum.values()) {
            if (value.macFormatCode != code) continue;
            return value;
        }
        return null;
    }

    public static String formatMac(String value, Integer macFormat) {
        if (macFormat == null || !value.matches(UPPER_HYPHEN_REGEX)) {
            return value;
        }
        MacFormatEnum formatEnum = MacFormatEnum.resolve(macFormat);
        if (formatEnum == null) {
            return value;
        }
        switch (formatEnum) {
            case LOWER_COLON: {
                return value.replaceAll(HYPHEN_SEPARATOR, COLON_SEPARATOR).toLowerCase(Locale.ROOT);
            }
            case UPPER_COLON: {
                return value.replaceAll(HYPHEN_SEPARATOR, COLON_SEPARATOR).toUpperCase(Locale.ROOT);
            }
            case LOWER_HYPHEN: {
                return value.toLowerCase(Locale.ROOT);
            }
            case UPPER_CASE: {
                return value.replaceAll(HYPHEN_SEPARATOR, "").toUpperCase(Locale.ROOT);
            }
            case LOWER_CASE: {
                return value.replaceAll(HYPHEN_SEPARATOR, "").toLowerCase(Locale.ROOT);
            }
        }
        return value;
    }

    static {
        CODE_MAP = new HashMap<Integer, MacFormatEnum>(16);
        for (MacFormatEnum macFormat : MacFormatEnum.values()) {
            CODE_MAP.put(macFormat.getMacFormatCode(), macFormat);
        }
    }
}

