/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.resolver.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.tplink.smb.omada.a.a;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MacAddressDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer {
    private final boolean formatKey;
    private final boolean formatValue;
    private final int maxDepth;
    private final boolean formatValueWithPatternKey;
    private final JavaType type;

    public MacAddressDeserializer() {
        this(false, false, 1, false, null);
    }

    public MacAddressDeserializer(boolean formatKey, boolean formatValue, int maxDepth, boolean formatValueWithPatternKey, JavaType type) {
        this.formatKey = formatKey;
        this.formatValue = formatValue;
        this.maxDepth = maxDepth;
        this.formatValueWithPatternKey = formatValueWithPatternKey;
        this.type = type;
    }

    public Object deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        return this.processNode(p2, ctxt, 0, this.type);
    }

    private Object processNode(JsonParser p2, DeserializationContext ctxt, int currentDepth, JavaType currentType) throws IOException {
        JsonToken token = p2.currentToken();
        if (this.maxDepth >= 0 && currentDepth > this.maxDepth) {
            if (token == JsonToken.VALUE_NULL) {
                return null;
            }
            return ctxt.readValue(p2, currentType);
        }
        if (token == JsonToken.START_OBJECT) {
            return this.processMap(p2, ctxt, currentDepth + 1, currentType);
        }
        if (token == JsonToken.START_ARRAY) {
            return this.processCollection(p2, ctxt, currentDepth + 1, currentType);
        }
        if (token == JsonToken.VALUE_STRING) {
            return this.processString(p2.getValueAsString());
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        return ctxt.readValue(p2, currentType);
    }

    private Map<Object, Object> processMap(JsonParser p2, DeserializationContext ctxt, int currentDepth, JavaType mapType) throws IOException {
        Class rawClass = mapType.getRawClass();
        Map<Object, Object> map = this.createMapInstance(rawClass);
        while (p2.nextToken() != JsonToken.END_OBJECT) {
            Object keyObj;
            String key = p2.getCurrentName();
            JavaType keyType = mapType.getKeyType();
            boolean shouldFormatValue = this.formatValue;
            if (String.class.isAssignableFrom(keyType.getRawClass())) {
                Object object = keyObj = this.formatKey && MacAddressDeserializer.isMac(key) ? MacAddressDeserializer.formatMac(key) : key;
                if (this.formatValueWithPatternKey) {
                    shouldFormatValue = com.tplink.smb.omada.a.a.a.a.matcher(key).matches();
                }
            } else {
                JsonParser keyParser = new JsonFactory().createParser(key);
                keyParser.nextToken();
                keyObj = ctxt.readValue(keyParser, keyType);
            }
            p2.nextToken();
            JavaType valueType = mapType.getContentType();
            Object value = this.processMapValueNode(p2, ctxt, currentDepth, valueType, shouldFormatValue);
            map.put(keyObj, value);
        }
        return map;
    }

    private Object processMapValueNode(JsonParser p2, DeserializationContext ctxt, int currentDepth, JavaType currentType, boolean shouldFormatValue) throws IOException {
        return shouldFormatValue ? this.processNode(p2, ctxt, currentDepth, currentType) : ctxt.readValue(p2, currentType);
    }

    private Object processCollection(JsonParser p2, DeserializationContext ctxt, int currentDepth, JavaType containerType) throws IOException {
        Class rawClass = containerType.getRawClass();
        if (containerType.isArrayType()) {
            ArrayList<Object> list = new ArrayList<Object>();
            while (p2.nextToken() != JsonToken.END_ARRAY) {
                list.add(this.processNode(p2, ctxt, currentDepth, containerType.getContentType()));
            }
            Object array = Array.newInstance(containerType.getContentType().getRawClass(), list.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Array.set(array, i2, list.get(i2));
            }
            return array;
        }
        Collection<Object> collection = this.createCollectionInstance(rawClass);
        while (p2.nextToken() != JsonToken.END_ARRAY) {
            collection.add(this.processNode(p2, ctxt, currentDepth, containerType.getContentType()));
        }
        return collection;
    }

    private String processString(String value) {
        return value != null && this.formatValue && MacAddressDeserializer.isMac(value) ? MacAddressDeserializer.formatMac(value) : value;
    }

    public static boolean isMac(String s2) {
        return s2.matches("^([0-9A-F]{2}(:[0-9A-F]{2}){5})|([0-9a-f]{2}(:[0-9a-f]{2}){5})|([0-9a-f]{2}(-[0-9a-f]{2}){5})|([0-9a-f]{2}([0-9a-f]{2}){5})|([0-9A-F]{2}([0-9A-F]{2}){5})$");
    }

    public static String formatMac(String value) {
        return value.replaceAll("[^0-9A-Fa-f]", "").toUpperCase().replaceAll("(.{2})", "$1-").replaceAll("-$", "");
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        a ann;
        if (property != null && (ann = (a)property.getAnnotation(a.class)) != null && ann.a()) {
            return new MacAddressDeserializer(ann.b(), ann.c(), ann.d(), ann.e(), property.getType());
        }
        return this;
    }

    private Map<Object, Object> createMapInstance(Class<?> rawClass) {
        if (Map.class.equals(rawClass)) {
            return new HashMap<Object, Object>();
        }
        if (SortedMap.class.equals(rawClass)) {
            return new TreeMap<Object, Object>();
        }
        if (ConcurrentMap.class.equals(rawClass)) {
            return new ConcurrentHashMap<Object, Object>();
        }
        try {
            return (Map)rawClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            return new HashMap<Object, Object>();
        }
    }

    private Collection<Object> createCollectionInstance(Class<?> rawClass) {
        if (Set.class.equals(rawClass)) {
            return new HashSet<Object>();
        }
        if (List.class.equals(rawClass)) {
            return new ArrayList<Object>();
        }
        if (Collection.class.equals(rawClass)) {
            return new ArrayList<Object>();
        }
        if (Queue.class.equals(rawClass)) {
            return new LinkedList<Object>();
        }
        if (SortedSet.class.equals(rawClass)) {
            return new TreeSet<Object>();
        }
        try {
            return (Collection)rawClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            return new ArrayList<Object>();
        }
    }
}

