/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.common.util;

import com.googlecode.ipv6.IPv6Address;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.f.c;
import com.tplink.smb.omada.common.util.w;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class v {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(v.class);

    private v() {
    }

    public static String a(byte[] bytes) {
        if (bytes == null || bytes.length != 4) {
            throw new IllegalArgumentException("Illegal IPv4 bytes: " + Arrays.toString(bytes));
        }
        try {
            InetAddress address = InetAddress.getByAddress(bytes);
            return address.getHostAddress();
        }
        catch (UnknownHostException e2) {
            throw new IllegalArgumentException("Illegal IPv4 bytes: " + Arrays.toString(bytes));
        }
    }

    public static String b(byte[] bytes) {
        if (bytes == null || bytes.length != 16) {
            throw new IllegalArgumentException("Illegal IPv6 bytes: " + Arrays.toString(bytes));
        }
        IPv6Address address = IPv6Address.fromByteArray((byte[])bytes);
        return address.toString();
    }

    public static IPv6Address c(byte[] bytes) {
        if (bytes == null || bytes.length != 16) {
            throw new IllegalArgumentException("Illegal IPv6 bytes: " + Arrays.toString(bytes));
        }
        return IPv6Address.fromByteArray((byte[])bytes);
    }

    public static boolean a(String srcIp) {
        return Objects.equals("127.0.0.1", srcIp) || !v.j(srcIp) && w.a("::1", srcIp);
    }

    public static boolean a(List<String> urls) {
        for (String url : urls) {
            try {
                URL parsedUrl = new URL(url);
                String host = parsedUrl.getHost();
                if (host != null && host.startsWith("[") && host.endsWith("]")) {
                    host = host.substring(1, host.length() - 1);
                }
                if (!"localhost".equalsIgnoreCase(host) && !v.a(host)) continue;
                return true;
            }
            catch (MalformedURLException e2) {
                a.warn("containsLocalhost failed to get webhook setting, url:{}", (Object)url);
            }
        }
        return false;
    }

    public static long b(String strIp) {
        try {
            long[] ip = new long[4];
            int position1 = strIp.indexOf(46);
            int position2 = strIp.indexOf(46, position1 + 1);
            int position3 = strIp.indexOf(46, position2 + 1);
            ip[0] = Long.parseLong(strIp.substring(0, position1));
            ip[1] = Long.parseLong(strIp.substring(position1 + 1, position2));
            ip[2] = Long.parseLong(strIp.substring(position2 + 1, position3));
            ip[3] = Long.parseLong(strIp.substring(position3 + 1));
            return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
        }
        catch (Exception ex) {
            a.warn(ex.toString(), (Throwable)ex);
            return 0L;
        }
    }

    public static String a(long longIp) {
        StringBuilder sb = new StringBuilder("");
        sb.append(longIp >>> 24);
        sb.append(".");
        sb.append((longIp & 0xFFFFFFL) >>> 16);
        sb.append(".");
        sb.append((longIp & 0xFFFFL) >>> 8);
        sb.append(".");
        sb.append(longIp & 0xFFL);
        return sb.toString();
    }

    public static String a(int intIp) {
        return (intIp >>> 24) + "." + ((intIp & 0xFFFFFF) >>> 16) + "." + ((intIp & 0xFFFF) >>> 8) + "." + (intIp & 0xFF);
    }

    public static boolean c(String ipStr) {
        return T.a(ipStr) || ipStr.equals("0.0.0.0");
    }

    public static String a(String remoteIp, List<InterfaceAddress> localInterfaceAddresses) {
        if (CollectionUtils.isEmpty(localInterfaceAddresses)) {
            a.warn("network interfaces is null or empty");
            return null;
        }
        for (InterfaceAddress interfaceAddress : localInterfaceAddresses) {
            String localSubnetMask = v.b(interfaceAddress.getNetworkPrefixLength());
            String localIp = interfaceAddress.getAddress().getHostAddress();
            if (!v.a(remoteIp, localIp, localSubnetMask)) continue;
            return localIp;
        }
        return null;
    }

    public static String b(int networkPrefixLength) {
        StringBuilder s2 = new StringBuilder();
        for (int i2 = 0; i2 < 4; ++i2) {
            if (i2 > 0) {
                s2.append(".");
            }
            StringBuilder sb = new StringBuilder();
            for (int j2 = i2 * 8; j2 < (i2 + 1) * 8; ++j2) {
                if (j2 < networkPrefixLength) {
                    sb.append("1");
                    continue;
                }
                sb.append("0");
            }
            s2.append(String.valueOf(Integer.valueOf(sb.toString(), 2)));
        }
        return s2.toString();
    }

    public static boolean a(String remoteIp, String localIp, String mask) {
        int[] remoteIpInts;
        int[] maskInts = v.d(mask);
        if (maskInts.length != (remoteIpInts = v.d(remoteIp)).length) {
            return false;
        }
        for (int i2 = 0; i2 < remoteIpInts.length; ++i2) {
            remoteIpInts[i2] = remoteIpInts[i2] & maskInts[i2];
        }
        int[] localIpInts = v.d(localIp);
        boolean flag = false;
        for (int i3 = 0; i3 < localIpInts.length; ++i3) {
            localIpInts[i3] = localIpInts[i3] & maskInts[i3];
            if (localIpInts[i3] != remoteIpInts[i3]) {
                flag = false;
                break;
            }
            flag = true;
        }
        return flag;
    }

    public static int[] d(String ip) {
        String[] splits = T.a(ip, '.');
        int[] result = new int[splits.length];
        for (int i2 = 0; i2 < splits.length; ++i2) {
            result[i2] = Integer.parseInt(splits[i2]);
        }
        return result;
    }

    public static boolean a(String ip, String cidr) {
        String cidrIp;
        String[] cidrIps;
        int cidrIpAddr;
        int type;
        int mask;
        String[] ips = ip.split("\\.");
        int ipAddr = Integer.parseInt(ips[0]) << 24 | Integer.parseInt(ips[1]) << 16 | Integer.parseInt(ips[2]) << 8 | Integer.parseInt(ips[3]);
        return (ipAddr & (mask = -1 << 32 - (type = Integer.parseInt(cidr.replaceAll(".*/", ""))))) == ((cidrIpAddr = Integer.parseInt((cidrIps = (cidrIp = cidr.replaceAll("/.*", "")).split("\\."))[0]) << 24 | Integer.parseInt(cidrIps[1]) << 16 | Integer.parseInt(cidrIps[2]) << 8 | Integer.parseInt(cidrIps[3])) & mask);
    }

    public static boolean b(String ipWithMask1, String ipWithMask2) {
        String[] ip1s = ipWithMask1.split("\\/");
        String mask1 = ip1s[1];
        String[] ip2s = ipWithMask2.split("\\/");
        String mask2 = ip2s[1];
        String[] mask1s = v.a(mask1.split("\\."));
        String[] mask2s = v.a(mask2.split("\\."));
        String[] commonMask = new String[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            commonMask[i2] = Integer.toString(Integer.valueOf(mask1s[i2]) & Integer.valueOf(mask2s[i2]));
        }
        String[] ip1 = v.a(ip1s[0].split("\\."));
        String[] ip2 = v.a(ip2s[0].split("\\."));
        StringBuilder ipSubNet1 = new StringBuilder();
        StringBuilder ipSubNet2 = new StringBuilder();
        for (int i3 = 0; i3 < 4; ++i3) {
            Integer ip1Part = Integer.valueOf(ip1[i3]);
            Integer ip2Part = Integer.valueOf(ip2[i3]);
            Integer maskPart = Integer.valueOf(commonMask[i3]);
            ipSubNet1.append(ip1Part & maskPart);
            ipSubNet2.append(ip2Part & maskPart);
            if (i3 >= ip1.length - 1) continue;
            ipSubNet1.append(".");
            ipSubNet2.append(".");
        }
        return T.a(ipSubNet1.toString(), ipSubNet2.toString());
    }

    private static String[] a(String[] split) {
        if (split.length < 4) {
            String[] result = new String[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                result[i2] = i2 < split.length ? split[i2] : "0";
            }
            return result;
        }
        return split;
    }

    public static boolean a(String ip, long beginIp, long endIp) {
        if (!T.c(ip)) {
            long ipLong = v.b(ip);
            return ipLong >= beginIp && ipLong <= endIp;
        }
        return false;
    }

    public static boolean b(String ip, String beginIp, String endIp) {
        if (!T.c(beginIp) && !T.c(endIp)) {
            return v.a(ip, v.b(beginIp), v.b(endIp));
        }
        return false;
    }

    public static long e(String maskBit) {
        return BigDecimal.valueOf(Math.pow(2.0, 32 - Integer.parseInt(maskBit))).setScale(0, 1).longValue();
    }

    public static String c(String ip, String maskBit) {
        return v.a(v.d(ip, maskBit));
    }

    public static Long d(String ip, String maskBit) {
        return v.b(ip) & v.b(v.b(Integer.parseInt(maskBit)));
    }

    public static Long e(String ip, String mask) {
        return v.b(ip) & v.b(mask);
    }

    public static Long f(String ipMask) {
        String ip = ipMask.replaceAll("/.*", "");
        String maskBit = ipMask.replaceAll(".*/", "");
        return v.b(ip) & v.b(v.b(Integer.parseInt(maskBit)));
    }

    public static String f(String ip, String maskBit) {
        return v.a(v.g(ip, maskBit));
    }

    public static Long g(String ip, String maskBit) {
        return v.d(ip, maskBit) + v.e(maskBit) - 1L;
    }

    public static Long h(String ip, String mask) {
        return v.e(ip, mask) + v.e(String.valueOf(v.i(mask))) - 1L;
    }

    public static Long g(String ipMask) {
        String ip = ipMask.replaceAll("/.*", "");
        String maskBit = ipMask.replaceAll(".*/", "");
        return v.d(ip, maskBit) + v.e(maskBit) - 1L;
    }

    public static String i(String ip, String maskBit) {
        String[] afterSplit = v.a(v.d(ip, maskBit)).split("\\.");
        return afterSplit[0] + "." + afterSplit[1] + "." + afterSplit[2] + "." + (Integer.parseInt(afterSplit[3]) + 1);
    }

    public static String j(String ip, String maskBit) {
        String[] afterSplit = v.a(v.g(ip, maskBit)).split("\\.");
        return afterSplit[0] + "." + afterSplit[1] + "." + afterSplit[2] + "." + (Integer.parseInt(afterSplit[3]) - 1);
    }

    public static boolean k(String oldIpMask, String newIpMask) {
        Long oldIpStart = v.f(oldIpMask);
        Long oldIpEnd = v.g(oldIpMask);
        Long newIpStart = v.f(newIpMask);
        Long newIpEnd = v.g(newIpMask);
        return newIpStart > oldIpStart || newIpEnd < oldIpEnd;
    }

    public static boolean a(String oldIp, String oldMask, String newIp, String newMask) {
        Long oldIpStart = v.e(oldIp, oldMask);
        Long oldIpEnd = v.h(oldIp, oldMask);
        Long newIpStart = v.e(newIp, newMask);
        Long newIpEnd = v.h(newIp, newMask);
        return newIpStart > oldIpStart || newIpEnd < oldIpEnd;
    }

    public static boolean h(String ip) {
        Matcher matcher = c.bf.matcher(ip);
        if (!matcher.matches()) {
            return false;
        }
        String v2 = ip.split("\\.")[0];
        if (Long.parseLong(v2) == 0L) {
            return false;
        }
        long longIp = v.b(ip);
        if (longIp == 0L) {
            return false;
        }
        if (longIp >= v.b("224.0.0.0") && longIp <= v.b("255.255.255.255")) {
            return false;
        }
        return !ip.startsWith("0");
    }

    public static String l(String ip, String subnet) {
        StringBuilder s2 = new StringBuilder(ip);
        return s2.append("/").append(v.i(subnet)).toString();
    }

    public static int i(String subnet) {
        int inetmask = 0;
        String[] ipList = subnet.split("\\.");
        for (int n2 = 0; n2 < ipList.length; ++n2) {
            StringBuilder sbf = v.c(Integer.parseInt(ipList[n2]));
            String str = sbf.reverse().toString();
            int count = 0;
            for (int i2 = 0; i2 < str.length() && (i2 = str.indexOf(49, i2)) != -1; ++i2) {
                ++count;
            }
            inetmask += count;
        }
        return inetmask;
    }

    public static boolean j(String ip) {
        Matcher matcher = c.bf.matcher(ip);
        return matcher.matches();
    }

    private static StringBuilder c(int x2) {
        StringBuilder result = new StringBuilder();
        result.append(x2 % 2);
        x2 /= 2;
        while (x2 > 0) {
            result.append(x2 % 2);
            x2 /= 2;
        }
        return result;
    }
}

