/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.common.gridquery;

import com.google.common.collect.Lists;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.cache.FilterMapCache;
import com.tplink.smb.omada.common.cache.h;
import com.tplink.smb.omada.common.gridquery.OpenApiQueryDataV2VO;
import com.tplink.smb.omada.common.gridquery.OpenApiQueryDataVO;
import com.tplink.smb.omada.common.gridquery.OpenApiQueryFilterVO;
import com.tplink.smb.omada.common.gridquery.b;
import com.tplink.smb.omada.common.gridquery.e;
import jakarta.annotation.Nullable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.CollectionUtils;

public class QueryDataVO {
    private int currentPage = 0;
    private int currentPageSize = 0;
    private LinkedHashMap<String, String> sorts;
    private String searchKey;
    @a(e=true)
    private Map<String, Object> filters;
    @Nullable
    private String searchField;
    @Nullable
    private Map<String, String> multiSearchMap;
    @Nullable
    private String asyncColumns;

    public static b transQueryDataWithSort(QueryDataVO queryDataVO, String sortMapKey) {
        return QueryDataVO.transQueryDataWithSortAndFilter(queryDataVO, sortMapKey, null);
    }

    public static b transQueryDataWithSortAndFilter(QueryDataVO queryDataVO, String sortMapKey, String filterMapKey) {
        b queryData = new b();
        queryData.a(queryDataVO.getCurrentPage() <= 0 ? 1 : queryDataVO.getCurrentPage());
        queryData.b(queryDataVO.getCurrentPageSize() <= 0 ? 10 : queryDataVO.getCurrentPageSize());
        queryData.c(queryDataVO.getSearchKey());
        queryData.b(queryDataVO.getMultiSearchMap());
        queryData.b(queryDataVO.getAsyncColumns());
        if (!StringUtils.isBlank((CharSequence)queryDataVO.getSearchField())) {
            List<String> searchFields = Lists.newArrayList((Object[])queryDataVO.getSearchField().split(",")).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            queryData.a(searchFields.isEmpty() ? null : searchFields);
        }
        if (sortMapKey == null) {
            return queryData;
        }
        if (!CollectionUtils.isEmpty(queryDataVO.getSorts())) {
            Map<String, String> sortMap = h.a(sortMapKey);
            queryDataVO.getSorts().forEach((key, direction) -> {
                if (sortMap.get(key) != null) {
                    queryData.a(new e((String)sortMap.get(key), (String)direction));
                }
            });
        }
        if (filterMapKey == null) {
            return queryData;
        }
        if (!CollectionUtils.isEmpty(queryDataVO.getFilters())) {
            Map<String, FilterMapCache.FilterKeyItem> filterMap = FilterMapCache.a(filterMapKey);
            queryDataVO.getFilters().forEach((key, value) -> {
                if (CollectionUtils.isEmpty((Map)filterMap)) {
                    return;
                }
                FilterMapCache.FilterKeyItem item = (FilterMapCache.FilterKeyItem)filterMap.get(key);
                if (item != null) {
                    switch (item.getType()) {
                        case NUMBER: {
                            Number number = NumberUtils.createNumber((String)value.toString());
                            queryData.a(item.getKey(), number);
                            break;
                        }
                        case BOOLEAN: {
                            queryData.a(item.getKey(), Boolean.valueOf(value.toString()));
                            break;
                        }
                        default: {
                            queryData.a(item.getKey(), value.toString());
                        }
                    }
                }
            });
        }
        return queryData;
    }

    public static b transQueryData(QueryDataVO queryDataVO) {
        return QueryDataVO.transQueryDataWithSortAndFilter(queryDataVO, null, null);
    }

    public static QueryDataVO buildByOpenApiVO(OpenApiQueryDataVO openApiQueryDataVO) {
        QueryDataVO queryDataVO = new QueryDataVO();
        if (openApiQueryDataVO == null) {
            return queryDataVO;
        }
        queryDataVO.setCurrentPage(openApiQueryDataVO.getPage());
        queryDataVO.setCurrentPageSize(openApiQueryDataVO.getPageSize());
        queryDataVO.setFilters(openApiQueryDataVO.getFilters());
        queryDataVO.setSorts(openApiQueryDataVO.getSorts());
        queryDataVO.setSearchKey(openApiQueryDataVO.getSearchKey());
        queryDataVO.setSearchField(openApiQueryDataVO.getSearchField());
        return queryDataVO;
    }

    public static QueryDataVO buildByOpenApiV2VO(OpenApiQueryDataV2VO openApiQueryDataV2VO) {
        QueryDataVO queryDataVO = new QueryDataVO();
        if (openApiQueryDataV2VO == null) {
            return queryDataVO;
        }
        queryDataVO.setCurrentPage(openApiQueryDataV2VO.getPage());
        queryDataVO.setCurrentPageSize(openApiQueryDataV2VO.getPageSize());
        queryDataVO.setFilters(openApiQueryDataV2VO.getFilters());
        queryDataVO.setSorts(openApiQueryDataV2VO.getSorts());
        queryDataVO.setSearchKey(openApiQueryDataV2VO.getSearchKey());
        queryDataVO.setSearchField(openApiQueryDataV2VO.getSearchField());
        return queryDataVO;
    }

    public static QueryDataVO buildByOpenApiVO(OpenApiQueryFilterVO openApiQueryFilterVO) {
        QueryDataVO queryDataVO = new QueryDataVO();
        if (openApiQueryFilterVO == null) {
            return queryDataVO;
        }
        queryDataVO.setFilters(openApiQueryFilterVO.getFilters());
        queryDataVO.setSorts(openApiQueryFilterVO.getSorts());
        queryDataVO.setSearchKey(openApiQueryFilterVO.getSearchKey());
        return queryDataVO;
    }

    public boolean noNeedPagingQuery() {
        return this.currentPage == 0 && this.currentPageSize == 0;
    }

    @Nullable
    public String getSearchField() {
        return this.searchField;
    }

    public void setSearchField(@Nullable String searchField) {
        this.searchField = searchField;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage <= 0) {
            this.currentPage = 1;
            return;
        }
        this.currentPage = currentPage;
    }

    public LinkedHashMap<String, String> getSorts() {
        return this.sorts;
    }

    public void setSorts(LinkedHashMap<String, String> sorts) {
        this.sorts = sorts;
    }

    public int getCurrentPageSize() {
        return this.currentPageSize;
    }

    public void setCurrentPageSize(int currentPageSize) {
        if (currentPageSize <= 0) {
            this.currentPageSize = 10;
            return;
        }
        this.currentPageSize = currentPageSize;
    }

    public Map<String, Object> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, Object> filters) {
        this.filters = filters;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public void setSearchKey(String searchKey) {
        this.searchKey = searchKey;
    }

    public Map<String, String> getMultiSearchMap() {
        return this.multiSearchMap;
    }

    public void setMultiSearchMap(Map<String, String> multiSearchMap) {
        this.multiSearchMap = multiSearchMap;
    }

    public void setAsyncColumns(String asyncColumns) {
        this.asyncColumns = asyncColumns;
    }

    public String getAsyncColumns() {
        return this.asyncColumns;
    }

    @Generated
    public String toString() {
        return "QueryDataVO(currentPage=" + this.getCurrentPage() + ", currentPageSize=" + this.getCurrentPageSize() + ", sorts=" + this.getSorts() + ", searchKey=" + this.getSearchKey() + ", filters=" + this.getFilters() + ", searchField=" + this.getSearchField() + ", multiSearchMap=" + this.getMultiSearchMap() + ", asyncColumns=" + this.getAsyncColumns() + ")";
    }
}

