/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.common.gridquery;

import com.google.common.collect.Lists;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.cache.FilterMapCache;
import com.tplink.smb.omada.common.cache.h;
import com.tplink.smb.omada.common.gridquery.b;
import com.tplink.smb.omada.common.gridquery.e;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class OpenApiQueryDataV2VO {
    @NotNull(message="page should not be null.")
    @Range(min=1L, message="page should not be less than 1.")
    @Schema(name="page", description="Start from 1.")
    private @NotNull(message="page should not be null.") @Range(min=1L, message="page should not be less than 1.") Integer page;
    @NotNull(message="pageSize should not be null.")
    @Range(min=1L, max=100L, message="pageSize should between 1 and 100.")
    @Schema(name="pageSize", description="It should be within the range of 1\u2013100.")
    private @NotNull(message="pageSize should not be null.") @Range(min=1L, max=100L, message="pageSize should between 1 and 100.") Integer pageSize;
    private LinkedHashMap<String, String> sorts;
    @Schema(name="searchKey", description="Look for a specific piece of data.")
    private String searchKey;
    @a(e=true)
    private Map<String, Object> filters;
    @Nullable
    private String searchField;

    public static b transQueryDataWithSort(OpenApiQueryDataV2VO queryDataVO, String sortMapKey) {
        return OpenApiQueryDataV2VO.transQueryDataWithSortAndFilter(queryDataVO, sortMapKey, null);
    }

    public static b transQueryDataWithSortAndFilter(OpenApiQueryDataV2VO queryDataVO, String sortMapKey, String filterMapKey) {
        b queryData = new b();
        queryData.a(queryDataVO.getPage() == null ? 1 : queryDataVO.getPage());
        queryData.b(queryDataVO.getPageSize() == null ? 10 : queryDataVO.getPageSize());
        queryData.c(queryDataVO.getSearchKey());
        if (!StringUtils.isBlank((CharSequence)queryDataVO.getSearchField())) {
            List<String> searchFields = Lists.newArrayList((Object[])queryDataVO.getSearchField().split(",")).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            queryData.a(searchFields.isEmpty() ? null : searchFields);
        }
        if (sortMapKey == null) {
            return queryData;
        }
        if (!CollectionUtils.isEmpty(queryDataVO.getSorts())) {
            Map<String, String> sortMap = h.a(sortMapKey);
            queryDataVO.getSorts().forEach((key, direction) -> {
                if (sortMap.get(key) != null) {
                    queryData.a(new e((String)sortMap.get(key), (String)direction));
                }
            });
        }
        if (filterMapKey == null) {
            return queryData;
        }
        if (!CollectionUtils.isEmpty(queryDataVO.getFilters())) {
            Map<String, FilterMapCache.FilterKeyItem> filterMap = FilterMapCache.a(filterMapKey);
            queryDataVO.getFilters().forEach((key, value) -> {
                FilterMapCache.FilterKeyItem item = (FilterMapCache.FilterKeyItem)filterMap.get(key);
                if (item != null) {
                    switch (item.getType()) {
                        case NUMBER: {
                            Number number = NumberUtils.createNumber((String)value.toString());
                            queryData.a(item.getKey(), number);
                            break;
                        }
                        case BOOLEAN: {
                            queryData.a(item.getKey(), Boolean.valueOf(value.toString()));
                            break;
                        }
                        default: {
                            queryData.a(item.getKey(), value.toString());
                        }
                    }
                }
            });
        }
        return queryData;
    }

    public static b transQueryData(OpenApiQueryDataV2VO queryDataVO) {
        return OpenApiQueryDataV2VO.transQueryDataWithSortAndFilter(queryDataVO, null, null);
    }

    public boolean noNeedPagingQuery() {
        return this.page == 0 && this.pageSize == 0;
    }

    @Nullable
    public String getSearchField() {
        return this.searchField;
    }

    public void setSearchField(@Nullable String searchField) {
        this.searchField = searchField;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public LinkedHashMap<String, String> getSorts() {
        return this.sorts;
    }

    public void setSorts(LinkedHashMap<String, String> sorts) {
        this.sorts = sorts;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Map<String, Object> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, Object> filters) {
        this.filters = filters;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public void setSearchKey(String searchKey) {
        this.searchKey = searchKey;
    }
}

