/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.common.gridquery;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class GridVO<T> {
    @Schema(name="totalRows", description="Total rows of all items.")
    private long totalRows = 0L;
    @Schema(name="currentPage", description="Current page number.")
    private int currentPage = 1;
    @Schema(name="currentSize", description="Number of entries per page.")
    private int currentSize = 10;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private List<T> data = Collections.emptyList();

    public GridVO() {
    }

    public GridVO(long totalRows, int currentPage, int currentSize, List<T> data) {
        this.totalRows = totalRows;
        this.currentPage = currentPage;
        this.currentSize = currentSize;
        this.data = data;
    }

    public GridVO(long totalRows, int currentPage, int currentSize) {
        this.totalRows = totalRows;
        this.currentPage = currentPage;
        this.currentSize = currentSize;
    }

    public void correctCurrentPage() {
        int pageSize;
        int page = this.getCurrentPage();
        if ((long)(page - 1) * (long)(pageSize = this.getCurrentSize()) >= this.totalRows || page == 0) {
            page = (int)Math.ceil((double)this.totalRows / (double)pageSize);
            if (page == 0) {
                page = 1;
            }
            this.setCurrentPage(page);
        }
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(long totalRows) {
        this.totalRows = totalRows;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    public void setCurrentSize(int currentSize) {
        this.currentSize = currentSize;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    @Generated
    public String toString() {
        return "GridVO(totalRows=" + this.getTotalRows() + ", currentPage=" + this.getCurrentPage() + ", currentSize=" + this.getCurrentSize() + ", data=" + this.getData() + ")";
    }
}

