/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.common.device;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.T;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@KeepClass
public class StandardOswPortIndex
implements Comparable<StandardOswPortIndex> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandardOswPortIndex.class);
    @Nonnull
    private Integer unit;
    @Nonnull
    private Integer slot;
    @Nonnull
    private Integer port;
    private static final Pattern COMPLINE1 = Pattern.compile("[0-9]{1,2}/[0-9]{1,2}/[0-9]{1,2}");
    private static final Pattern COMPLINE2 = Pattern.compile("[0-9]{1,2}/[0-9]{1,2}/[0-9]{1,2}-[0-9]{1,2}");
    private static final Pattern COMPLINE3 = Pattern.compile("[0-9]{1,2}");
    private static final Pattern COMPLINE4 = Pattern.compile("[0-9]{1,2}-[0-9]{1,2}");

    public String toStandardStr() {
        return this.unit + "/" + this.slot + "/" + this.port;
    }

    public StandardOswPortIndex(@Nonnull Integer unit, @Nonnull Integer solt, @Nonnull Integer port) {
        this.unit = unit;
        this.slot = solt;
        this.port = port;
    }

    public StandardOswPortIndex(@Nonnull Integer port) {
        this.unit = 1;
        this.slot = 0;
        this.port = port;
    }

    public StandardOswPortIndex() {
        this.port = -1;
        this.slot = -1;
        this.unit = -1;
    }

    @Nonnull
    public static StandardOswPortIndex resolveStandardPortIndex(Integer port, String standardPort) {
        if (T.c(standardPort)) {
            return StandardOswPortIndex.a(port);
        }
        List<StandardOswPortIndex> standardOswPortIndices = StandardOswPortIndex.resolvePortStr(standardPort);
        if (CollectionUtils.isEmpty(standardOswPortIndices)) {
            return StandardOswPortIndex.a(port);
        }
        return standardOswPortIndices.get(0);
    }

    public boolean equalsWithOutUnit(@Nullable StandardOswPortIndex standardOswPortIndex) {
        if (standardOswPortIndex == null) {
            return false;
        }
        return Objects.equals(this.getSlot(), standardOswPortIndex.getSlot()) && Objects.equals(this.getPort(), standardOswPortIndex.getPort());
    }

    @NotNull
    private static StandardOswPortIndex a(@Nullable Integer port) {
        if (port == null) {
            return new StandardOswPortIndex();
        }
        return new StandardOswPortIndex(1, 0, port);
    }

    public static StandardOswPortIndex buildDefaultWithPort(Integer port) {
        return new StandardOswPortIndex(1, 0, port);
    }

    public static StandardOswPortIndex buildDefaultWithUnitAndPort(Integer unit, Integer port) {
        return new StandardOswPortIndex(unit, 0, port);
    }

    @Nullable
    public static List<StandardOswPortIndex> resolvePortStrs(List<String> portList) {
        if (CollectionUtils.isEmpty(portList)) {
            return null;
        }
        HashSet<StandardOswPortIndex> result = new HashSet<StandardOswPortIndex>();
        for (String standardOswPortIndexStr : portList) {
            List<StandardOswPortIndex> standardOswPortIndices = StandardOswPortIndex.resolvePortStr(standardOswPortIndexStr);
            if (CollectionUtils.isEmpty(standardOswPortIndices)) continue;
            result.addAll(standardOswPortIndices);
        }
        return new ArrayList<StandardOswPortIndex>(result);
    }

    @Override
    public int compareTo(@Nullable StandardOswPortIndex other) {
        if (other == null) {
            return 1;
        }
        if (this.unit.compareTo(other.unit) != 0) {
            return this.unit.compareTo(other.unit);
        }
        if (this.slot.compareTo(other.slot) != 0) {
            return this.slot.compareTo(other.slot);
        }
        return this.port.compareTo(other.port);
    }

    public static List<StandardOswPortIndex> resolvePortStr(@Nonnull String portStr) {
        String[] split = portStr.split(",");
        ArrayList<StandardOswPortIndex> results = new ArrayList<StandardOswPortIndex>();
        for (int i2 = 0; i2 < split.length; ++i2) {
            String[] split2;
            String[] split1;
            if (T.a(split[i2])) continue;
            if (COMPLINE1.matcher(split[i2]).matches()) {
                split1 = split[i2].split("/");
                if (split1.length != 3) continue;
                results.add(new StandardOswPortIndex(Integer.valueOf(split1[0]), Integer.valueOf(split1[1]), Integer.valueOf(split1[2])));
                continue;
            }
            if (!COMPLINE2.matcher(split[i2]).matches() || (split1 = split[i2].split("/")).length != 3 || (split2 = split1[2].split("-")).length != 2) continue;
            Integer start = Integer.valueOf(split2[0]);
            Integer end = Integer.valueOf(split2[1]);
            Integer j2 = start;
            while (j2 <= end) {
                results.add(new StandardOswPortIndex(Integer.valueOf(split1[0]), Integer.valueOf(split1[1]), j2));
                Integer n2 = j2;
                j2 = j2 + 1;
            }
        }
        return results;
    }

    public static List<StandardOswPortIndex> resolvePortDigitalStr(@Nonnull String portDigitalStr) {
        String[] split = portDigitalStr.split(",");
        ArrayList<StandardOswPortIndex> results = new ArrayList<StandardOswPortIndex>();
        for (int i2 = 0; i2 < split.length; ++i2) {
            String[] split1;
            if (T.a(split[i2])) continue;
            if (COMPLINE3.matcher(split[i2]).matches()) {
                results.add(StandardOswPortIndex.buildDefaultWithPort(Integer.valueOf(split[i2])));
                continue;
            }
            if (!COMPLINE4.matcher(split[i2]).matches() || (split1 = split[i2].split("-")).length != 2) continue;
            Integer start = Integer.valueOf(split1[0]);
            Integer end = Integer.valueOf(split1[1]);
            Integer j2 = start;
            while (j2 <= end) {
                results.add(StandardOswPortIndex.buildDefaultWithPort(j2));
                Integer n2 = j2;
                j2 = j2 + 1;
            }
        }
        return results;
    }

    @Nullable
    public static String toPortStr(@Nonnull List<StandardOswPortIndex> standardOswPortIndices) {
        if (CollectionUtils.isEmpty(standardOswPortIndices)) {
            return null;
        }
        Set stPortSet = standardOswPortIndices.stream().map(StandardOswPortIndex::toStandardStr).collect(Collectors.toSet());
        return T.a(stPortSet, ",");
    }

    @Nonnull
    @Generated
    public Integer getUnit() {
        return this.unit;
    }

    @Nonnull
    @Generated
    public Integer getSlot() {
        return this.slot;
    }

    @Nonnull
    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public void setUnit(@Nonnull Integer unit) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.unit = unit;
    }

    @Generated
    public void setSlot(@Nonnull Integer slot) {
        if (slot == null) {
            throw new NullPointerException("slot is marked non-null but is null");
        }
        this.slot = slot;
    }

    @Generated
    public void setPort(@Nonnull Integer port) {
        if (port == null) {
            throw new NullPointerException("port is marked non-null but is null");
        }
        this.port = port;
    }

    @Generated
    public String toString() {
        return "StandardOswPortIndex(unit=" + this.getUnit() + ", slot=" + this.getSlot() + ", port=" + this.getPort() + ")";
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof StandardOswPortIndex)) {
            return false;
        }
        StandardOswPortIndex other = (StandardOswPortIndex)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$unit = this.getUnit();
        Integer other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !((Object)this$unit).equals(other$unit)) {
            return false;
        }
        Integer this$slot = this.getSlot();
        Integer other$slot = other.getSlot();
        if (this$slot == null ? other$slot != null : !((Object)this$slot).equals(other$slot)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        return !(this$port == null ? other$port != null : !((Object)this$port).equals(other$port));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StandardOswPortIndex;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)$unit).hashCode());
        Integer $slot = this.getSlot();
        result = result * 59 + ($slot == null ? 43 : ((Object)$slot).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        return result;
    }
}

