/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.common.auditlog;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.access.RoleEnumDTO;
import com.tplink.smb.omada.common.access.UserLevelEnumDTO;
import com.tplink.smb.omada.common.access.UserTypeEnumDTO;
import com.tplink.smb.omada.common.util.T;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public class GetCurrentInfoResponseDTO {
    private String id;
    private String name;
    @PII(strategy=PIIMaskStrategy.HASH)
    private String email;
    private String accountId;
    private String tenantId;
    private Integer userType;
    private String omadacId;
    private Boolean verified;
    private Set<String> siteIds;
    private Map<String, String> siteInfos;
    private Boolean alert;
    private Boolean incidentNotification;
    private Boolean allSite;
    private String lastSite;
    private Date createdTime;
    private String parentUserId;
    private List<String> favorites;
    private List<String> favoritesCustomer;
    @Deprecated
    private String roleName;
    private Integer hotspotRoleType;
    private Boolean dismissFeedback;
    private Boolean devicesUpgradeNotification;
    private String roleId;
    private String roleTypeName;
    private Integer userLevel;
    private String customerRoleId;
    private Set<String> customerIds;
    private Map<String, String> customerInfos;
    private Boolean allCustomer;
    private String lastCustomer;
    private String externalUserGroupId;
    private Boolean openApiRequest;
    private Integer grantType;

    public static boolean validate(GetCurrentInfoResponseDTO userDTO) {
        if (userDTO == null || userDTO.getUserType() == null || RoleEnumDTO.resolve(userDTO.getUserType()) == null) {
            return false;
        }
        return !T.a(userDTO.getOmadacId());
    }

    public Optional<String> getUsernameOrCloudAccount() {
        return this.isCloudUser() ? Optional.ofNullable(this.email) : Optional.ofNullable(this.name);
    }

    public boolean isCloudUser() {
        if (this.getUserType() != null) {
            return Objects.equals(UserTypeEnumDTO.CLOUD_USER.getValue(), this.getUserType());
        }
        return false;
    }

    public boolean isRoot() {
        return Objects.equals("master_admin_id", this.getRoleId()) || Objects.equals("msp_master_admin_id", this.getRoleId());
    }

    public boolean isMspUser() {
        return Objects.equals(UserLevelEnumDTO.MSP_USER.getLevel(), this.getUserLevel());
    }

    public String getControllerId() {
        return this.getOmadacId();
    }

    public boolean isDefaultRole() {
        return Objects.equals("master_admin_id", this.roleId) || Objects.equals("admin_id", this.roleId) || Objects.equals("super_admin_id", this.roleId) || Objects.equals("viewer_id", this.roleId) || Objects.equals("msp_master_admin_id", this.roleId) || Objects.equals("msp_admin_id", this.roleId) || Objects.equals("msp_super_admin_id", this.roleId) || Objects.equals("msp_viewer_id", this.roleId) || Objects.equals("customer_master_admin_id", this.roleId) || Objects.equals("customer_admin_id", this.roleId) || Objects.equals("customer_viewer_id", this.roleId) || Objects.equals("customer_super_admin_id", this.roleId);
    }

    public int userResource() {
        return Boolean.TRUE.equals(this.getOpenApiRequest()) ? 1 : 0;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setVerified(Boolean verified) {
        this.verified = verified;
    }

    @Generated
    public void setSiteIds(Set<String> siteIds) {
        this.siteIds = siteIds;
    }

    @Generated
    public void setSiteInfos(Map<String, String> siteInfos) {
        this.siteInfos = siteInfos;
    }

    @Generated
    public void setAlert(Boolean alert) {
        this.alert = alert;
    }

    @Generated
    public void setIncidentNotification(Boolean incidentNotification) {
        this.incidentNotification = incidentNotification;
    }

    @Generated
    public void setAllSite(Boolean allSite) {
        this.allSite = allSite;
    }

    @Generated
    public void setLastSite(String lastSite) {
        this.lastSite = lastSite;
    }

    @Generated
    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public void setParentUserId(String parentUserId) {
        this.parentUserId = parentUserId;
    }

    @Generated
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    @Generated
    public void setFavoritesCustomer(List<String> favoritesCustomer) {
        this.favoritesCustomer = favoritesCustomer;
    }

    @Deprecated
    @Generated
    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @Generated
    public void setHotspotRoleType(Integer hotspotRoleType) {
        this.hotspotRoleType = hotspotRoleType;
    }

    @Generated
    public void setDismissFeedback(Boolean dismissFeedback) {
        this.dismissFeedback = dismissFeedback;
    }

    @Generated
    public void setDevicesUpgradeNotification(Boolean devicesUpgradeNotification) {
        this.devicesUpgradeNotification = devicesUpgradeNotification;
    }

    @Generated
    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    @Generated
    public void setRoleTypeName(String roleTypeName) {
        this.roleTypeName = roleTypeName;
    }

    @Generated
    public void setUserLevel(Integer userLevel) {
        this.userLevel = userLevel;
    }

    @Generated
    public void setCustomerRoleId(String customerRoleId) {
        this.customerRoleId = customerRoleId;
    }

    @Generated
    public void setCustomerIds(Set<String> customerIds) {
        this.customerIds = customerIds;
    }

    @Generated
    public void setCustomerInfos(Map<String, String> customerInfos) {
        this.customerInfos = customerInfos;
    }

    @Generated
    public void setAllCustomer(Boolean allCustomer) {
        this.allCustomer = allCustomer;
    }

    @Generated
    public void setLastCustomer(String lastCustomer) {
        this.lastCustomer = lastCustomer;
    }

    @Generated
    public void setExternalUserGroupId(String externalUserGroupId) {
        this.externalUserGroupId = externalUserGroupId;
    }

    @Generated
    public void setOpenApiRequest(Boolean openApiRequest) {
        this.openApiRequest = openApiRequest;
    }

    @Generated
    public void setGrantType(Integer grantType) {
        this.grantType = grantType;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public Integer getUserType() {
        return this.userType;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public Boolean getVerified() {
        return this.verified;
    }

    @Generated
    public Set<String> getSiteIds() {
        return this.siteIds;
    }

    @Generated
    public Map<String, String> getSiteInfos() {
        return this.siteInfos;
    }

    @Generated
    public Boolean getAlert() {
        return this.alert;
    }

    @Generated
    public Boolean getIncidentNotification() {
        return this.incidentNotification;
    }

    @Generated
    public Boolean getAllSite() {
        return this.allSite;
    }

    @Generated
    public String getLastSite() {
        return this.lastSite;
    }

    @Generated
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public String getParentUserId() {
        return this.parentUserId;
    }

    @Generated
    public List<String> getFavorites() {
        return this.favorites;
    }

    @Generated
    public List<String> getFavoritesCustomer() {
        return this.favoritesCustomer;
    }

    @Deprecated
    @Generated
    public String getRoleName() {
        return this.roleName;
    }

    @Generated
    public Integer getHotspotRoleType() {
        return this.hotspotRoleType;
    }

    @Generated
    public Boolean getDismissFeedback() {
        return this.dismissFeedback;
    }

    @Generated
    public Boolean getDevicesUpgradeNotification() {
        return this.devicesUpgradeNotification;
    }

    @Generated
    public String getRoleId() {
        return this.roleId;
    }

    @Generated
    public String getRoleTypeName() {
        return this.roleTypeName;
    }

    @Generated
    public Integer getUserLevel() {
        return this.userLevel;
    }

    @Generated
    public String getCustomerRoleId() {
        return this.customerRoleId;
    }

    @Generated
    public Set<String> getCustomerIds() {
        return this.customerIds;
    }

    @Generated
    public Map<String, String> getCustomerInfos() {
        return this.customerInfos;
    }

    @Generated
    public Boolean getAllCustomer() {
        return this.allCustomer;
    }

    @Generated
    public String getLastCustomer() {
        return this.lastCustomer;
    }

    @Generated
    public String getExternalUserGroupId() {
        return this.externalUserGroupId;
    }

    @Generated
    public Boolean getOpenApiRequest() {
        return this.openApiRequest;
    }

    @Generated
    public Integer getGrantType() {
        return this.grantType;
    }

    @Generated
    public GetCurrentInfoResponseDTO() {
    }

    @Generated
    public GetCurrentInfoResponseDTO(String id, String name, String email, String accountId, String tenantId, Integer userType, String omadacId, Boolean verified, Set<String> siteIds, Map<String, String> siteInfos, Boolean alert, Boolean incidentNotification, Boolean allSite, String lastSite, Date createdTime, String parentUserId, List<String> favorites, List<String> favoritesCustomer, String roleName, Integer hotspotRoleType, Boolean dismissFeedback, Boolean devicesUpgradeNotification, String roleId, String roleTypeName, Integer userLevel, String customerRoleId, Set<String> customerIds, Map<String, String> customerInfos, Boolean allCustomer, String lastCustomer, String externalUserGroupId, Boolean openApiRequest, Integer grantType) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.accountId = accountId;
        this.tenantId = tenantId;
        this.userType = userType;
        this.omadacId = omadacId;
        this.verified = verified;
        this.siteIds = siteIds;
        this.siteInfos = siteInfos;
        this.alert = alert;
        this.incidentNotification = incidentNotification;
        this.allSite = allSite;
        this.lastSite = lastSite;
        this.createdTime = createdTime;
        this.parentUserId = parentUserId;
        this.favorites = favorites;
        this.favoritesCustomer = favoritesCustomer;
        this.roleName = roleName;
        this.hotspotRoleType = hotspotRoleType;
        this.dismissFeedback = dismissFeedback;
        this.devicesUpgradeNotification = devicesUpgradeNotification;
        this.roleId = roleId;
        this.roleTypeName = roleTypeName;
        this.userLevel = userLevel;
        this.customerRoleId = customerRoleId;
        this.customerIds = customerIds;
        this.customerInfos = customerInfos;
        this.allCustomer = allCustomer;
        this.lastCustomer = lastCustomer;
        this.externalUserGroupId = externalUserGroupId;
        this.openApiRequest = openApiRequest;
        this.grantType = grantType;
    }

    @Generated
    public String toString() {
        return "GetCurrentInfoResponseDTO(id=" + this.getId() + ", name=" + this.getName() + ", email=" + this.getEmail() + ", accountId=" + this.getAccountId() + ", tenantId=" + this.getTenantId() + ", userType=" + this.getUserType() + ", omadacId=" + this.getOmadacId() + ", verified=" + this.getVerified() + ", siteIds=" + this.getSiteIds() + ", siteInfos=" + this.getSiteInfos() + ", alert=" + this.getAlert() + ", incidentNotification=" + this.getIncidentNotification() + ", allSite=" + this.getAllSite() + ", lastSite=" + this.getLastSite() + ", createdTime=" + this.getCreatedTime() + ", parentUserId=" + this.getParentUserId() + ", favorites=" + this.getFavorites() + ", favoritesCustomer=" + this.getFavoritesCustomer() + ", roleName=" + this.getRoleName() + ", hotspotRoleType=" + this.getHotspotRoleType() + ", dismissFeedback=" + this.getDismissFeedback() + ", devicesUpgradeNotification=" + this.getDevicesUpgradeNotification() + ", roleId=" + this.getRoleId() + ", roleTypeName=" + this.getRoleTypeName() + ", userLevel=" + this.getUserLevel() + ", customerRoleId=" + this.getCustomerRoleId() + ", customerIds=" + this.getCustomerIds() + ", customerInfos=" + this.getCustomerInfos() + ", allCustomer=" + this.getAllCustomer() + ", lastCustomer=" + this.getLastCustomer() + ", externalUserGroupId=" + this.getExternalUserGroupId() + ", openApiRequest=" + this.getOpenApiRequest() + ", grantType=" + this.getGrantType() + ")";
    }
}

