/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.common.access;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.access.UserLevelEnumDTO;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public class UserInfoBriefDTO {
    private String id;
    private String omadacId;
    private String tenantId;
    private String name;
    @PII(strategy=PIIMaskStrategy.HASH)
    private String email;
    private String sessionId;
    private String accessToken;
    private Boolean openApiRequest;
    private Integer userLevel;
    private Boolean temporaryUser;
    private String roleId;
    private String roleTypeName;
    private Boolean allSite;
    private Set<String> sites;
    private Integer userType;
    private String accountId;
    private Boolean allCustomer;
    private Set<String> customers;
    private String customerRoleId;
    private Boolean viewerPermission;
    private Set<String> encryptFields;

    @JsonIgnore
    public String getUsernameOrCloudAccount() {
        return this.name == null ? this.email : this.name;
    }

    @JsonIgnore
    public boolean isMspUser() {
        return Objects.equals(UserLevelEnumDTO.MSP_USER.getLevel(), this.getUserLevel());
    }

    @JsonIgnore
    public boolean isOwner() {
        return Objects.equals("master_admin_id", this.getRoleId()) || Objects.equals("msp_master_admin_id", this.getRoleId());
    }

    @JsonIgnore
    public boolean isRoot() {
        return this.isOwner() || Objects.equals("super_admin_id", this.getRoleId()) || Objects.equals("msp_super_admin_id", this.getRoleId()) || Objects.equals("customer_super_admin_id", this.getRoleId());
    }

    @Generated
    public static UserInfoBriefDTOBuilder builder() {
        return new UserInfoBriefDTOBuilder();
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @Generated
    public void setOpenApiRequest(Boolean openApiRequest) {
        this.openApiRequest = openApiRequest;
    }

    @Generated
    public void setUserLevel(Integer userLevel) {
        this.userLevel = userLevel;
    }

    @Generated
    public void setTemporaryUser(Boolean temporaryUser) {
        this.temporaryUser = temporaryUser;
    }

    @Generated
    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    @Generated
    public void setRoleTypeName(String roleTypeName) {
        this.roleTypeName = roleTypeName;
    }

    @Generated
    public void setAllSite(Boolean allSite) {
        this.allSite = allSite;
    }

    @Generated
    public void setSites(Set<String> sites) {
        this.sites = sites;
    }

    @Generated
    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    @Generated
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @Generated
    public void setAllCustomer(Boolean allCustomer) {
        this.allCustomer = allCustomer;
    }

    @Generated
    public void setCustomers(Set<String> customers) {
        this.customers = customers;
    }

    @Generated
    public void setCustomerRoleId(String customerRoleId) {
        this.customerRoleId = customerRoleId;
    }

    @Generated
    public void setViewerPermission(Boolean viewerPermission) {
        this.viewerPermission = viewerPermission;
    }

    @Generated
    public void setEncryptFields(Set<String> encryptFields) {
        this.encryptFields = encryptFields;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String getAccessToken() {
        return this.accessToken;
    }

    @Generated
    public Boolean getOpenApiRequest() {
        return this.openApiRequest;
    }

    @Generated
    public Integer getUserLevel() {
        return this.userLevel;
    }

    @Generated
    public Boolean getTemporaryUser() {
        return this.temporaryUser;
    }

    @Generated
    public String getRoleId() {
        return this.roleId;
    }

    @Generated
    public String getRoleTypeName() {
        return this.roleTypeName;
    }

    @Generated
    public Boolean getAllSite() {
        return this.allSite;
    }

    @Generated
    public Set<String> getSites() {
        return this.sites;
    }

    @Generated
    public Integer getUserType() {
        return this.userType;
    }

    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @Generated
    public Boolean getAllCustomer() {
        return this.allCustomer;
    }

    @Generated
    public Set<String> getCustomers() {
        return this.customers;
    }

    @Generated
    public String getCustomerRoleId() {
        return this.customerRoleId;
    }

    @Generated
    public Boolean getViewerPermission() {
        return this.viewerPermission;
    }

    @Generated
    public Set<String> getEncryptFields() {
        return this.encryptFields;
    }

    @Generated
    public UserInfoBriefDTO(String id, String omadacId, String tenantId, String name, String email, String sessionId, String accessToken, Boolean openApiRequest, Integer userLevel, Boolean temporaryUser, String roleId, String roleTypeName, Boolean allSite, Set<String> sites, Integer userType, String accountId, Boolean allCustomer, Set<String> customers, String customerRoleId, Boolean viewerPermission, Set<String> encryptFields) {
        this.id = id;
        this.omadacId = omadacId;
        this.tenantId = tenantId;
        this.name = name;
        this.email = email;
        this.sessionId = sessionId;
        this.accessToken = accessToken;
        this.openApiRequest = openApiRequest;
        this.userLevel = userLevel;
        this.temporaryUser = temporaryUser;
        this.roleId = roleId;
        this.roleTypeName = roleTypeName;
        this.allSite = allSite;
        this.sites = sites;
        this.userType = userType;
        this.accountId = accountId;
        this.allCustomer = allCustomer;
        this.customers = customers;
        this.customerRoleId = customerRoleId;
        this.viewerPermission = viewerPermission;
        this.encryptFields = encryptFields;
    }

    @Generated
    public UserInfoBriefDTO() {
    }

    @Generated
    public static class UserInfoBriefDTOBuilder {
        @Generated
        private String id;
        @Generated
        private String omadacId;
        @Generated
        private String tenantId;
        @Generated
        private String name;
        @Generated
        private String email;
        @Generated
        private String sessionId;
        @Generated
        private String accessToken;
        @Generated
        private Boolean openApiRequest;
        @Generated
        private Integer userLevel;
        @Generated
        private Boolean temporaryUser;
        @Generated
        private String roleId;
        @Generated
        private String roleTypeName;
        @Generated
        private Boolean allSite;
        @Generated
        private Set<String> sites;
        @Generated
        private Integer userType;
        @Generated
        private String accountId;
        @Generated
        private Boolean allCustomer;
        @Generated
        private Set<String> customers;
        @Generated
        private String customerRoleId;
        @Generated
        private Boolean viewerPermission;
        @Generated
        private Set<String> encryptFields;

        @Generated
        UserInfoBriefDTOBuilder() {
        }

        @Generated
        public UserInfoBriefDTOBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder omadacId(String omadacId) {
            this.omadacId = omadacId;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder email(String email) {
            this.email = email;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder openApiRequest(Boolean openApiRequest) {
            this.openApiRequest = openApiRequest;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder userLevel(Integer userLevel) {
            this.userLevel = userLevel;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder temporaryUser(Boolean temporaryUser) {
            this.temporaryUser = temporaryUser;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder roleTypeName(String roleTypeName) {
            this.roleTypeName = roleTypeName;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder allSite(Boolean allSite) {
            this.allSite = allSite;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder sites(Set<String> sites) {
            this.sites = sites;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder userType(Integer userType) {
            this.userType = userType;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder allCustomer(Boolean allCustomer) {
            this.allCustomer = allCustomer;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder customers(Set<String> customers) {
            this.customers = customers;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder customerRoleId(String customerRoleId) {
            this.customerRoleId = customerRoleId;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder viewerPermission(Boolean viewerPermission) {
            this.viewerPermission = viewerPermission;
            return this;
        }

        @Generated
        public UserInfoBriefDTOBuilder encryptFields(Set<String> encryptFields) {
            this.encryptFields = encryptFields;
            return this;
        }

        @Generated
        public UserInfoBriefDTO build() {
            return new UserInfoBriefDTO(this.id, this.omadacId, this.tenantId, this.name, this.email, this.sessionId, this.accessToken, this.openApiRequest, this.userLevel, this.temporaryUser, this.roleId, this.roleTypeName, this.allSite, this.sites, this.userType, this.accountId, this.allCustomer, this.customers, this.customerRoleId, this.viewerPermission, this.encryptFields);
        }

        @Generated
        public String toString() {
            return "UserInfoBriefDTO.UserInfoBriefDTOBuilder(id=" + this.id + ", omadacId=" + this.omadacId + ", tenantId=" + this.tenantId + ", name=" + this.name + ", email=" + this.email + ", sessionId=" + this.sessionId + ", accessToken=" + this.accessToken + ", openApiRequest=" + this.openApiRequest + ", userLevel=" + this.userLevel + ", temporaryUser=" + this.temporaryUser + ", roleId=" + this.roleId + ", roleTypeName=" + this.roleTypeName + ", allSite=" + this.allSite + ", sites=" + this.sites + ", userType=" + this.userType + ", accountId=" + this.accountId + ", allCustomer=" + this.allCustomer + ", customers=" + this.customers + ", customerRoleId=" + this.customerRoleId + ", viewerPermission=" + this.viewerPermission + ", encryptFields=" + this.encryptFields + ")";
        }
    }
}

