/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.common.access;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import lombok.Generated;

public enum RoleEnumDTO {
    SYSTEM_ROOT(0, "Master Administrator"),
    SYSTEM_ADMIN(1, "Administrator"),
    SYSTEM_VIEWER(2, "Viewer"),
    CLOUD_ROOT(3, "Master Cloud Administrator"),
    CLOUD_ADMIN(4, "Cloud Administrator"),
    CLOUD_VIEWER(5, "Cloud Viewer");

    private int value;
    private String name;

    @Nullable
    public static RoleEnumDTO resolve(String name) {
        for (RoleEnumDTO roleType : RoleEnumDTO.values()) {
            if (!roleType.name.equals(name)) continue;
            return roleType;
        }
        return null;
    }

    @Nullable
    public static RoleEnumDTO resolve(Integer value) {
        if (Objects.isNull(value)) {
            return null;
        }
        for (RoleEnumDTO roleType : RoleEnumDTO.values()) {
            if (roleType.value != value) continue;
            return roleType;
        }
        return null;
    }

    public static boolean isCloudUser(int type) {
        RoleEnumDTO roleType = RoleEnumDTO.resolve(type);
        if (roleType == null) {
            return false;
        }
        return roleType.isCloudUser();
    }

    public boolean isCloudUser() {
        switch (this) {
            case CLOUD_ROOT: 
            case CLOUD_ADMIN: 
            case CLOUD_VIEWER: {
                return true;
            }
        }
        return false;
    }

    public boolean isRoot() {
        switch (this) {
            case CLOUD_ROOT: 
            case SYSTEM_ROOT: {
                return true;
            }
        }
        return false;
    }

    public boolean isAdmin() {
        switch (this) {
            case CLOUD_ADMIN: 
            case SYSTEM_ADMIN: {
                return true;
            }
        }
        return false;
    }

    public String getTypeName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    @Nonnull
    public static Integer[] getLocalUserRoles() {
        return new Integer[]{RoleEnumDTO.SYSTEM_ROOT.value, RoleEnumDTO.SYSTEM_ADMIN.value, RoleEnumDTO.SYSTEM_VIEWER.value};
    }

    @Nonnull
    public static Integer[] getCloudUserRoles() {
        return new Integer[]{RoleEnumDTO.CLOUD_ROOT.value, RoleEnumDTO.CLOUD_ADMIN.value, RoleEnumDTO.CLOUD_VIEWER.value};
    }

    @Nonnull
    public static Integer[] getRootUserRoles() {
        return new Integer[]{RoleEnumDTO.CLOUD_ROOT.value, RoleEnumDTO.SYSTEM_ROOT.value};
    }

    @Nonnull
    public static Integer[] getRootAndAdminUserRoles() {
        return new Integer[]{RoleEnumDTO.CLOUD_ROOT.value, RoleEnumDTO.SYSTEM_ROOT.value, RoleEnumDTO.CLOUD_ADMIN.value, RoleEnumDTO.SYSTEM_ADMIN.value};
    }

    @Generated
    private RoleEnumDTO(int value, String name) {
        this.value = value;
        this.name = name;
    }
}

