/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.common.access;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.common.access.AuditLogReturnDTO;
import com.tplink.smb.omada.common.access.ResponseIdVO;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;

@KeepClass
public class OperationResponse<T>
extends com.tplink.smb.omada.dispatcher.common.access.OperationResponse<T> {
    public static final OperationResponse<Object> SUCCESS = new OperationResponse(b.a);
    public static final OperationResponse<Object> PARAM_ERROR = new OperationResponse(b.d);
    public static final OperationResponse<Object> GENERAL_ERROR = new OperationResponse(b.b);
    public static final OperationResponse<Object> UNSUPPORTED_HTTP_PATH = new OperationResponse(b.u);
    public static final OperationResponse<Object> UNSUPPORTED_HTTP_METHOD = new OperationResponse(b.e);
    public static final OperationResponse<Object> REQUEST_CONTAIN_XSS = new OperationResponse(b.v);
    public static final OperationResponse<Object> TARGET_NODE_FAILED = new OperationResponse(b.QE);
    private int errorCode;
    private String msg;
    private T result;
    @Nullable
    @JsonIgnore
    private AuditLogReturnDTO auditLogReturn;
    @Nullable
    @JsonIgnore
    @Deprecated
    private List<AuditLogReturnDTO> auditLogReturnList;

    public OperationResponse(b resErrorCode) {
        this.errorCode = resErrorCode.b();
        this.msg = resErrorCode.c();
        this.result = null;
        this.auditLogReturn = null;
    }

    public OperationResponse(OperationResponse<T> operationResponse) {
        this.errorCode = operationResponse.getErrorCode();
        this.msg = operationResponse.getMsg();
        this.result = operationResponse.getResult();
        this.auditLogReturn = operationResponse.getAuditLogReturn();
    }

    public OperationResponse(com.tplink.smb.omada.dispatcher.common.access.OperationResponse<T> operationResponse) {
        this.errorCode = operationResponse.getErrorCode();
        this.msg = operationResponse.getMsg();
        this.result = operationResponse.getResult();
    }

    public OperationResponse(b resErrorCode, T result) {
        this.errorCode = resErrorCode.b();
        this.msg = resErrorCode.c();
        this.result = result;
        this.auditLogReturn = null;
    }

    public OperationResponse(b resErrorCode, String msg, T result) {
        this.errorCode = resErrorCode.b();
        this.msg = msg;
        this.result = result;
        this.auditLogReturn = null;
    }

    public OperationResponse(int errorCode, String msg, T result) {
        this.errorCode = errorCode;
        this.msg = msg;
        this.result = result;
        this.auditLogReturn = null;
    }

    public OperationResponse(int errorCode, String msg, T result, AuditLogReturnDTO auditLogReturnDTO) {
        this.errorCode = errorCode;
        this.msg = msg;
        this.result = result;
        this.auditLogReturn = auditLogReturnDTO;
    }

    public static <T> OperationResponse<T> ok() {
        return new OperationResponse<Object>(b.a, null);
    }

    public static <T> OperationResponse<T> success(T body) {
        return new OperationResponse<T>(b.a, body);
    }

    public static <T> OperationResponse<T> success(T body, AuditLogReturnDTO auditLogReturnDTO) {
        OperationResponse<T> response = new OperationResponse<T>(b.a, body);
        response.setAuditLogReturn(auditLogReturnDTO);
        return response;
    }

    public static OperationResponse<ResponseIdVO> successWithId(String id) {
        ResponseIdVO responseIdVO = new ResponseIdVO(id);
        return OperationResponse.success(responseIdVO);
    }

    public boolean success() {
        return b.a.b() == this.errorCode;
    }

    public <R> OperationResponse<R> map(Function<T, R> function) {
        if (this.success() && this.result != null) {
            return new OperationResponse<R>(this.errorCode, this.msg, function.apply(this.result), this.auditLogReturn);
        }
        return new OperationResponse<Object>(this.errorCode, this.msg, null, this.auditLogReturn);
    }

    public T elseGet(@Nonnull Supplier<T> supplier) {
        if (this.success() && this.result != null) {
            return this.result;
        }
        return supplier.get();
    }

    public T orElse(@Nullable T other) {
        if (this.success() && this.result != null) {
            return this.result;
        }
        return other;
    }

    public OperationResponse<T> ifSuccess(Consumer<T> consumer) {
        if (this.success()) {
            consumer.accept(this.result);
        }
        return this;
    }

    public OperationResponse<T> ifSuccessAndNonnull(Consumer<T> consumer) {
        if (this.success() && this.result != null) {
            consumer.accept(this.result);
        }
        return this;
    }

    @Generated
    public int getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Generated
    public T getResult() {
        return this.result;
    }

    @Nullable
    @Generated
    public AuditLogReturnDTO getAuditLogReturn() {
        return this.auditLogReturn;
    }

    @Deprecated
    @Nullable
    @Generated
    public List<AuditLogReturnDTO> getAuditLogReturnList() {
        return this.auditLogReturnList;
    }

    @Generated
    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    @Generated
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Generated
    public void setResult(T result) {
        this.result = result;
    }

    @Generated
    public String toString() {
        return "OperationResponse(errorCode=" + this.getErrorCode() + ", msg=" + this.getMsg() + ", result=" + this.getResult() + ", auditLogReturn=" + this.getAuditLogReturn() + ", auditLogReturnList=" + this.getAuditLogReturnList() + ")";
    }

    @Generated
    public OperationResponse(int errorCode, String msg, T result, @Nullable AuditLogReturnDTO auditLogReturn, @Nullable List<AuditLogReturnDTO> auditLogReturnList) {
        this.errorCode = errorCode;
        this.msg = msg;
        this.result = result;
        this.auditLogReturn = auditLogReturn;
        this.auditLogReturnList = auditLogReturnList;
    }

    @Generated
    public OperationResponse() {
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OperationResponse)) {
            return false;
        }
        OperationResponse other = (OperationResponse)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getErrorCode() != other.getErrorCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        AuditLogReturnDTO this$auditLogReturn = this.getAuditLogReturn();
        AuditLogReturnDTO other$auditLogReturn = other.getAuditLogReturn();
        if (this$auditLogReturn == null ? other$auditLogReturn != null : !this$auditLogReturn.equals(other$auditLogReturn)) {
            return false;
        }
        List<AuditLogReturnDTO> this$auditLogReturnList = this.getAuditLogReturnList();
        List<AuditLogReturnDTO> other$auditLogReturnList = other.getAuditLogReturnList();
        return !(this$auditLogReturnList == null ? other$auditLogReturnList != null : !((Object)this$auditLogReturnList).equals(other$auditLogReturnList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OperationResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getErrorCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        AuditLogReturnDTO $auditLogReturn = this.getAuditLogReturn();
        result = result * 59 + ($auditLogReturn == null ? 43 : $auditLogReturn.hashCode());
        List<AuditLogReturnDTO> $auditLogReturnList = this.getAuditLogReturnList();
        result = result * 59 + ($auditLogReturnList == null ? 43 : ((Object)$auditLogReturnList).hashCode());
        return result;
    }

    @JsonIgnore
    @Generated
    public void setAuditLogReturn(@Nullable AuditLogReturnDTO auditLogReturn) {
        this.auditLogReturn = auditLogReturn;
    }

    @Deprecated
    @JsonIgnore
    @Generated
    public void setAuditLogReturnList(@Nullable List<AuditLogReturnDTO> auditLogReturnList) {
        this.auditLogReturnList = auditLogReturnList;
    }
}

