/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.utils;

import com.tplink.cdd.radius.common.tls.CipherSuite.TlsCipher;
import com.tplink.cdd.radius.common.tls.CipherSuite.TlsGenericCipher;
import com.tplink.cdd.radius.common.tls.dto.SecurityParameters;
import com.tplink.cdd.radius.common.tls.enums.RecordLayerType;
import com.tplink.cdd.radius.common.tls.enums.TlsVersion;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TlsUtil {
    private static final Logger log = LoggerFactory.getLogger(TlsUtil.class);

    public static TlsCipher createAESCipher(int cipherKeySize, SecurityParameters securityParameters, TlsVersion tlsVersion) {
        return new TlsGenericCipher(TlsUtil.createAESBlockCipher(), TlsUtil.createAESBlockCipher(), cipherKeySize, (Digest)new SHA1Digest(), (Digest)new SHA1Digest(), securityParameters, tlsVersion);
    }

    public static byte[] encryptTlsText(TlsCipher tlsCipher, RecordLayerType recordLayerType, byte[] plainText) {
        TlsGenericCipher tlsGenericCipher = (TlsGenericCipher)tlsCipher;
        try {
            return tlsGenericCipher.encodePlainText(recordLayerType.getIndex(), plainText, 0, plainText.length);
        }
        catch (IOException e) {
            log.warn("Failed to encrypt tls plain text [{}], error msg = {}", (Object)plainText, (Object)e.getMessage());
            return null;
        }
    }

    public static byte[] decryptTlsText(TlsCipher tlsCipher, RecordLayerType recordLayerType, byte[] cipherText) {
        TlsGenericCipher tlsGenericCipher = (TlsGenericCipher)tlsCipher;
        try {
            return tlsGenericCipher.decodeCipherText(recordLayerType.getIndex(), cipherText, 0, cipherText.length);
        }
        catch (IOException e) {
            log.warn("Failed to decrypt tls cipher text [{}], error msg = {}", (Object)cipherText, (Object)e.getMessage());
            return null;
        }
    }

    public static void writeUint8(short i, OutputStream os) throws IOException {
        os.write(i);
    }

    public static void writeVersion(OutputStream os, TlsVersion tlsVersion) throws IOException {
        if (tlsVersion == TlsVersion.V1_0) {
            os.write(3);
            os.write(1);
        } else if (tlsVersion == TlsVersion.V1_1) {
            os.write(3);
            os.write(2);
        } else if (tlsVersion == TlsVersion.V1_2) {
            os.write(3);
            os.write(3);
        } else if (tlsVersion == TlsVersion.V1_3) {
            os.write(3);
            os.write(4);
        }
    }

    public static void writeUint16(int i, OutputStream os) throws IOException {
        os.write(i >> 8);
        os.write(i);
    }

    public static void writeUint64(long i, OutputStream os) throws IOException {
        os.write((int)(i >> 56));
        os.write((int)(i >> 48));
        os.write((int)(i >> 40));
        os.write((int)(i >> 32));
        os.write((int)(i >> 24));
        os.write((int)(i >> 16));
        os.write((int)(i >> 8));
        os.write((int)i);
    }

    public static void writeGMTUnixTime(byte[] buf, int offset) {
        int t = (int)(System.currentTimeMillis() / 1000L);
        buf[offset] = (byte)(t >> 24);
        buf[offset + 1] = (byte)(t >> 16);
        buf[offset + 2] = (byte)(t >> 8);
        buf[offset + 3] = (byte)t;
    }

    private static BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher((BlockCipher)new AESFastEngine());
    }

    private TlsUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

