/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.utils;

import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.enums.RadiusAvp;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import java.util.Objects;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class RadiusAttributeUtil {
    private static final Logger log = LoggerFactory.getLogger(RadiusAttributeUtil.class);
    private static final int DEFAULT_VENDOR_ID = -1;
    private static final String MAC_PATTERN2 = "^([0-9a-fA-F]{2})(([0-9a-fA-F]{2}){5})$";

    public static String username(RadiusRequest radiusRequest) {
        return RadiusAttributeUtil.getAttribute(radiusRequest, RadiusAvp.USER_NAME);
    }

    public static String nasId(RadiusRequest radiusRequest) {
        return RadiusAttributeUtil.getAttribute(radiusRequest, RadiusAvp.NAS_IDENTIFIER);
    }

    public static String nasIp(RadiusRequest radiusRequest) {
        return RadiusAttributeUtil.getAttribute(radiusRequest, RadiusAvp.NAS_IP_ADDRESS);
    }

    public static String clientIp(RadiusRequest radiusRequest) {
        return RadiusAttributeUtil.getAttribute(radiusRequest, RadiusAvp.FRAMED_IP_ADDRESS);
    }

    public static String nasMac(RadiusRequest radiusRequest) {
        int index;
        String attributeCalledStationId = RadiusAttributeUtil.getAttribute(radiusRequest, RadiusAvp.CALLED_STATION_ID);
        if (!StringUtils.isEmpty((Object)attributeCalledStationId) && (index = attributeCalledStationId.lastIndexOf(58)) > 0) {
            return attributeCalledStationId.substring(0, index);
        }
        String attributeNASIdentifier = RadiusAttributeUtil.getAttribute(radiusRequest, RadiusAvp.NAS_IDENTIFIER);
        if (!StringUtils.isEmpty((Object)attributeNASIdentifier) && Pattern.compile(MAC_PATTERN2).matcher(attributeNASIdentifier).matches()) {
            return attributeNASIdentifier;
        }
        return null;
    }

    public static String clientMac(RadiusRequest radiusRequest) {
        return RadiusAttributeUtil.getAttribute(radiusRequest, RadiusAvp.CALLING_STATION_ID);
    }

    public static String ssId(RadiusRequest radiusRequest) {
        String attribute = RadiusAttributeUtil.getAttribute(radiusRequest, RadiusAvp.CALLED_STATION_ID);
        return Objects.isNull(attribute) ? null : attribute.substring(18);
    }

    public static String getAttribute(RadiusRequest radiusRequest, RadiusAvp radiusAvp) {
        return radiusRequest.getAttribute(radiusAvp.getIndex()).map(RadiusAttribute::getValueString).orElse(null);
    }

    public static RadiusAttribute createAttribute(Dictionary dictionary, byte code, byte[] data) {
        return dictionary.createAttribute(-1, (int)code, data);
    }

    private RadiusAttributeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

