/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.utils;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Strings;

public class CipherUtil {
    public static byte[] PRF(byte[] secret, String asciiLabel, byte[] seed, int size) {
        byte[] label = Strings.toByteArray((String)asciiLabel);
        int s_half = (secret.length + 1) / 2;
        byte[] s1 = new byte[s_half];
        byte[] s2 = new byte[s_half];
        System.arraycopy(secret, 0, s1, 0, s_half);
        System.arraycopy(secret, secret.length - s_half, s2, 0, s_half);
        byte[] ls = CipherUtil.concat(label, seed);
        byte[] buf = new byte[size];
        byte[] prf = new byte[size];
        CipherUtil.hmac_hash((Digest)new MD5Digest(), s1, ls, prf);
        CipherUtil.hmac_hash((Digest)new SHA1Digest(), s2, ls, buf);
        for (int i = 0; i < size; ++i) {
            int n = i;
            buf[n] = (byte)(buf[n] ^ prf[i]);
        }
        return buf;
    }

    public static byte[] PRF_SHA256(byte[] secret, String asciiLabel, byte[] seed, int size) {
        byte[] label = Strings.toByteArray((String)asciiLabel);
        byte[] ls = CipherUtil.concat(label, seed);
        byte[] result = new byte[size];
        CipherUtil.hmac_hash((Digest)new SHA256Digest(), secret, ls, result);
        return result;
    }

    public static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static void hmac_hash(Digest digest, byte[] secret, byte[] seed, byte[] out) {
        HMac mac = new HMac(digest);
        KeyParameter param = new KeyParameter(secret);
        byte[] a = seed;
        int size = digest.getDigestSize();
        int iterations = (out.length + size - 1) / size;
        byte[] buf = new byte[mac.getMacSize()];
        byte[] buf2 = new byte[mac.getMacSize()];
        for (int i = 0; i < iterations; ++i) {
            mac.init((CipherParameters)param);
            mac.update(a, 0, a.length);
            mac.doFinal(buf, 0);
            a = buf;
            mac.init((CipherParameters)param);
            mac.update(a, 0, a.length);
            mac.update(seed, 0, seed.length);
            mac.doFinal(buf2, 0);
            System.arraycopy(buf2, 0, out, size * i, Math.min(size, out.length - size * i));
        }
    }
}

