/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class CertificateUtil {
    public static Certificate certFromBuf(ByteBuf certData) throws CertificateException {
        ByteBufInputStream in = new ByteBufInputStream(certData);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("x.509");
        return certificateFactory.generateCertificate((InputStream)in);
    }

    public static byte[] decryptByPublicKey(byte[] data, PublicKey publicKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(2, publicKey);
        return cipher.doFinal(data);
    }

    public static PrivateKey getPrivateKeyByKeyStore(String keyStorePath, String alias, String keystore_password, String ca_password) throws Exception {
        KeyStore ks = CertificateUtil.getKeyStore(keyStorePath, keystore_password);
        return (PrivateKey)ks.getKey(alias, ca_password.toCharArray());
    }

    public static PublicKey getPublicKeyByCertificate(String certificatePath) throws Exception {
        Certificate certificate = CertificateUtil.getCertificate(certificatePath);
        return certificate.getPublicKey();
    }

    public static Certificate getCertificate(String certificatePath) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("x.509");
        FileInputStream in = new FileInputStream(certificatePath);
        Certificate certificate = certificateFactory.generateCertificate(in);
        in.close();
        return certificate;
    }

    public static ByteBuf getCertificateBuf(String certificatePath) throws IOException {
        FileInputStream in = new FileInputStream(certificatePath);
        if (in.available() == 0) {
            in.close();
            return null;
        }
        byte[] certByte = new byte[in.available()];
        in.read(certByte);
        in.close();
        return Unpooled.copiedBuffer((byte[])certByte);
    }

    public static Certificate getCertificate(String keyStorePath, String alias, String keystorePassword) throws Exception {
        KeyStore ks = CertificateUtil.getKeyStore(keyStorePath, keystorePassword);
        return ks.getCertificate(alias);
    }

    public static KeyStore getKeyStore(String keyStorePath, String keystorePassword) throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream is = new FileInputStream(keyStorePath);
        ks.load(is, keystorePassword.toCharArray());
        is.close();
        return ks;
    }

    public static byte[] encryptByPriateKey(byte[] data, String keyStorePath, String alias, String keystorePassword, String caPassword) throws Exception {
        PrivateKey privateKey = CertificateUtil.getPrivateKeyByKeyStore(keyStorePath, alias, keystorePassword, caPassword);
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(1, privateKey);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPrivateKey(byte[] data, String keyStorePath, String alias, String keystorePassword, String caPassword) throws Exception {
        PrivateKey privateKey = CertificateUtil.getPrivateKeyByKeyStore(keyStorePath, alias, keystorePassword, caPassword);
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(2, privateKey);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPrivateKey(byte[] data, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(2, privateKey);
        return cipher.doFinal(data);
    }

    public static byte[] encryptByPublicKey(byte[] data, String certificatePath) throws Exception {
        PublicKey publicKey = CertificateUtil.getPublicKeyByCertificate(certificatePath);
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(1, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPublicKey(byte[] data, String certificatePath) throws Exception {
        PublicKey publicKey = CertificateUtil.getPublicKeyByCertificate(certificatePath);
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(2, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] sign(byte[] sign, String keyStorePath, String alias, String keystorePassword, String caPassword) throws Exception {
        X509Certificate x509Certificate = (X509Certificate)CertificateUtil.getCertificate(keyStorePath, alias, keystorePassword);
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        PrivateKey privateKey = CertificateUtil.getPrivateKeyByKeyStore(keyStorePath, alias, keystorePassword, caPassword);
        signature.initSign(privateKey);
        signature.update(sign);
        return signature.sign();
    }

    public static boolean verify(byte[] data, byte[] sign, String certificatePath) throws Exception {
        X509Certificate x509Certificate = (X509Certificate)CertificateUtil.getCertificate(certificatePath);
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initVerify(x509Certificate);
        signature.update(data);
        return signature.verify(sign);
    }
}

