/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.ttls;

import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.eap.EapPacketException;
import com.tplink.cdd.radius.common.eap.packet.BaseEapPacket;
import com.tplink.cdd.radius.common.eap.packet.EapResponse;
import com.tplink.cdd.radius.common.enums.RadiusAvp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelReq {
    private static final Logger log = LoggerFactory.getLogger(TunnelReq.class);
    private final RadiusAvp authType;
    private final List<RadiusAttribute> attributeList;
    private EapResponse eapResponse;
    private static final Set<Integer> AUTH_ATTRIBUTE_LABELS = new HashSet<Integer>(Arrays.asList(RadiusAvp.CHAP_CHALLENGE.getIndex(), RadiusAvp.USER_PASSWORD.getIndex(), RadiusAvp.CHAP_PASSWORD.getIndex(), RadiusAvp.EAP_MESSAGE.getIndex()));

    public static TunnelReq fromRadiusAttributeList(List<RadiusAttribute> attributeList) throws RadiusPacketException {
        List<RadiusAvp> authTypes = TunnelReq.lookupAuthType(attributeList);
        if (authTypes.size() == 1) {
            RadiusAvp authType = authTypes.get(0);
            switch (authType) {
                case EAP_MESSAGE: {
                    try {
                        List<RadiusAttribute> eapMessageList = TunnelReq.filterAttributes(RadiusAvp.EAP_MESSAGE.getIndex(), attributeList);
                        EapResponse eapResponse = (EapResponse)BaseEapPacket.fromEapMessageList(eapMessageList);
                        return new TunnelReq(authType, attributeList, eapResponse);
                    }
                    catch (EapPacketException e) {
                        throw new RadiusPacketException("Exception found when parsing EAP-Message attribute");
                    }
                }
                case USER_PASSWORD: {
                    return new TunnelReq(authType, attributeList, null);
                }
            }
            throw new RadiusPacketException("Unsupported tunnel auth type [" + (Object)((Object)authType) + "]");
        }
        throw new RadiusPacketException("Unsupported tunnel auth type");
    }

    private static List<RadiusAvp> lookupAuthType(List<RadiusAttribute> attributes) throws RadiusPacketException {
        Set<Integer> detectedAuthLabels = attributes.stream().map(RadiusAttribute::getType).filter(AUTH_ATTRIBUTE_LABELS::contains).collect(Collectors.toSet());
        if (detectedAuthLabels.isEmpty()) {
            throw new RadiusPacketException("No auth attribute label found");
        }
        ArrayList<RadiusAvp> radiusAvps = new ArrayList<RadiusAvp>();
        detectedAuthLabels.forEach(detectedAuthLabel -> radiusAvps.add(RadiusAvp.fromIndex(detectedAuthLabel)));
        return radiusAvps;
    }

    private static List<RadiusAttribute> filterAttributes(int type, List<RadiusAttribute> radiusAttributeList) {
        return radiusAttributeList.stream().filter(radiusAttribute -> Objects.equals(radiusAttribute.getType(), type)).collect(Collectors.toList());
    }

    public RadiusAvp getAuthType() {
        return this.authType;
    }

    public List<RadiusAttribute> getAttributeList() {
        return this.attributeList;
    }

    public EapResponse getEapResponse() {
        return this.eapResponse;
    }

    public TunnelReq(RadiusAvp authType, List<RadiusAttribute> attributeList, EapResponse eapResponse) {
        this.authType = authType;
        this.attributeList = attributeList;
        this.eapResponse = eapResponse;
    }
}

