/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.ttls;

import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.enums.RadiusAvp;
import com.tplink.cdd.radius.common.utils.ByteUtil;
import com.tplink.cdd.radius.common.utils.RadiusAttributeUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DiameterFormat {
    private static final Logger log = LoggerFactory.getLogger(DiameterFormat.class);
    public static final int CODE_START_INDEX = 0;
    public static final int CODE_LAST_BYTE_INDEX = 3;
    public static final int CODE_SIZE = 4;
    public static final int CODE_END_INDEX = 4;
    public static final int FLAG_SIZE = 1;
    public static final int LENGTH_START_INDEX = 5;
    public static final int LENGTH_SIZE = 3;
    public static final int LENGTH_END_INDEX = 8;
    public static final int DATA_START_INDEX = 8;
    public static final int HEADER_SIZE = 8;
    public static final byte DEFAULT_FLAG = 64;
    public static final int DIAMETER_ATTRIBUTE_SIZE_BOUND = 4;

    public static List<RadiusAttribute> byteArray2RadiusAttribute(Dictionary dictionary, byte[] diameterAttribute) {
        log.debug("diameter attribute = {}", (Object)diameterAttribute);
        ArrayList<RadiusAttribute> avps = new ArrayList<RadiusAttribute>();
        int i = 0;
        int startIndex = 0;
        while (i < diameterAttribute.length - 8) {
            byte[] code = Arrays.copyOfRange(diameterAttribute, startIndex + 0, startIndex + 4);
            i += code.length;
            byte[] length = Arrays.copyOfRange(diameterAttribute, startIndex + 5, startIndex + 8);
            i += length.length;
            int dataLength = ByteUtil.byteArray2Int(length);
            byte[] data = Arrays.copyOfRange(diameterAttribute, startIndex + 8, startIndex + dataLength);
            int paddingLength = 0;
            if (dataLength % 4 != 0) {
                paddingLength = 4 - dataLength % 4;
            }
            startIndex = i = i + data.length + paddingLength + 1;
            if (code[3] == RadiusAvp.USER_PASSWORD.getIndex()) {
                data = DiameterFormat.trimPaddingZeros(data);
            }
            avps.add(RadiusAttributeUtil.createAttribute(dictionary, code[3], data));
        }
        return avps;
    }

    private static byte[] trimPaddingZeros(byte[] data) {
        int i;
        for (i = data.length - 1; i >= 0 && data[i] == 0; --i) {
        }
        return Arrays.copyOf(data, i + 1);
    }

    public static byte[] radiusAttribute2ByteArray(List<RadiusAttribute> attributeList) {
        ByteBuf target = Unpooled.buffer();
        for (RadiusAttribute attribute : attributeList) {
            byte[] attributeByteArray = attribute.toByteArray();
            byte[] data = Arrays.copyOfRange(attributeByteArray, 2, attributeByteArray.length);
            int diameterAttributeLength = 8 + data.length;
            target.writeInt(attribute.getType()).writeByte(64).writeMedium(diameterAttributeLength).writeBytes(data);
            int extraBoundByteCount = diameterAttributeLength % 4;
            if (extraBoundByteCount == 0) continue;
            int paddingByteCount = 4 - extraBoundByteCount;
            target.writeBytes(new byte[paddingByteCount]);
        }
        return ByteBufUtil.getBytes((ByteBuf)target);
    }
}

