/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.recordlayer.handshake;

import com.tplink.cdd.radius.common.tls.TlsPacketException;
import com.tplink.cdd.radius.common.tls.enums.HandshakeType;
import com.tplink.cdd.radius.common.tls.enums.TlsVersion;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.Certificate;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.CertificateVerify;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.ClientHello;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.ClientKeyExchange;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.Finished;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HandshakeProtocol {
    private static final Logger log = LoggerFactory.getLogger(HandshakeProtocol.class);
    private HandshakeType type;
    private int length;
    private ByteBuf data;

    public static HandshakeProtocol newInstance(short length, ByteBuf byteBuf, boolean finished, TlsVersion tlsVersion) throws TlsPacketException {
        ByteBuf handshakeProtocolByteBuf = byteBuf.readBytes((int)length);
        byte type = handshakeProtocolByteBuf.getByte(0);
        HandshakeType handshakeType = finished ? HandshakeType.FINISHED : HandshakeType.fromIndex(type);
        switch (handshakeType) {
            case CLIENT_HELLO: {
                return new ClientHello(handshakeProtocolByteBuf);
            }
            case CERTIFICATE: {
                return new Certificate(handshakeProtocolByteBuf);
            }
            case CLIENT_KEY_EXCHANGE: {
                return new ClientKeyExchange(handshakeProtocolByteBuf);
            }
            case CERTIFICATE_VERIFY: {
                return new CertificateVerify(handshakeProtocolByteBuf, tlsVersion);
            }
            case FINISHED: {
                return new Finished(handshakeProtocolByteBuf);
            }
        }
        log.error("Invalid handshake type! {}", (Object)handshakeType);
        return null;
    }

    HandshakeProtocol(HandshakeType type, ByteBuf byteBuf) {
        this.data = byteBuf.copy();
        this.type = type;
        if (Objects.equals((Object)HandshakeType.FINISHED, (Object)type)) {
            return;
        }
        byteBuf.readByte();
        this.length = byteBuf.readMedium();
    }

    protected void init(HandshakeType handshakeType) {
        ByteBuf data = Unpooled.buffer();
        ByteBuf otherData = this.getOtherData();
        if (!Objects.equals((Object)HandshakeType.FINISHED, (Object)handshakeType)) {
            this.setType(handshakeType);
            this.setLength(otherData.readableBytes());
            data.writeByte((int)this.getType().getIndex()).writeMedium(this.getLength());
        }
        data.writeBytes(otherData);
        this.setData(data);
    }

    protected abstract ByteBuf getOtherData();

    public HandshakeType getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public ByteBuf getData() {
        return this.data.copy();
    }

    public void setType(HandshakeType type) {
        this.type = type;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setData(ByteBuf data) {
        this.data = data;
    }

    public HandshakeProtocol() {
    }
}

