/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.recordlayer.handshake;

import com.tplink.cdd.radius.common.tls.enums.HandshakeType;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.HandshakeProtocol;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;

public class Finished
extends HandshakeProtocol {
    private ByteBuf encryptedClientFinished;
    private byte[] encryptedServerFinished;

    protected Finished(ByteBuf byteBuf) {
        super(HandshakeType.FINISHED, byteBuf);
        this.encryptedClientFinished = this.getData();
    }

    public Finished(byte[] encryptedClientFinished) {
        this.encryptedServerFinished = encryptedClientFinished;
        this.init(HandshakeType.FINISHED);
    }

    @Override
    protected ByteBuf getOtherData() {
        return Unpooled.buffer().writeBytes(this.encryptedServerFinished);
    }

    public ByteBuf getEncryptedClientFinished() {
        return this.encryptedClientFinished;
    }

    public byte[] getEncryptedServerFinished() {
        return this.encryptedServerFinished;
    }

    public String toString() {
        return "Finished(encryptedClientFinished=" + this.getEncryptedClientFinished() + ", encryptedServerFinished=" + Arrays.toString(this.getEncryptedServerFinished()) + ")";
    }
}

