/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.recordlayer.handshake;

import com.tplink.cdd.radius.common.tls.enums.HandshakeType;
import com.tplink.cdd.radius.common.tls.enums.TlsVersion;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.HandshakeProtocol;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHello
extends HandshakeProtocol {
    private static final Logger log = LoggerFactory.getLogger(ClientHello.class);
    private final TlsVersion version;
    private final byte[] random;
    private final List<Short> cipherSuiteList;

    protected ClientHello(ByteBuf byteBuf) {
        super(HandshakeType.CLIENT_HELLO, byteBuf);
        this.version = TlsVersion.fromIndex(byteBuf.readShort());
        this.random = ByteBufUtil.getBytes((ByteBuf)byteBuf.readBytes(32));
        byte sessionIdLength = byteBuf.readByte();
        byteBuf.readBytes((int)sessionIdLength);
        ArrayList<Short> cipherSuiteList = new ArrayList<Short>();
        short cipherSuitesLength = byteBuf.readShort();
        int cipherSuitesCount = cipherSuitesLength / 2;
        for (int i = 0; i < cipherSuitesCount; ++i) {
            cipherSuiteList.add(byteBuf.readShort());
        }
        this.cipherSuiteList = cipherSuiteList;
    }

    @Override
    protected ByteBuf getOtherData() {
        return null;
    }

    public TlsVersion getVersion() {
        return this.version;
    }

    public byte[] getRandom() {
        return this.random;
    }

    public List<Short> getCipherSuiteList() {
        return this.cipherSuiteList;
    }
}

