/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.recordlayer.handshake;

import com.tplink.cdd.radius.common.tls.enums.HandshakeType;
import com.tplink.cdd.radius.common.tls.enums.SignatureHashAlgorithm;
import com.tplink.cdd.radius.common.tls.enums.TlsVersion;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.HandshakeProtocol;
import io.netty.buffer.ByteBuf;

public class CertificateVerify
extends HandshakeProtocol {
    private TlsVersion tlsVersion;
    private SignatureHashAlgorithm signatureHashAlgorithm;
    private final int signatureLength;
    private final ByteBuf signature;

    protected CertificateVerify(ByteBuf byteBuf, TlsVersion tlsVersion) {
        super(HandshakeType.CERTIFICATE_VERIFY, byteBuf);
        this.tlsVersion = tlsVersion;
        if (tlsVersion == TlsVersion.V1_0 || tlsVersion == TlsVersion.V1_1) {
            this.signatureLength = byteBuf.readShort();
            this.signature = byteBuf.readBytes(this.signatureLength);
        } else {
            byte hashTag = byteBuf.readByte();
            byte signTag = byteBuf.readByte();
            this.signatureHashAlgorithm = SignatureHashAlgorithm.fromHashAndSign(hashTag, signTag);
            this.signatureLength = byteBuf.readShort();
            this.signature = byteBuf.readBytes(this.signatureLength);
        }
    }

    @Override
    protected ByteBuf getOtherData() {
        return null;
    }

    public int getSignatureLength() {
        return this.signatureLength;
    }

    public ByteBuf getSignature() {
        return this.signature;
    }

    public SignatureHashAlgorithm getSignatureHashAlgorithm() {
        return this.signatureHashAlgorithm;
    }

    public String toString() {
        return "CertificateVerify(tlsVersion=" + (Object)((Object)this.tlsVersion) + ", signatureHashAlgorithm=" + (Object)((Object)this.getSignatureHashAlgorithm()) + ", signatureLength=" + this.getSignatureLength() + ", signature=" + this.getSignature() + ")";
    }
}

