/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.recordlayer.handshake;

import com.tplink.cdd.radius.common.tls.enums.HandshakeType;
import com.tplink.cdd.radius.common.tls.enums.SignatureHashAlgorithm;
import com.tplink.cdd.radius.common.tls.enums.TlsVersion;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.HandshakeProtocol;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;

public class CertificateRequest
extends HandshakeProtocol {
    private TlsVersion tlsVersion;
    private byte certificateTypesCount;
    private byte[] certificateTypes;
    private short signatureHashAlgorithmsLength;
    private byte[] signatureHashAlgorithms;

    public CertificateRequest(TlsVersion tlsVersion, List<SignatureHashAlgorithm> signatureHashAlgorithms, byte ... certificateTypes) {
        this.tlsVersion = tlsVersion;
        if (tlsVersion == TlsVersion.V1_0 || tlsVersion == TlsVersion.V1_1) {
            this.certificateTypesCount = (byte)certificateTypes.length;
            this.certificateTypes = certificateTypes;
            this.init(HandshakeType.CERTIFICATE_REQUEST);
        } else {
            this.certificateTypesCount = (byte)certificateTypes.length;
            this.certificateTypes = certificateTypes;
            this.signatureHashAlgorithmsLength = (short)(signatureHashAlgorithms.size() * 2);
            this.signatureHashAlgorithms = new byte[this.signatureHashAlgorithmsLength];
            int i = 0;
            int j = 0;
            while (i < this.signatureHashAlgorithmsLength) {
                this.signatureHashAlgorithms[i] = signatureHashAlgorithms.get(j).getHash();
                this.signatureHashAlgorithms[i + 1] = signatureHashAlgorithms.get(j).getSignature();
                i += 2;
                ++j;
            }
            this.init(HandshakeType.CERTIFICATE_REQUEST);
        }
    }

    @Override
    protected ByteBuf getOtherData() {
        if (this.tlsVersion == TlsVersion.V1_0 || this.tlsVersion == TlsVersion.V1_1) {
            return Unpooled.buffer().writeByte((int)this.certificateTypesCount).writeBytes(this.certificateTypes).writeShort(0);
        }
        return Unpooled.buffer().writeByte((int)this.certificateTypesCount).writeBytes(this.certificateTypes).writeShort((int)this.signatureHashAlgorithmsLength).writeBytes(this.signatureHashAlgorithms).writeShort(0);
    }
}

