/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.recordlayer.handshake;

import com.tplink.cdd.radius.common.tls.TlsPacketException;
import com.tplink.cdd.radius.common.tls.enums.HandshakeType;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.HandshakeProtocol;
import com.tplink.cdd.radius.common.utils.CertificateUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Certificate
extends HandshakeProtocol {
    private static final Logger log = LoggerFactory.getLogger(Certificate.class);
    private static final int CLIENT_CERTIFICATE_INDEX = 0;
    private static final int CA_CERTIFICATE_INDEX = 1;
    private final int certificatesLength;
    private ByteBuf serverCertificates;
    private List<X509Certificate> clientCertificateChain;

    protected Certificate(ByteBuf byteBuf) throws TlsPacketException {
        super(HandshakeType.CERTIFICATE, byteBuf);
        this.certificatesLength = byteBuf.readMedium();
        ArrayList<X509Certificate> clientCertificateChain = new ArrayList<X509Certificate>();
        while (byteBuf.isReadable()) {
            X509Certificate certificate;
            int certificateLength = byteBuf.readMedium();
            ByteBuf certificateByteBuf = byteBuf.readBytes(certificateLength);
            try {
                certificate = (X509Certificate)CertificateUtil.certFromBuf(certificateByteBuf);
            }
            catch (CertificateException e) {
                throw new TlsPacketException("Failed to parse client certificate chain", e);
            }
            clientCertificateChain.add(certificate);
        }
        this.clientCertificateChain = clientCertificateChain;
    }

    public Certificate(ByteBuf serverCertificate, int certificatesLength) {
        this.serverCertificates = serverCertificate;
        this.certificatesLength = certificatesLength;
        this.init(HandshakeType.CERTIFICATE);
    }

    @Override
    protected ByteBuf getOtherData() {
        return Unpooled.buffer().writeMedium(this.certificatesLength).writeBytes(this.serverCertificates.copy());
    }

    public List<X509Certificate> getClientCertificateChain() {
        return this.clientCertificateChain;
    }

    public X509Certificate getClientCertificate() {
        return this.clientCertificateChain.get(0);
    }

    public X509Certificate getCaCertificate() {
        return this.clientCertificateChain.get(1);
    }

    public String toString() {
        return "Certificate(certificatesLength=" + this.certificatesLength + ", serverCertificates=" + this.serverCertificates + ", clientCertificateChain=" + this.getClientCertificateChain() + ")";
    }
}

