/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.recordlayer;

import com.tplink.cdd.radius.common.tls.CipherSuite.TlsCipher;
import com.tplink.cdd.radius.common.tls.TlsPacketException;
import com.tplink.cdd.radius.common.tls.enums.RecordLayerType;
import com.tplink.cdd.radius.common.tls.enums.TlsVersion;
import com.tplink.cdd.radius.common.tls.recordlayer.Alert;
import com.tplink.cdd.radius.common.tls.recordlayer.ApplicationData;
import com.tplink.cdd.radius.common.tls.recordlayer.ChangeCipherSpec;
import com.tplink.cdd.radius.common.tls.recordlayer.Handshake;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecordLayer {
    private static final Logger log = LoggerFactory.getLogger(RecordLayer.class);
    private RecordLayerType type;
    private TlsVersion version;
    private short length;

    RecordLayer(RecordLayerType type, ByteBuf byteBuf) {
        this.type = type;
        this.version = TlsVersion.fromIndex(byteBuf.readShort());
        this.length = byteBuf.readShort();
    }

    public static RecordLayer newInstance(ByteBuf byteBuf, TlsCipher tlsCipher, boolean finished) throws TlsPacketException {
        byte contentType = byteBuf.readByte();
        RecordLayerType recordLayerType = RecordLayerType.fromIndex(contentType);
        switch (recordLayerType) {
            case HANDSHAKE: {
                return new Handshake(byteBuf, finished);
            }
            case CHANGE_CIPHER_SPEC: {
                return new ChangeCipherSpec(byteBuf);
            }
            case APPLICATION_DATA: {
                return new ApplicationData(byteBuf, tlsCipher);
            }
            case ALERT: {
                return new Alert(byteBuf, tlsCipher);
            }
        }
        log.error("Invalid record layer type! {}", (Object)recordLayerType);
        return null;
    }

    protected void init(RecordLayerType recordLayerType, TlsVersion tlsVersion) {
        this.setType(recordLayerType);
        this.setVersion(tlsVersion);
        this.setLength((short)this.getOtherData().readableBytes());
    }

    public ByteBuf toByteBuf() {
        return Unpooled.buffer().writeByte((int)this.getType().getIndex()).writeShort((int)this.getVersion().getIndex()).writeShort((int)this.getLength()).writeBytes(this.getOtherData());
    }

    protected abstract ByteBuf getOtherData();

    public RecordLayerType getType() {
        return this.type;
    }

    public TlsVersion getVersion() {
        return this.version;
    }

    public short getLength() {
        return this.length;
    }

    public void setType(RecordLayerType type) {
        this.type = type;
    }

    public void setVersion(TlsVersion version) {
        this.version = version;
    }

    public void setLength(short length) {
        this.length = length;
    }

    public RecordLayer() {
    }
}

