/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.radius.common.tls.recordlayer;

import com.tplink.cdd.radius.common.tls.TlsPacketException;
import com.tplink.cdd.radius.common.tls.enums.RecordLayerType;
import com.tplink.cdd.radius.common.tls.enums.TlsVersion;
import com.tplink.cdd.radius.common.tls.recordlayer.RecordLayer;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.HandshakeProtocol;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Handshake
extends RecordLayer {
    private final List<HandshakeProtocol> handshakeProtocolList;

    protected Handshake(ByteBuf byteBuf, boolean finished) throws TlsPacketException {
        super(RecordLayerType.HANDSHAKE, byteBuf);
        this.handshakeProtocolList = Collections.singletonList(HandshakeProtocol.newInstance(this.getLength(), byteBuf, finished, this.getVersion()));
    }

    public Handshake(TlsVersion tlsVersion, HandshakeProtocol ... handshakeProtocols) {
        this.handshakeProtocolList = Arrays.asList(handshakeProtocols);
        this.init(RecordLayerType.HANDSHAKE, tlsVersion);
    }

    @Override
    protected ByteBuf getOtherData() {
        return this.handshakeProtocol2ByteBuf(this.handshakeProtocolList);
    }

    public List<HandshakeProtocol> getHandshakeProtocolList() {
        return this.handshakeProtocolList;
    }

    private ByteBuf handshakeProtocol2ByteBuf(List<HandshakeProtocol> handshakeProtocolList) {
        ByteBuf byteBuf = Unpooled.buffer();
        for (HandshakeProtocol handshakeProtocol : handshakeProtocolList) {
            byteBuf.writeBytes(handshakeProtocol.getData());
        }
        return byteBuf;
    }
}

